/*
 * Decompiled with CFR 0.152.
 */
package net.mrqx.huajiage.stand;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.mrqx.huajiage.HuaJiAgeMod;
import net.mrqx.huajiage.capability.stand.IStandData;
import net.mrqx.huajiage.client.HuaJiLayers;
import net.mrqx.huajiage.client.model.stand.ModelHierophantGreen;
import net.mrqx.huajiage.client.model.stand.ModelHierophantGreenIdle;
import net.mrqx.huajiage.client.model.stand.ModelStandBase;
import net.mrqx.huajiage.entity.EntityItemBullet;
import net.mrqx.huajiage.registy.HuaJiSoundEvents;
import net.mrqx.huajiage.stand.Stand;
import net.mrqx.huajiage.utils.HuaJiMathHelper;
import net.mrqx.huajiage.utils.HuaJiSoundPlayer;
import org.apache.commons.lang3.tuple.MutablePair;

public class StandHierophantGreen
extends Stand {
    public static final BiConsumer<LivingEntity, IStandData> HIEROPHANT_GREEN_TICK = (living, data) -> {
        Stand stand;
        if (living.m_9236_().m_46467_() % 5L == 0L && !living.m_9236_().f_46443_ && "huajiage.default".equals(data.getState()) && (stand = Stand.getStand(data.getStand())) != null) {
            EntityItemBullet bullet = new EntityItemBullet((LivingEntity)living, 0.0, 0.0, 0.0, living.m_9236_());
            bullet.setDelay(0L);
            Vec3 vec3 = HuaJiMathHelper.getPositionRelative2D((Entity)living, -0.55f, -0.6f);
            bullet.m_37010_(Items.f_42616_.m_7968_());
            bullet.setDamage(stand.getDamage((LivingEntity)living, (IStandData)data));
            bullet.m_146884_(living.m_20182_().m_82520_(vec3.f_82479_, (double)2.2f, vec3.f_82481_));
            bullet.m_37251_((Entity)living, living.m_146909_(), living.m_146908_(), 0.0f, 1.5f, 0.2f);
            bullet.m_146926_(living.m_146909_());
            bullet.m_146922_(living.m_146908_());
            bullet.m_146884_(bullet.m_20182_().m_82520_(0.0, -0.4, 0.0));
            living.m_9236_().m_7967_((Entity)bullet);
        }
    };
    public static final BiConsumer<LivingEntity, IStandData> HIEROPHANT_GREEN_DO_SKILL = (living, data) -> {
        Stand stand = Stand.getStand(data.getStand());
        if (stand != null && !living.m_9236_().f_46443_) {
            Vec3 look = living.m_20154_();
            List entities = living.m_9236_().m_45976_(LivingEntity.class, living.m_20191_().m_82400_(30.0));
            ArrayList<MutablePair> lockedGroup = new ArrayList<MutablePair>();
            boolean isLock = false;
            UUID uuid = null;
            Vec3 targetPos = living.m_20182_();
            if (!entities.isEmpty()) {
                for (LivingEntity i : entities) {
                    if (i == living) continue;
                    Vec3 vec = HuaJiMathHelper.getVectorEntityEye((Entity)living, (Entity)i);
                    float degree1 = (float)HuaJiMathHelper.getDegreeXZ(look, vec);
                    float degree2 = (float)HuaJiMathHelper.getDegreeXY(look, vec);
                    float degree3 = (float)HuaJiMathHelper.getDegreeXZ(look, vec);
                    if (!(degree1 < 15.0f) || !(degree2 < 15.0f) || !(degree3 < 15.0f)) continue;
                    isLock = true;
                    float degrees = Math.abs(degree1) + Math.abs(degree2) + Math.abs(degree3);
                    lockedGroup.add(new MutablePair((Object)i, (Object)Float.valueOf(degrees)));
                    break;
                }
            }
            if (isLock) {
                for (int index = 0; index < lockedGroup.size(); ++index) {
                    MutablePair pair = (MutablePair)lockedGroup.get(index);
                    if (pair.getLeft() == null) continue;
                    if (index > 0) {
                        if (!(((Float)pair.getRight()).floatValue() < ((Float)((MutablePair)lockedGroup.get(index - 1)).getRight()).floatValue())) continue;
                        uuid = ((LivingEntity)pair.getLeft()).m_20148_();
                        continue;
                    }
                    uuid = ((LivingEntity)pair.getLeft()).m_20148_();
                }
                if (!entities.isEmpty()) {
                    for (LivingEntity entity : entities) {
                        if (!entity.m_20148_().equals(uuid)) continue;
                        targetPos = entity.m_20182_();
                    }
                }
            } else {
                Vec3 start = living.m_20299_(1.0f);
                Vec3 end = start.m_82549_(living.m_20154_().m_82490_(30.0));
                BlockHitResult result = living.m_9236_().m_45547_(new ClipContext(start, end, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)living));
                targetPos = result.m_82450_();
            }
            for (int i = 0; i < 128; ++i) {
                float rx = (living.m_9236_().f_46441_.m_188501_() - 0.5f) * 40.0f;
                float ry = living.m_9236_().f_46441_.m_188501_() * 19.0f + 1.0f;
                float rz = (living.m_9236_().f_46441_.m_188501_() - 0.5f) * 40.0f;
                Vec3 pos = new Vec3(targetPos.f_82479_ + (double)rx, targetPos.f_82480_ + (double)ry, targetPos.f_82481_ + (double)rz);
                Vec3 finalTargetPos = targetPos;
                EntityItemBullet bullet = new EntityItemBullet((LivingEntity)living, 0.0, 0.0, 0.0, living.m_9236_(), bullet1 -> {
                    double pOffsetZ;
                    double pOffsetY;
                    double pOffsetX = finalTargetPos.f_82479_ - bullet1.m_20185_();
                    double d3 = Math.sqrt(pOffsetX * pOffsetX + (pOffsetY = finalTargetPos.f_82480_ - bullet1.m_20186_()) * pOffsetY + (pOffsetZ = finalTargetPos.f_82481_ - bullet1.m_20189_()) * pOffsetZ);
                    if (d3 != 0.0) {
                        bullet1.f_36813_ = pOffsetX / d3 * 0.1;
                        bullet1.f_36814_ = pOffsetY / d3 * 0.1;
                        bullet1.f_36815_ = pOffsetZ / d3 * 0.1;
                    }
                });
                bullet.m_37010_(Items.f_42616_.m_7968_());
                bullet.setDamage(stand.getDamage((LivingEntity)living, (IStandData)data));
                bullet.m_146884_(pos);
                bullet.setSplashHuge(true);
                bullet.setDelay(50L);
                bullet.m_146926_(360.0f * rx / 20.0f);
                bullet.m_146922_(360.0f * ry / 20.0f);
                living.m_9236_().m_7967_((Entity)bullet);
            }
            HuaJiSoundPlayer.playMovingSoundToClient((Entity)living, (SoundEvent)HuaJiSoundEvents.STAND_HIEROPHANT_GREEN_EMERALD_SPLASH.get());
        }
    };

    public StandHierophantGreen() {
        super(HIEROPHANT_GREEN_TICK, HIEROPHANT_GREEN_DO_SKILL);
    }

    @Override
    public void onTriggered(LivingEntity livingEntity, IStandData data) {
        super.onTriggered(livingEntity, data);
        HuaJiSoundPlayer.playMovingSoundToClient((Entity)livingEntity, livingEntity.m_9236_().m_213780_().m_188499_() ? (SoundEvent)HuaJiSoundEvents.STAND_HIEROPHANT_GREEN_SHOOT_1.get() : (SoundEvent)HuaJiSoundEvents.STAND_HIEROPHANT_GREEN_SHOOT_2.get());
    }

    @Override
    public int skillEnergyDemand(LivingEntity livingEntity, IStandData data) {
        return data.getLevel() > 0 ? 70000 : -1;
    }

    @Override
    public int getMaxLevel() {
        return 1;
    }

    @Override
    public float getDamage(LivingEntity livingEntity, IStandData data) {
        return 5 + data.getLevel() * 2;
    }

    @Override
    public float getSpeed(LivingEntity livingEntity, IStandData data) {
        return 1.0f;
    }

    @Override
    public int getDuration(LivingEntity livingEntity, IStandData data) {
        return 200;
    }

    @Override
    public float getDistance(LivingEntity livingEntity, IStandData data) {
        return 20.0f;
    }

    @Override
    public int chargePerTick(LivingEntity livingEntity, IStandData data) {
        return data.isTriggered() && data.getState().equals("huajiage.idle") ? 160 : 80;
    }

    @Override
    public List<String> getStates() {
        return List.of("huajiage.default", "huajiage.idle");
    }

    @Override
    public boolean shouldRenderExtra(LivingEntity livingEntity, IStandData data) {
        return data.getLevel() >= 1;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Stand.AbstractStandResource getStandResource() {
        return StandResource.INSTANCE;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class StandResource
    extends Stand.AbstractStandResource {
        @OnlyIn(value=Dist.CLIENT)
        public static final StandResource INSTANCE = new StandResource();
        @OnlyIn(value=Dist.CLIENT)
        public static final ModelLayerLocation DEFAULT_LAYER = HuaJiLayers.create("hierophant_green", "huajiage.default");
        @OnlyIn(value=Dist.CLIENT)
        public static final ModelLayerLocation IDLE_LAYER = HuaJiLayers.create("hierophant_green", "huajiage.idle");
        @OnlyIn(value=Dist.CLIENT)
        public static final Map<String, ModelLayerLocation> MODEL_LAYER_MAP = Map.of("huajiage.default", DEFAULT_LAYER, "huajiage.idle", IDLE_LAYER);
        @OnlyIn(value=Dist.CLIENT)
        public static final Map<String, ResourceLocation> TEXTURE_MAP = Map.of("huajiage.default", HuaJiAgeMod.prefix("textures/entity/stand/hierophant_green_default.png"), "huajiage.idle", HuaJiAgeMod.prefix("textures/entity/stand/hierophant_green_idle.png"));
        @OnlyIn(value=Dist.CLIENT)
        public static final Map<String, List<Double>> TRANSLATION_MAP = Map.of("huajiage.default", List.of(Double.valueOf(0.5), Double.valueOf(-1.0), Double.valueOf(0.75)), "huajiage.idle", List.of(Double.valueOf(0.8), Double.valueOf(-0.75), Double.valueOf(-0.7)));
        @OnlyIn(value=Dist.CLIENT)
        public static final Map<ModelLayerLocation, Supplier<LayerDefinition>> MODEL_MAP = Map.of(DEFAULT_LAYER, ModelHierophantGreen::createBodyLayer, IDLE_LAYER, ModelHierophantGreenIdle::createBodyLayer);
        @OnlyIn(value=Dist.CLIENT)
        public static final Map<ModelLayerLocation, Function<ModelPart, ModelStandBase>> MODEL_FUNCTION_MAP = Map.of(DEFAULT_LAYER, ModelHierophantGreen::new, IDLE_LAYER, ModelHierophantGreenIdle::new);

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public Map<String, ModelLayerLocation> getModelLocations() {
            return MODEL_LAYER_MAP;
        }

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public Map<String, ResourceLocation> getModelTextures() {
            return TEXTURE_MAP;
        }

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public Map<String, List<Double>> getModelTranslations() {
            return TRANSLATION_MAP;
        }

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public Map<ModelLayerLocation, Supplier<LayerDefinition>> getModels() {
            return MODEL_MAP;
        }

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public Map<ModelLayerLocation, Function<ModelPart, ModelStandBase>> getModelFunction() {
            return MODEL_FUNCTION_MAP;
        }
    }
}

