/*
 * Decompiled with CFR 0.152.
 */
package net.mrqx.huajiage.stand;

import com.mega.endinglib.util.time.TimeStopUtils;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.boss.EnderDragonPart;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.mrqx.huajiage.HuaJiAgeMod;
import net.mrqx.huajiage.capability.stand.IStandData;
import net.mrqx.huajiage.client.HuaJiLayers;
import net.mrqx.huajiage.client.model.stand.ModelStandBase;
import net.mrqx.huajiage.client.model.stand.ModelStarPlatinum;
import net.mrqx.huajiage.client.model.stand.ModelStarPlatinumIdle;
import net.mrqx.huajiage.data.HuaJiDamageTypes;
import net.mrqx.huajiage.entity.EntityRoadRoller;
import net.mrqx.huajiage.registy.HuaJiSoundEvents;
import net.mrqx.huajiage.stand.Stand;
import net.mrqx.huajiage.utils.HuaJiDamageSources;
import net.mrqx.huajiage.utils.HuaJiMathHelper;
import net.mrqx.huajiage.utils.HuaJiSoundPlayer;
import net.mrqx.huajiage.utils.StandUtils;

public class StandStarPlatinum
extends Stand {
    public static final BiConsumer<LivingEntity, IStandData> STAR_PLATINUM_TICK = (living, data) -> {
        Stand stand = Stand.getStand(data.getStand());
        if (stand instanceof StandStarPlatinum) {
            StandStarPlatinum starPlatinum = (StandStarPlatinum)stand;
            if (!living.m_9236_().f_46443_ && "huajiage.default".equals(data.getState())) {
                living.m_9236_().m_45976_(Entity.class, living.m_20191_().m_82400_((double)stand.getDistance((LivingEntity)living, (IStandData)data))).forEach(entity -> {
                    LivingEntity target;
                    if (HuaJiMathHelper.getDegreeXZ(living.m_20154_(), HuaJiMathHelper.getVectorEntityEye((Entity)living, entity)) > 120.0) {
                        return;
                    }
                    Vec3 back = HuaJiMathHelper.getVectorEntityEye((Entity)living, entity);
                    DamageSource damageSource = HuaJiDamageSources.simple((Entity)living, HuaJiDamageTypes.STAND_HIT);
                    if (entity instanceof EnderDragonPart) {
                        EnderDragonPart enderDragonPart = (EnderDragonPart)entity;
                        enderDragonPart.f_31010_.m_31120_(enderDragonPart.f_31010_.f_31080_, damageSource, stand.getDamage((LivingEntity)living, (IStandData)data));
                    } else if (entity instanceof LivingEntity && !(target = (LivingEntity)entity).equals(living)) {
                        boolean isTimeStopping;
                        boolean bl = isTimeStopping = TimeStopUtils.isTimeStop && TimeStopUtils.andSameDimension((Level)living.m_9236_());
                        if (living.m_9236_().m_46467_() % 4L == 0L || isTimeStopping) {
                            target.f_19802_ = 0;
                            target.m_6469_(damageSource, stand.getDamage((LivingEntity)living, (IStandData)data) / 2.0f);
                            target.f_19802_ = 0;
                            if (!isTimeStopping) {
                                living.m_9236_().m_46796_(2001, target.m_20183_().m_7918_(0, (int)(target.m_20299_((float)0.0f).f_82480_ - target.m_20182_().f_82480_), 0), Block.m_49956_((BlockState)Blocks.f_50080_.m_49966_()));
                            }
                            if (HuaJiMathHelper.getVectorEntityEye((Entity)living, (Entity)target).m_82553_() < (double)stand.getDistance((LivingEntity)living, (IStandData)data)) {
                                target.m_20256_(back);
                            }
                            starPlatinum.counter = starPlatinum.counter + (isTimeStopping ? 1 : 5);
                            if (data.getLevel() > 0 && starPlatinum.counter > 4) {
                                starPlatinum.counter = 0;
                                HuaJiSoundPlayer.playMovingSoundToClient((Entity)living, SoundEvents.f_11913_, 0.25f);
                                HuaJiSoundPlayer.playMovingSoundToClient((Entity)living, isTimeStopping ? (SoundEvent)HuaJiSoundEvents.STAND_STAR_PLATINUM_REPEAT_1.get() : (SoundEvent)HuaJiSoundEvents.STAND_STAR_PLATINUM_5.get(), isTimeStopping ? 1.0f : 0.3f);
                            }
                        }
                    } else if (!(entity instanceof ItemEntity) && !(entity instanceof ExperienceOrb)) {
                        if (entity instanceof EntityRoadRoller) {
                            EntityRoadRoller roadRoller = (EntityRoadRoller)((Object)((Object)entity));
                            roadRoller.m_6469_(damageSource, stand.getDamage((LivingEntity)living, (IStandData)data) / 2.0f);
                        } else {
                            entity.m_20256_(back.m_82490_((double)(stand.getDamage((LivingEntity)living, (IStandData)data) / 10.0f)));
                        }
                    }
                });
            }
        }
    };
    public static final BiConsumer<LivingEntity, IStandData> STAR_PLATINUM_DO_SKILL = (living, data) -> {
        int castTime;
        int time = (data.getLevel() > 1 ? 5 : 2) * 20;
        if (TimeStopUtils.isTimeStop && TimeStopUtils.andSameDimension((Level)living.m_9236_())) {
            castTime = 0;
        } else {
            castTime = 40;
            HuaJiSoundPlayer.playMovingSoundToClient((Entity)living, (SoundEvent)HuaJiSoundEvents.STAR_PLATINUM_THE_WORLD_1.get(), 5.0f);
        }
        StandUtils.castStandTimeStop(true, living, data, true, time, castTime);
        living.m_7292_(new MobEffectInstance(MobEffects.f_19600_, time + castTime, 1, false, false));
        living.m_7292_(new MobEffectInstance(MobEffects.f_19596_, time + castTime, 2, false, false));
        living.m_7292_(new MobEffectInstance(MobEffects.f_19603_, time + castTime, 1, false, false));
    };
    public int counter = 0;

    public StandStarPlatinum() {
        super(STAR_PLATINUM_TICK, STAR_PLATINUM_DO_SKILL);
    }

    @Override
    public void onTriggered(LivingEntity livingEntity, IStandData data) {
        super.onTriggered(livingEntity, data);
        SoundEvent soundEvent = switch (livingEntity.m_9236_().m_213780_().m_188503_(5)) {
            case 1 -> (SoundEvent)HuaJiSoundEvents.STAND_STAR_PLATINUM_2.get();
            case 2 -> (SoundEvent)HuaJiSoundEvents.STAND_STAR_PLATINUM_3.get();
            case 3 -> (SoundEvent)HuaJiSoundEvents.STAND_STAR_PLATINUM_4.get();
            default -> (SoundEvent)HuaJiSoundEvents.STAND_STAR_PLATINUM_1.get();
        };
        HuaJiSoundPlayer.playMovingSoundToClient((Entity)livingEntity, soundEvent);
    }

    @Override
    public float getDamage(LivingEntity livingEntity, IStandData data) {
        return 15.0f;
    }

    @Override
    public float getSpeed(LivingEntity livingEntity, IStandData data) {
        return 1.5f;
    }

    @Override
    public int getDuration(LivingEntity livingEntity, IStandData data) {
        return 275;
    }

    @Override
    public float getDistance(LivingEntity livingEntity, IStandData data) {
        return 2 + data.getLevel();
    }

    @Override
    public int chargePerTick(LivingEntity livingEntity, IStandData data) {
        return data.isTriggered() && data.getState().equals("huajiage.idle") ? 190 : 95;
    }

    @Override
    public int getMaxLevel() {
        return 2;
    }

    @Override
    public int skillEnergyDemand(LivingEntity livingEntity, IStandData data) {
        return data.getLevel() > 0 ? 50000 : -1;
    }

    @Override
    public List<String> getStates() {
        return List.of("huajiage.default", "huajiage.idle");
    }

    @Override
    public boolean shouldRenderHand(LivingEntity livingEntity, IStandData data) {
        return !data.isTriggered() || !data.getState().equals("huajiage.default");
    }

    @Override
    public boolean shouldRenderExtra(LivingEntity livingEntity, IStandData data) {
        return data.getLevel() >= 1;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Stand.AbstractStandResource getStandResource() {
        return StandResource.INSTANCE;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class StandResource
    extends Stand.AbstractStandResource {
        @OnlyIn(value=Dist.CLIENT)
        public static final StandResource INSTANCE = new StandResource();
        @OnlyIn(value=Dist.CLIENT)
        public static final ModelLayerLocation DEFAULT_LAYER = HuaJiLayers.create("star_platinum", "huajiage.default");
        @OnlyIn(value=Dist.CLIENT)
        public static final ModelLayerLocation IDLE_LAYER = HuaJiLayers.create("star_platinum", "huajiage.idle");
        @OnlyIn(value=Dist.CLIENT)
        public static final Map<String, ModelLayerLocation> MODEL_LAYER_MAP = Map.of("huajiage.default", DEFAULT_LAYER, "huajiage.idle", IDLE_LAYER);
        @OnlyIn(value=Dist.CLIENT)
        public static final Map<String, ResourceLocation> TEXTURE_MAP = Map.of("huajiage.default", HuaJiAgeMod.prefix("textures/entity/stand/star_platinum_default.png"), "huajiage.idle", HuaJiAgeMod.prefix("textures/entity/stand/star_platinum_idle.png"));
        @OnlyIn(value=Dist.CLIENT)
        public static final Map<String, List<Double>> TRANSLATION_MAP = Map.of("huajiage.default", List.of(Double.valueOf(0.0), Double.valueOf(-0.2), Double.valueOf(-0.75)), "huajiage.idle", List.of(Double.valueOf(0.0), Double.valueOf(-0.7), Double.valueOf(0.5)));
        @OnlyIn(value=Dist.CLIENT)
        public static final Map<ModelLayerLocation, Supplier<LayerDefinition>> MODEL_MAP = Map.of(DEFAULT_LAYER, ModelStarPlatinum::createBodyLayer, IDLE_LAYER, ModelStarPlatinumIdle::createBodyLayer);
        @OnlyIn(value=Dist.CLIENT)
        public static final Map<ModelLayerLocation, Function<ModelPart, ModelStandBase>> MODEL_FUNCTION_MAP = Map.of(DEFAULT_LAYER, ModelStarPlatinum::new, IDLE_LAYER, ModelStarPlatinumIdle::new);

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public Map<String, ModelLayerLocation> getModelLocations() {
            return MODEL_LAYER_MAP;
        }

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public Map<String, ResourceLocation> getModelTextures() {
            return TEXTURE_MAP;
        }

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public Map<String, List<Double>> getModelTranslations() {
            return TRANSLATION_MAP;
        }

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public Map<ModelLayerLocation, Supplier<LayerDefinition>> getModels() {
            return MODEL_MAP;
        }

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public Map<ModelLayerLocation, Function<ModelPart, ModelStandBase>> getModelFunction() {
            return MODEL_FUNCTION_MAP;
        }
    }
}

