/*
 * Decompiled with CFR 0.152.
 */
package net.mrqx.huajiage.utils;

import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class HuaJiMathHelper {
    public static Vec3 getVectorEntity(Entity source, Entity target) {
        BlockPos eaterPos = source.m_20183_();
        BlockPos targetPos = target.m_20183_();
        return new Vec3((double)(targetPos.m_123341_() - eaterPos.m_123341_()), (double)(targetPos.m_123342_() - eaterPos.m_123342_()), (double)(targetPos.m_123343_() - eaterPos.m_123343_())).m_82541_();
    }

    public static Vec3 getVectorEntityEye(Entity source, Entity target) {
        Vec3 eaterPos = source.m_20299_(0.0f);
        Vec3 targetPos = target.m_20299_(0.0f);
        return new Vec3(targetPos.f_82479_ - eaterPos.f_82479_, targetPos.f_82480_ - eaterPos.f_82480_, targetPos.f_82481_ - eaterPos.f_82481_).m_82541_();
    }

    public static Vec3 getVector(Vec3 sourcePos, Vec3 targetPos) {
        return new Vec3(targetPos.f_82479_ - sourcePos.f_82479_, targetPos.f_82480_ - sourcePos.f_82480_, targetPos.f_82481_ - sourcePos.f_82481_).m_82541_();
    }

    public static double getDistance(Vec3 sourcePos, Vec3 targetPos) {
        return new Vec3(targetPos.f_82479_ - sourcePos.f_82479_, targetPos.f_82480_ - sourcePos.f_82480_, targetPos.f_82481_ - sourcePos.f_82481_).m_82553_();
    }

    public static double getDistance(BlockPos sourcePos, BlockPos targetPos) {
        return new Vec3((double)(targetPos.m_123341_() - sourcePos.m_123341_()), (double)(targetPos.m_123342_() - sourcePos.m_123342_()), (double)(targetPos.m_123343_() - sourcePos.m_123343_())).m_82553_();
    }

    public static float getAABBSize(AABB box) {
        float a = Math.abs((float)(box.f_82291_ - box.f_82288_));
        float b = Math.abs((float)(box.f_82292_ - box.f_82289_));
        float c = Math.abs((float)(box.f_82293_ - box.f_82290_));
        return a * b * c;
    }

    public static double getDegreeXZ(Vec3 v1, Vec3 v2) {
        Vec3 vec1 = v1.m_82520_(0.0, -v1.f_82480_, 0.0).m_82541_();
        Vec3 vec2 = v2.m_82520_(0.0, -v2.f_82480_, 0.0).m_82541_();
        double cos = (vec1.f_82479_ * vec2.f_82479_ + vec1.f_82481_ * vec2.f_82481_) / (vec1.m_82553_() * vec2.m_82553_());
        return Math.round(Math.toDegrees(Math.acos(cos)));
    }

    public static double getDegreeXY(Vec3 v1, Vec3 v2) {
        Vec3 vec1 = v1.m_82520_(0.0, 0.0, -v1.f_82481_).m_82541_();
        Vec3 vec2 = v2.m_82520_(0.0, 0.0, -v2.f_82481_).m_82541_();
        double cos = (vec1.f_82479_ * vec2.f_82479_ + vec1.f_82480_ * vec2.f_82480_) / (vec1.m_82553_() * vec2.m_82553_());
        return Math.round(Math.toDegrees(Math.acos(cos)));
    }

    public static double getDegreeZY(Vec3 v1, Vec3 v2) {
        Vec3 vec1 = v1.m_82520_(-v1.f_82479_, 0.0, 0.0).m_82541_();
        Vec3 vec2 = v2.m_82520_(-v2.f_82479_, 0.0, 0.0).m_82541_();
        double cos = (vec1.f_82481_ * vec2.f_82481_ + vec1.f_82480_ * vec2.f_82480_) / (vec1.m_82553_() * vec2.m_82553_());
        return Math.round(Math.toDegrees(Math.acos(cos)));
    }

    public static Vec3 getVecPlus(Vec3 v1, Vec3 v2, double l1, double l2) {
        return new Vec3(l1 * v1.f_82479_ + l2 * v2.f_82479_, l1 * v1.f_82480_ + l2 * v2.f_82480_, l1 * v1.f_82481_ + l2 * v2.f_82481_);
    }

    public static Vec3 getVecPlus(Vec3 v1, Vec3 v2, Vec3 v3, double l1, double l2, double l3) {
        return new Vec3(l1 * v1.f_82479_ + l2 * v2.f_82479_ + l3 * v3.f_82479_, l1 * v1.f_82480_ + l2 * v2.f_82480_ + l3 * v3.f_82480_, l1 * v1.f_82481_ + l2 * v2.f_82481_ + l3 * v3.f_82481_);
    }

    public static Vec3 getVecCross(Vec3 v1, Vec3 v2) {
        return new Vec3(v1.f_82480_ * v2.f_82481_ - v1.f_82481_ * v2.f_82480_, -v1.f_82479_ * v2.f_82481_ + v1.f_82481_ * v2.f_82479_, v1.f_82479_ * v2.f_82480_ - v1.f_82480_ * v2.f_82479_);
    }

    public static Vec3 getPositionRelative2D(Entity entity, float x, float z) {
        float yaw = entity.m_146908_();
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            yaw = living.f_20883_;
        }
        Vec3 forward = HuaJiMathHelper.getVectorForRotation(0.0f, yaw);
        Vec3 vertical = HuaJiMathHelper.getVectorForRotation(0.0f, yaw + 90.0f);
        return HuaJiMathHelper.getVecPlus(vertical, forward, x, z);
    }

    public static Vec3 getVectorForRotation(float pitch, float yaw) {
        double f = Math.cos(-yaw * ((float)Math.PI / 180) - (float)Math.PI);
        double f1 = Math.sin(-yaw * ((float)Math.PI / 180) - (float)Math.PI);
        double f2 = -Math.cos(-pitch * ((float)Math.PI / 180));
        double f3 = Math.sin(-pitch * ((float)Math.PI / 180));
        return new Vec3(f1 * f2, f3, f * f2);
    }
}

