/*
 * Decompiled with CFR 0.152.
 */
package net.mrqx.huajiage.utils;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Contract;

public class ItemTagHelper {
    private static final int[] EMPTY_INT_ARRAY = new int[0];
    private static final long[] EMPTY_LONG_ARRAY = new long[0];

    public static void set(ItemStack stack, String tag, Tag nbt) {
        stack.m_41784_().m_128365_(tag, nbt);
    }

    public static void setBoolean(ItemStack stack, String tag, boolean b) {
        stack.m_41784_().m_128379_(tag, b);
    }

    public static void setByte(ItemStack stack, String tag, byte b) {
        stack.m_41784_().m_128344_(tag, b);
    }

    public static void setShort(ItemStack stack, String tag, short s) {
        stack.m_41784_().m_128376_(tag, s);
    }

    public static void setInt(ItemStack stack, String tag, int i) {
        stack.m_41784_().m_128405_(tag, i);
    }

    public static void setIntArray(ItemStack stack, String tag, int[] val) {
        stack.m_41784_().m_128385_(tag, val);
    }

    public static void setLong(ItemStack stack, String tag, long l) {
        stack.m_41784_().m_128356_(tag, l);
    }

    public static void setLongArray(ItemStack stack, String tag, long[] val) {
        stack.m_41784_().m_128388_(tag, val);
    }

    public static void setFloat(ItemStack stack, String tag, float f) {
        stack.m_41784_().m_128350_(tag, f);
    }

    public static void setDouble(ItemStack stack, String tag, double d) {
        stack.m_41784_().m_128347_(tag, d);
    }

    public static void setCompound(ItemStack stack, String tag, CompoundTag cmp) {
        if (!"Enchantments".equalsIgnoreCase(tag)) {
            stack.m_41784_().m_128365_(tag, (Tag)cmp);
        }
    }

    public static void setString(ItemStack stack, String tag, String s) {
        stack.m_41784_().m_128359_(tag, s);
    }

    public static void setList(ItemStack stack, String tag, ListTag list) {
        stack.m_41784_().m_128365_(tag, (Tag)list);
    }

    public static void removeEntry(ItemStack stack, String tag) {
        stack.m_41749_(tag);
    }

    public static boolean verifyExistance(ItemStack stack, String tag) {
        return !stack.m_41619_() && stack.m_41782_() && stack.m_41784_().m_128441_(tag);
    }

    public static boolean verifyType(ItemStack stack, String tag, Class<? extends Tag> tagClass) {
        return !stack.m_41619_() && stack.m_41782_() && tagClass.isInstance(stack.m_41784_().m_128423_(tag));
    }

    @Nullable
    public static Tag get(ItemStack stack, String tag) {
        return ItemTagHelper.verifyExistance(stack, tag) ? stack.m_41784_().m_128423_(tag) : null;
    }

    public static boolean getBoolean(ItemStack stack, String tag, boolean defaultExpected) {
        return ItemTagHelper.verifyExistance(stack, tag) ? stack.m_41784_().m_128471_(tag) : defaultExpected;
    }

    public static byte getByte(ItemStack stack, String tag, byte defaultExpected) {
        return ItemTagHelper.verifyExistance(stack, tag) ? stack.m_41784_().m_128445_(tag) : defaultExpected;
    }

    public static short getShort(ItemStack stack, String tag, short defaultExpected) {
        return ItemTagHelper.verifyExistance(stack, tag) ? stack.m_41784_().m_128448_(tag) : defaultExpected;
    }

    public static int getInt(ItemStack stack, String tag, int defaultExpected) {
        return ItemTagHelper.verifyExistance(stack, tag) ? stack.m_41784_().m_128451_(tag) : defaultExpected;
    }

    public static int[] getIntArray(ItemStack stack, String tag) {
        return ItemTagHelper.verifyExistance(stack, tag) ? stack.m_41784_().m_128465_(tag) : EMPTY_INT_ARRAY;
    }

    public static long getLong(ItemStack stack, String tag, long defaultExpected) {
        return ItemTagHelper.verifyExistance(stack, tag) ? stack.m_41784_().m_128454_(tag) : defaultExpected;
    }

    public static long[] getLongArray(ItemStack stack, String tag) {
        return ItemTagHelper.verifyExistance(stack, tag) ? stack.m_41784_().m_128467_(tag) : EMPTY_LONG_ARRAY;
    }

    public static float getFloat(ItemStack stack, String tag, float defaultExpected) {
        return ItemTagHelper.verifyExistance(stack, tag) ? stack.m_41784_().m_128457_(tag) : defaultExpected;
    }

    public static double getDouble(ItemStack stack, String tag, double defaultExpected) {
        return ItemTagHelper.verifyExistance(stack, tag) ? stack.m_41784_().m_128459_(tag) : defaultExpected;
    }

    @Nullable
    @Contract(value="_, _, false -> !null")
    public static CompoundTag getCompound(ItemStack stack, String tag, boolean nullifyOnFail) {
        return ItemTagHelper.verifyExistance(stack, tag) ? stack.m_41784_().m_128469_(tag) : (nullifyOnFail ? null : new CompoundTag());
    }

    @Nullable
    @Contract(value="_, _, !null -> !null")
    public static String getString(ItemStack stack, String tag, @Nullable String defaultExpected) {
        return ItemTagHelper.verifyExistance(stack, tag) ? stack.m_41784_().m_128461_(tag) : defaultExpected;
    }

    @Nullable
    @Contract(value="_, _, _, false -> !null")
    public static ListTag getList(ItemStack stack, String tag, int objType, boolean nullifyOnFail) {
        return ItemTagHelper.verifyExistance(stack, tag) ? stack.m_41784_().m_128437_(tag, objType) : (nullifyOnFail ? null : new ListTag());
    }

    public static JsonObject serializeStack(ItemStack stack) {
        CompoundTag nbt = stack.m_41739_(new CompoundTag());
        byte c = nbt.m_128445_("Count");
        if (c != 1) {
            nbt.m_128344_("count", c);
        }
        nbt.m_128473_("Count");
        ItemTagHelper.renameTag(nbt, "id", "item");
        ItemTagHelper.renameTag(nbt, "tag", "nbt");
        Dynamic dyn = new Dynamic((DynamicOps)NbtOps.f_128958_, (Object)nbt);
        return ((JsonElement)dyn.convert((DynamicOps)JsonOps.INSTANCE).getValue()).getAsJsonObject();
    }

    public static void renameTag(CompoundTag nbt, String oldName, String newName) {
        Tag tag = nbt.m_128423_(oldName);
        if (tag != null) {
            nbt.m_128473_(oldName);
            nbt.m_128365_(newName, tag);
        }
    }
}

