/*
 * Decompiled with CFR 0.152.
 */
package net.mrqx.huajiage.utils;

import com.mega.endinglib.EndingLibrary;
import com.mega.endinglib.common.data.TimeStopSavedData;
import com.mega.endinglib.common.network.PacketHandler;
import com.mega.endinglib.common.network.s2c.timestop.TSDimensionSynchedPacket;
import com.mega.endinglib.config.CommonConfig;
import com.mega.endinglib.util.time.TimeStopEntityData;
import com.mega.endinglib.util.time.TimeStopUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.timers.TimerCallback;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.network.PacketDistributor;
import net.mrqx.huajiage.capability.stand.IStandData;
import net.mrqx.huajiage.network.NetworkManager;
import net.mrqx.huajiage.network.TimeStopEffectMessage;

public class StandUtils {
    public static void castStandTimeStop(boolean isStop, LivingEntity source, IStandData data, boolean force, int time, int castTime) {
        if (castTime <= 0) {
            StandUtils.standTimeStop(isStop, source, force, time);
            MinecraftServer server = source.m_20194_();
            if (server != null) {
                TimeStopEffectMessage message = new TimeStopEffectMessage();
                message.level = source.m_9236_().m_46472_().m_135782_();
                message.effectStartTick = source.m_9236_().m_46467_();
                message.effectDuration = time;
                message.entityId = source.m_19879_();
                server.m_6846_().m_11314_().forEach(serverPlayer -> NetworkManager.INSTANCE.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)message));
            }
        } else {
            data.getScheduler().schedule("StandTimeStop", castTime, (TimerCallback<LivingEntity>)((TimerCallback)(living, manager, gameTime) -> {
                StandUtils.standTimeStop(isStop, source, force, time);
                MinecraftServer server = source.m_20194_();
                if (server != null) {
                    TimeStopEffectMessage message = new TimeStopEffectMessage();
                    message.level = source.m_9236_().m_46472_().m_135782_();
                    message.effectStartTick = source.m_9236_().m_46467_();
                    message.effectDuration = time;
                    message.entityId = source.m_19879_();
                    server.m_6846_().m_11314_().forEach(serverPlayer -> NetworkManager.INSTANCE.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)message));
                }
            }));
        }
    }

    public static void standTimeStop(boolean isTimeStop, LivingEntity source, boolean force, int time) {
        if (isTimeStop && !CommonConfig.enableTS) {
            EndingLibrary.LOGGER.warn("Time Stop Settings is disabled in the common-config.");
        } else {
            if (source.m_9236_().f_46443_) {
                throw new RuntimeException("time stop should be called on server side.");
            }
            Level level = source.m_9236_();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                if (!isTimeStop) {
                    for (LivingEntity living : source.m_9236_().m_45976_(LivingEntity.class, new AABB(new BlockPos(0, 0, 0)).m_82400_(3.0E7))) {
                        if (living == source || TimeStopEntityData.getTimeStopCount((LivingEntity)living) <= 0 || !living.m_6084_()) continue;
                        if (force) {
                            TimeStopEntityData.setTimeStopCount((LivingEntity)source, (int)0);
                        }
                        return;
                    }
                }
                if (!(TimeStopUtils.isTimeStop = isTimeStop)) {
                    TimeStopSavedData.readOrCreate((MinecraftServer)serverLevel.m_7654_()).removeTsDimension(source.m_9236_().m_46472_());
                }
                if (TimeStopUtils.isTimeStop) {
                    PacketHandler.sendToAll((Object)new TSDimensionSynchedPacket(new ResourceLocation(""), source.m_9236_().m_46472_().m_135782_()));
                } else {
                    PacketHandler.sendToAll((Object)new TSDimensionSynchedPacket(source.m_9236_().m_46472_().m_135782_(), new ResourceLocation("")));
                }
                if (isTimeStop) {
                    TimeStopSavedData.readOrCreate((MinecraftServer)serverLevel.m_7654_()).addTsDimension(source.m_9236_().m_46472_());
                    TimeStopEntityData.setTimeStopCount((LivingEntity)source, (int)Math.max(TimeStopEntityData.getTimeStopCount((LivingEntity)source), time));
                } else if (force) {
                    TimeStopEntityData.setTimeStopCount((LivingEntity)source, (int)0);
                }
            }
        }
    }
}

