/*
 * Decompiled with CFR 0.152.
 */
package net.mrqx.huajiage.entity;

import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.network.PlayMessages;
import net.mrqx.huajiage.HuaJiAgeMod;
import net.mrqx.huajiage.entity.EntityItemBullet;
import net.mrqx.huajiage.entity.ExplosionHuaJi;
import net.mrqx.huajiage.registy.HuaJiItems;
import net.mrqx.huajiage.utils.HuaJiDamageSources;

public class EntityOrgaHairKnife
extends ThrowableItemProjectile {
    private static final EntityDataAccessor<Float> DAMAGE = SynchedEntityData.m_135353_(EntityOrgaHairKnife.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Long> LIFE = SynchedEntityData.m_135353_(EntityOrgaHairKnife.class, (EntityDataSerializer)EntityDataSerializers.f_244073_);
    private static final EntityDataAccessor<Float> ROTATION_RANDOM = SynchedEntityData.m_135353_(EntityOrgaHairKnife.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private boolean hasExploded = false;

    public EntityOrgaHairKnife(EntityType<? extends ThrowableItemProjectile> entityType, Level level) {
        super(entityType, level);
        this.setRotationRandom(level.f_46441_.m_188501_());
    }

    public EntityOrgaHairKnife(LivingEntity shooter, Level level) {
        super(HuaJiAgeMod.RegistryEvents.orgaHairKnifeEntityType, shooter, level);
        this.setRotationRandom(level.f_46441_.m_188501_());
    }

    public static EntityOrgaHairKnife createInstance(PlayMessages.SpawnEntity packet, Level worldIn) {
        return new EntityOrgaHairKnife(HuaJiAgeMod.RegistryEvents.orgaHairKnifeEntityType, worldIn);
    }

    public static EntityOrgaHairKnife create(EntityType<? extends ThrowableItemProjectile> pEntityType, Level pLevel) {
        return new EntityOrgaHairKnife(pEntityType, pLevel);
    }

    protected Item m_7881_() {
        return (Item)HuaJiItems.ORGA_HAIR_KNIFE.get();
    }

    @Nullable
    public ItemStack getPickedResult(HitResult target) {
        return this.m_7846_();
    }

    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128350_("damage", this.getDamage());
        pCompound.m_128356_("life", this.getLife());
        pCompound.m_128350_("rotation_random", this.getRotationRandom());
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DAMAGE, (Object)Float.valueOf(5.0f));
        this.f_19804_.m_135372_(LIFE, (Object)200L);
        this.f_19804_.m_135372_(ROTATION_RANDOM, (Object)Float.valueOf(0.0f));
    }

    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.setDamage(pCompound.m_128457_("damage"));
        this.setLife(pCompound.m_128454_("life"));
        this.setRotationRandom(pCompound.m_128457_("rotation_random"));
    }

    public void m_8119_() {
        this.setLife(this.getLife() - 1L);
        super.m_8119_();
        double r1 = (this.m_9236_().f_46441_.m_188500_() - 0.5) * 0.2;
        double r2 = (this.m_9236_().f_46441_.m_188500_() - 0.5) * 0.2;
        double r3 = (this.m_9236_().f_46441_.m_188500_() - 0.5) * 0.2;
        if (r1 > 0.05) {
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123815_, this.m_20185_() + r1, this.m_20188_() + r2, this.m_20189_() + r3, r1, r2, r3);
        }
        if (this.getLife() < 0L) {
            this.m_146870_();
        }
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        return false;
    }

    protected void m_8060_(BlockHitResult pResult) {
        super.m_8060_(pResult);
        if (!this.hasExploded) {
            this.explode();
            this.setLife(1L);
        }
    }

    protected void m_5790_(EntityHitResult pResult) {
        super.m_5790_(pResult);
        if (!(pResult.m_82443_() instanceof EntityItemBullet || pResult.m_82443_().equals((Object)this.m_19749_()) || this.hasExploded)) {
            this.explode();
            this.setLife(1L);
        }
    }

    protected void explode() {
        this.hasExploded = true;
        ExplosionHuaJi explosion = new ExplosionHuaJi(this.m_9236_(), this.m_19749_(), HuaJiDamageSources.hopeFlower(this.m_9236_(), (Entity)this, this.m_19749_(), this.m_20182_()), null, this.m_20185_(), this.m_20186_(), this.m_20189_(), 1.5f, Explosion.BlockInteraction.KEEP, this.getDamage(), 0.0, false);
        explosion.m_46061_();
        explosion.m_46075_(true);
    }

    public float getDamage() {
        return ((Float)this.f_19804_.m_135370_(DAMAGE)).floatValue();
    }

    public void setDamage(float damage) {
        this.f_19804_.m_135381_(DAMAGE, (Object)Float.valueOf(damage));
    }

    public long getLife() {
        return (Long)this.f_19804_.m_135370_(LIFE);
    }

    public void setLife(long life) {
        this.f_19804_.m_135381_(LIFE, (Object)life);
    }

    public float getRotationRandom() {
        return ((Float)this.f_19804_.m_135370_(ROTATION_RANDOM)).floatValue();
    }

    public void setRotationRandom(float rot) {
        this.f_19804_.m_135381_(ROTATION_RANDOM, (Object)Float.valueOf(rot));
    }
}

