/*
 * Decompiled with CFR 0.152.
 */
package net.mrqx.huajiage.item;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.entity.PartEntity;
import net.mrqx.huajiage.capability.stand.IStandData;
import net.mrqx.huajiage.capability.stand.StandDataCapabilityProvider;
import net.mrqx.huajiage.entity.ExplosionHuaJi;
import net.mrqx.huajiage.item.BaseItem;
import net.mrqx.huajiage.stand.Stand;
import net.mrqx.huajiage.stand.StandKillerQueen;
import net.mrqx.huajiage.utils.HuaJiDamageSources;
import net.mrqx.huajiage.utils.ItemTagHelper;
import org.jetbrains.annotations.Nullable;

public class ItemKillerQueenTrigger
extends BaseItem {
    public static final String TRIGGER_LIST_KEY = "huajiage.killerQueenTrigger.list";
    public static final String TRIGGER_ENTITY_UUID_KEY = "huajiage.killerQueenTrigger.entityUuid";
    public static final String TRIGGER_BLOCK_POS_KEY = "huajiage.killerQueenTrigger.blockPos";

    public ItemKillerQueenTrigger() {
        super(new Item.Properties().m_41497_(Rarity.COMMON).m_41487_(1));
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        super.m_7373_(stack, level, tooltip, flag);
        List<Trigger> triggers = ItemKillerQueenTrigger.getTriggers(stack);
        triggers.forEach(trigger -> {
            if (trigger.targetUuid != null) {
                tooltip.add((Component)Component.m_237110_((String)"item.huajiage.killer_queen_trigger.tooltips.entity", (Object[])new Object[]{trigger.targetUuid}).m_130940_(ChatFormatting.AQUA));
            }
            if (trigger.targetBlock != null) {
                tooltip.add((Component)Component.m_237110_((String)"item.huajiage.killer_queen_trigger.tooltips.block", (Object[])new Object[]{Component.m_237110_((String)"chat.coordinates", (Object[])new Object[]{trigger.targetBlock.m_123341_(), trigger.targetBlock.m_123342_(), trigger.targetBlock.m_123343_()}).m_130940_(ChatFormatting.GREEN)}).m_130940_(ChatFormatting.AQUA));
            }
        });
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand usedHand) {
        ItemStack itemStack = player.m_21120_(usedHand);
        AtomicBoolean flag = new AtomicBoolean(false);
        player.getCapability(StandDataCapabilityProvider.STAND_DATA).ifPresent(data -> {
            Stand stand = Stand.getStand(data.getStand());
            if (stand instanceof StandKillerQueen) {
                int cost = stand.skillEnergyDemand((LivingEntity)player, (IStandData)data) / 10;
                if (data.getEnergy() >= (long)cost) {
                    player.m_6672_(usedHand);
                    if (level instanceof ServerLevel) {
                        ServerLevel serverLevel = (ServerLevel)level;
                        List<Trigger> triggers = ItemKillerQueenTrigger.getTriggers(itemStack);
                        triggers.forEach(trigger -> {
                            Vec3 targetPos = trigger.getTargetPos(serverLevel);
                            if (targetPos != null) {
                                ItemKillerQueenTrigger.explode(level, (Entity)player, targetPos, 20 + data.getLevel() * 40, data.getLevel());
                                flag.set(true);
                            }
                        });
                        if (!flag.get()) {
                            player.m_213846_((Component)Component.m_237115_((String)"message.huajiage.killer_queen_trigger.failed.not_found").m_130940_(ChatFormatting.GRAY));
                        } else {
                            data.setEnergy(data.getEnergy() - (long)cost);
                        }
                    }
                } else {
                    player.m_213846_((Component)Component.m_237115_((String)"message.huajiage.killer_queen_trigger.failed.mp_lack").m_130940_(ChatFormatting.GRAY));
                }
            } else {
                player.m_213846_((Component)Component.m_237115_((String)"message.huajiage.killer_queen_trigger.failed.stand").m_130940_(ChatFormatting.GRAY));
            }
        });
        player.m_21011_(usedHand, true);
        if (flag.get()) {
            player.m_36246_(Stats.f_12982_.m_12902_((Object)itemStack.m_41720_()));
            if (!player.m_150110_().f_35937_) {
                itemStack.m_41774_(1);
            }
            return InteractionResultHolder.m_19090_((Object)itemStack);
        }
        return InteractionResultHolder.m_19096_((Object)itemStack);
    }

    public static List<Trigger> getTriggers(ItemStack itemStack) {
        ArrayList<Trigger> triggerList = new ArrayList<Trigger>();
        ListTag list = ItemTagHelper.getList(itemStack, TRIGGER_LIST_KEY, 10, false);
        list.forEach(tag -> {
            if (tag instanceof CompoundTag) {
                CompoundTag compoundTag = (CompoundTag)tag;
                if (compoundTag.m_128403_(TRIGGER_ENTITY_UUID_KEY)) {
                    triggerList.add(new Trigger().setTarget(compoundTag.m_128342_(TRIGGER_ENTITY_UUID_KEY)));
                } else if (compoundTag.m_128425_(TRIGGER_BLOCK_POS_KEY, 11)) {
                    int[] posArray = compoundTag.m_128465_(TRIGGER_BLOCK_POS_KEY);
                    triggerList.add(new Trigger().setTarget(new BlockPos(posArray[0], posArray[1], posArray[2])));
                }
            }
        });
        return triggerList;
    }

    public static void setTriggers(ItemStack itemStack, List<Trigger> triggerList) {
        ListTag list = new ListTag();
        triggerList.forEach(trigger -> {
            CompoundTag compoundTag = new CompoundTag();
            if (trigger.targetUuid != null) {
                compoundTag.m_128362_(TRIGGER_ENTITY_UUID_KEY, trigger.targetUuid);
            }
            if (trigger.targetBlock != null) {
                compoundTag.m_128408_(TRIGGER_BLOCK_POS_KEY, List.of(Integer.valueOf(trigger.targetBlock.m_123341_()), Integer.valueOf(trigger.targetBlock.m_123342_()), Integer.valueOf(trigger.targetBlock.m_123343_())));
            }
            if (!compoundTag.m_128456_()) {
                list.add((Object)compoundTag);
            }
        });
        ItemTagHelper.setList(itemStack, TRIGGER_LIST_KEY, list);
    }

    public static void addTrigger(ItemStack itemStack, Trigger trigger, int max) {
        List<Trigger> triggers = ItemKillerQueenTrigger.getTriggers(itemStack);
        triggers.add(trigger);
        while (triggers.size() > max) {
            triggers.remove(0);
        }
        ItemKillerQueenTrigger.setTriggers(itemStack, triggers);
    }

    public static void explode(Level level, Entity entity, Vec3 targetPos, double damage, int standLevel) {
        DamageSource damageSource = HuaJiDamageSources.standHit(level, entity, entity, entity.m_20182_());
        ExplosionHuaJi explosion = new ExplosionHuaJi(level, entity, damageSource, null, targetPos.f_82479_, targetPos.f_82480_, targetPos.f_82481_, 3 + standLevel, Explosion.BlockInteraction.KEEP, damage, 0.0, true, target -> {
            if (standLevel > 0 && target.m_20182_().m_82554_(targetPos) <= 2.0 && target.m_9236_().f_46441_.m_188500_() < 0.1) {
                ItemKillerQueenTrigger.killerQueenDeath(target, damageSource);
            }
        });
        explosion.m_46061_();
        explosion.m_46075_(true);
    }

    public static void killerQueenDeath(Entity target, DamageSource damageSource) {
        if (target instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)target;
            living.m_21153_(1.0f);
            living.f_19802_ = 0;
            living.m_6469_(damageSource, living.m_21233_());
            living.f_19802_ = 0;
        } else if (target instanceof PartEntity) {
            PartEntity part = (PartEntity)target;
            ItemKillerQueenTrigger.killerQueenDeath(part.getParent(), damageSource);
        } else {
            target.m_6074_();
        }
    }

    public static class Trigger {
        @Nullable
        private UUID targetUuid = null;
        @Nullable
        private BlockPos targetBlock = null;

        public Trigger setTarget(UUID entity) {
            this.targetUuid = entity;
            this.targetBlock = null;
            return this;
        }

        public Trigger setTarget(BlockPos blockPos) {
            this.targetBlock = blockPos;
            this.targetUuid = null;
            return this;
        }

        @Nullable
        public Vec3 getTargetPos(ServerLevel level) {
            if (this.targetUuid != null) {
                Entity entity = level.m_8791_(this.targetUuid);
                if (entity != null) {
                    return entity.m_20182_();
                }
            } else if (this.targetBlock != null) {
                return this.targetBlock.m_252807_();
            }
            return null;
        }
    }
}

