/*
 * Decompiled with CFR 0.152.
 */
package net.mrqx.huajiage.item.equipment;

import java.util.List;
import java.util.Locale;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.mrqx.huajiage.HuaJiAgeMod;
import net.mrqx.huajiage.data.HuaJiDamageTypes;
import net.mrqx.huajiage.entity.EntityHeroArrow;
import net.mrqx.huajiage.mixin.AccessorLivingEntity;
import net.mrqx.huajiage.registy.HuaJiItems;
import net.mrqx.huajiage.registy.HuaJiSoundEvents;
import net.mrqx.huajiage.utils.AdvancementHelper;
import net.mrqx.huajiage.utils.HuaJiDamageSources;
import net.mrqx.huajiage.utils.HuaJiSoundPlayer;
import net.mrqx.huajiage.utils.ItemTagHelper;
import org.jetbrains.annotations.Nullable;

@Mod.EventBusSubscriber
public class ItemHeroBow
extends BowItem {
    public ItemHeroBow() {
        super(new Item.Properties().m_41497_(Rarity.EPIC).m_41486_().m_41503_(384));
    }

    public String m_5671_(ItemStack pStack) {
        if (Mode.getMode(pStack).equals((Object)Mode.ON)) {
            return super.m_5671_(pStack) + ".on";
        }
        return super.m_5671_(pStack);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        String key;
        String translated;
        int index = 1;
        while (!(translated = Component.m_237115_((String)(key = this.m_5524_() + ".tooltips." + index)).getString()).toLowerCase(Locale.ENGLISH).equals(key)) {
            tooltip.add((Component)Component.m_237115_((String)key).m_130940_(index == 1 ? ChatFormatting.DARK_RED : ChatFormatting.GOLD));
            ++index;
        }
        tooltip.add((Component)Component.m_237110_((String)"item.huajiage.tooltips.shift.1", (Object[])new Object[]{Minecraft.m_91087_().f_91066_.f_92090_.m_90863_().m_6881_().m_130944_(new ChatFormatting[]{ChatFormatting.YELLOW, ChatFormatting.ITALIC})}).m_130940_(ChatFormatting.DARK_RED));
        if (Screen.m_96638_()) {
            tooltip.add((Component)Component.m_237110_((String)"message.huajiage.prefix", (Object[])new Object[]{Component.m_237115_((String)(this.m_5524_() + ".tooltips.shift.1")).m_130940_(ChatFormatting.YELLOW)}));
            tooltip.add((Component)Component.m_237110_((String)"message.huajiage.prefix", (Object[])new Object[]{Mode.getMode(stack).equals((Object)Mode.ON) ? Component.m_237115_((String)(this.m_5524_() + ".tooltips.shift.on.1")).m_130944_(new ChatFormatting[]{ChatFormatting.YELLOW, ChatFormatting.BOLD}) : Component.m_237110_((String)(this.m_5524_() + ".tooltips.shift.2"), (Object[])new Object[]{Minecraft.m_91087_().f_91066_.f_92090_.m_90863_().m_6881_().m_130944_(new ChatFormatting[]{ChatFormatting.YELLOW, ChatFormatting.ITALIC}), Minecraft.m_91087_().f_91066_.f_92096_.m_90863_().m_6881_().m_130944_(new ChatFormatting[]{ChatFormatting.YELLOW, ChatFormatting.ITALIC})}).m_130940_(ChatFormatting.AQUA)}));
        }
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level pLevel, Player pPlayer, InteractionHand pHand) {
        ItemStack itemstack = pPlayer.m_21120_(pHand);
        pPlayer.m_6672_(pHand);
        return InteractionResultHolder.m_19096_((Object)itemstack);
    }

    public void m_5551_(ItemStack pStack, Level pLevel, LivingEntity pEntityLiving, int pTimeLeft) {
        if (pEntityLiving instanceof Player) {
            float f;
            Player player = (Player)pEntityLiving;
            ItemStack itemstack = player.m_6298_(pStack);
            int i = ForgeEventFactory.onArrowLoose((ItemStack)pStack, (Level)pLevel, (Player)player, (int)(this.m_8105_(pStack) - pTimeLeft), (boolean)true);
            if (i < 0) {
                return;
            }
            if (itemstack.m_41619_()) {
                itemstack = Items.f_42412_.m_7968_();
            }
            if ((double)(f = ItemHeroBow.m_40661_((int)i)) >= 0.1) {
                if (!pLevel.f_46443_) {
                    int k;
                    int j;
                    boolean isOn;
                    ArrowItem arrowitem = (ArrowItem)(itemstack.m_41720_() instanceof ArrowItem ? itemstack.m_41720_() : Items.f_42412_);
                    AbstractArrow abstractarrow = arrowitem.m_6394_(pLevel, itemstack, (LivingEntity)player);
                    boolean bl = isOn = Mode.getMode(pStack).equals((Object)Mode.ON) && f >= 1.0f;
                    if (isOn) {
                        abstractarrow = new EntityHeroArrow(HuaJiAgeMod.RegistryEvents.heroArrowEntityType, pEntityLiving, pLevel);
                        abstractarrow.m_36767_((byte)127);
                    }
                    abstractarrow.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, f * (float)(isOn ? 10 : 6), 1.0f);
                    if (f >= 1.0f) {
                        abstractarrow.m_36762_(true);
                    }
                    if ((j = pStack.getEnchantmentLevel(Enchantments.f_44988_)) > 0) {
                        abstractarrow.m_36781_(abstractarrow.m_36789_() + (double)j * 0.5 + 0.5);
                    }
                    if ((k = pStack.getEnchantmentLevel(Enchantments.f_44989_)) > 0) {
                        abstractarrow.m_36735_(k);
                    }
                    if (pStack.getEnchantmentLevel(Enchantments.f_44990_) > 0) {
                        abstractarrow.m_20254_(100);
                    }
                    pStack.m_41622_(1, (LivingEntity)player, player1 -> player1.m_21190_(player.m_7655_()));
                    abstractarrow.f_36705_ = AbstractArrow.Pickup.CREATIVE_ONLY;
                    if (player.m_21023_(MobEffects.f_19600_)) {
                        int l = Objects.requireNonNull(player.m_21124_(MobEffects.f_19600_)).m_19564_();
                        abstractarrow.m_36781_(abstractarrow.m_36789_() + (double)l * 2.0);
                    }
                    pLevel.m_7967_((Entity)abstractarrow);
                    if (isOn) {
                        AccessorLivingEntity accessor;
                        if (player instanceof AccessorLivingEntity && !(accessor = (AccessorLivingEntity)player).huaJiAgeInvokeCheckTotemDeathProtection(pLevel.m_269111_().m_269075_(player))) {
                            player.m_6469_(HuaJiDamageSources.simpleNullSource(pLevel, HuaJiDamageTypes.STELLA), player.m_21233_() * 5.0f);
                        }
                        AdvancementHelper.grantCriterion((LivingEntity)player, AdvancementHelper.STELLA);
                        HuaJiSoundPlayer.playMovingSoundToClient((Entity)player, (SoundEvent)HuaJiSoundEvents.STELLA.get());
                    }
                }
                HuaJiSoundPlayer.playMovingSoundToClient((Entity)player, SoundEvents.f_11687_, 1.0f, 1.0f / (pLevel.m_213780_().m_188501_() * 0.4f + 1.2f) + f * 0.5f);
                player.m_36246_(Stats.f_12982_.m_12902_((Object)itemstack.m_41720_()));
            }
        }
    }

    @SubscribeEvent
    public static void onLeftClick(PlayerInteractEvent event) {
        if (!event.getEntity().m_21205_().m_150930_((Item)HuaJiItems.HERO_BOW.get()) || !event.getEntity().m_6144_() || event.getEntity().m_36335_().m_41519_((Item)HuaJiItems.HERO_BOW.get())) {
            return;
        }
        Player player = event.getEntity();
        if (event instanceof PlayerInteractEvent.LeftClickBlock || event instanceof PlayerInteractEvent.LeftClickEmpty) {
            Mode.changeMode(player.m_21205_());
            player.m_36335_().m_41524_((Item)HuaJiItems.HERO_BOW.get(), 10);
            if (Mode.getMode(player.m_21205_()).equals((Object)Mode.ON)) {
                player.m_213846_((Component)Component.m_237115_((String)"message.huajiage.stella_warning").m_130940_(ChatFormatting.YELLOW));
                HuaJiSoundPlayer.playMovingSoundToClient((Entity)player, SoundEvents.f_11894_);
            }
        }
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        LivingEntity living;
        super.m_6883_(stack, level, entity, slotId, isSelected);
        if (entity instanceof LivingEntity && (living = (LivingEntity)entity).m_21205_().equals(stack)) {
            living.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 260, 2));
            living.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 260, 2));
            living.m_7292_(new MobEffectInstance(MobEffects.f_19600_, 260, 3));
            living.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 260, 2));
            living.m_7292_(new MobEffectInstance(MobEffects.f_19611_, 300, 0));
            if (living.m_21023_(MobEffects.f_19614_)) {
                living.m_21195_(MobEffects.f_19614_);
            }
            if (living.m_21023_(MobEffects.f_19615_)) {
                living.m_21195_(MobEffects.f_19615_);
            }
        }
    }

    public static enum Mode {
        ON,
        OFF;


        public static Mode getMode(ItemStack itemStack) {
            if (ItemTagHelper.getBoolean(itemStack, "hero_bow_mode", false)) {
                return ON;
            }
            return OFF;
        }

        public static Mode changeMode(ItemStack itemStack) {
            if (Mode.getMode(itemStack) == OFF) {
                ItemTagHelper.setBoolean(itemStack, "hero_bow_mode", true);
                return ON;
            }
            ItemTagHelper.setBoolean(itemStack, "hero_bow_mode", false);
            return OFF;
        }
    }
}

