/*
 * Decompiled with CFR 0.152.
 */
package net.mrqx.huajiage.item.equipment.armor;

import java.util.Locale;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.Level;
import net.mrqx.huajiage.item.equipment.armor.HuaJiArmorMaterials;
import org.jetbrains.annotations.Nullable;

public abstract class ItemHuajiArmor
extends ArmorItem {
    public ItemHuajiArmor(ArmorItem.Type pType) {
        super((ArmorMaterial)HuaJiArmorMaterials.HUAJI, pType, new Item.Properties().m_41497_(Rarity.UNCOMMON));
    }

    @Nullable
    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, @Nullable String type) {
        return String.format(Locale.ROOT, "huajiage:textures/models/armor/huaji_layer_%d%s.png", slot == EquipmentSlot.LEGS ? 2 : 1, type == null ? "" : String.format(Locale.ROOT, "_%s", type));
    }

    public static class ItemHuajiArmorBoots
    extends ItemHuajiArmor {
        public ItemHuajiArmorBoots() {
            super(ArmorItem.Type.BOOTS);
        }

        public void onInventoryTick(ItemStack stack, Level level, Player player, int slotIndex, int selectedIndex) {
            if (((ItemStack)player.m_150109_().f_35975_.get(0)).equals(stack)) {
                player.m_7292_(new MobEffectInstance(MobEffects.f_19603_, 200, 0, false, false));
            }
        }
    }

    public static class ItemHuajiArmorLeggings
    extends ItemHuajiArmor {
        public ItemHuajiArmorLeggings() {
            super(ArmorItem.Type.LEGGINGS);
        }

        public void onInventoryTick(ItemStack stack, Level level, Player player, int slotIndex, int selectedIndex) {
            if (((ItemStack)player.m_150109_().f_35975_.get(1)).equals(stack)) {
                player.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 200, 0, false, false));
            }
        }
    }

    public static class ItemHuajiArmorChestplate
    extends ItemHuajiArmor {
        public ItemHuajiArmorChestplate() {
            super(ArmorItem.Type.CHESTPLATE);
        }

        public void onInventoryTick(ItemStack stack, Level level, Player player, int slotIndex, int selectedIndex) {
            if (((ItemStack)player.m_150109_().f_35975_.get(2)).equals(stack)) {
                player.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 200, 0, false, false));
            }
        }
    }

    public static class ItemHuajiArmorHelmet
    extends ItemHuajiArmor {
        public ItemHuajiArmorHelmet() {
            super(ArmorItem.Type.HELMET);
        }
    }
}

