/*
 * Decompiled with CFR 0.152.
 */
package net.mrqx.huajiage.compat.slashblade.registy;

import java.util.function.Consumer;
import mods.flammpfeil.slashblade.SlashBlade;
import mods.flammpfeil.slashblade.ability.StunManager;
import mods.flammpfeil.slashblade.event.client.UserPoseOverrider;
import mods.flammpfeil.slashblade.event.handler.FallHandler;
import mods.flammpfeil.slashblade.registry.combo.ComboState;
import mods.flammpfeil.slashblade.slasharts.WaveEdge;
import mods.flammpfeil.slashblade.util.AdvancementHelper;
import mods.flammpfeil.slashblade.util.AttackManager;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;
import net.mrqx.huajiage.HuaJiAgeMod;
import net.mrqx.huajiage.compat.slashblade.specialeffect.SwornKinship;

public class HuaJiComboStates {
    public static final DeferredRegister<ComboState> COMBO_STATE = DeferredRegister.create((ResourceKey)ComboState.REGISTRY_KEY, (String)"huajiage");
    public static final RegistryObject<ComboState> WAVE_SLASH_PRE = COMBO_STATE.register("wave_slash_pre", () -> ((ComboState.Builder)ComboState.Builder.newInstance().startAndEnd(1900, 1923).priority(65).next(entity -> HuaJiAgeMod.prefix("wave_slash_pre")).nextOfTimeout(entity -> HuaJiAgeMod.prefix("wave_slash")).addTickAction(e -> {
        long elapsed = ComboState.getElapsed((LivingEntity)e);
        if (elapsed == 0L) {
            e.m_5496_(SoundEvents.f_12520_, 0.8f, 0.625f + 0.1f * e.m_217043_().m_188501_());
            AdvancementHelper.grantCriterion((LivingEntity)e, (ResourceLocation)AdvancementHelper.ADVANCEMENT_JUDGEMENT_CUT);
        }
        if (elapsed <= 3L) {
            e.m_19920_(-0.3f, new Vec3(0.0, 0.0, 1.0));
            Vec3 vec = e.m_20184_();
            double d0 = vec.f_82479_;
            double d1 = vec.f_82481_;
            while (d0 != 0.0 && e.m_9236_().m_45756_((Entity)e, e.m_20191_().m_82386_(d0, (double)(-e.m_274421_()), 0.0))) {
                if (d0 < 0.05 && d0 >= -0.05) {
                    d0 = 0.0;
                    continue;
                }
                if (d0 > 0.0) {
                    d0 -= 0.05;
                    continue;
                }
                d0 += 0.05;
            }
            while (d1 != 0.0 && e.m_9236_().m_45756_((Entity)e, e.m_20191_().m_82386_(0.0, (double)(-e.m_274421_()), d1))) {
                if (d1 < 0.05 && d1 >= -0.05) {
                    d1 = 0.0;
                    continue;
                }
                if (d1 > 0.0) {
                    d1 -= 0.05;
                    continue;
                }
                d1 += 0.05;
            }
            while (d0 != 0.0 && d1 != 0.0 && e.m_9236_().m_45756_((Entity)e, e.m_20191_().m_82386_(d0, (double)(-e.m_274421_()), d1))) {
                d0 = d0 < 0.05 && d0 >= -0.05 ? 0.0 : (d0 > 0.0 ? (d0 -= 0.05) : (d0 += 0.05));
                if (d1 < 0.05 && d1 >= -0.05) {
                    d1 = 0.0;
                    continue;
                }
                if (d1 > 0.0) {
                    d1 -= 0.05;
                    continue;
                }
                d1 += 0.05;
            }
            vec = new Vec3(d0, vec.f_82480_, d1);
            e.m_6478_(MoverType.SELF, vec);
        }
        e.m_20256_(e.m_20184_().m_82542_(0.0, 1.0, 0.0));
    }).addTickAction(FallHandler::fallDecrease).addTickAction(UserPoseOverrider::resetRot)).build());
    public static final RegistryObject<ComboState> WAVE_SLASH = COMBO_STATE.register("wave_slash", () -> ((ComboState.Builder)ComboState.Builder.newInstance().startAndEnd(2000, 2019).priority(60).next(living -> AttackManager.isPowered((LivingEntity)living) && SwornKinship.isEffective(living) ? HuaJiAgeMod.prefix("wave_slash_quick") : HuaJiAgeMod.prefix("wave_slash")).nextOfTimeout(entity -> HuaJiAgeMod.prefix("wave_slash_end")).addHoldAction(living -> {
        int elapsed = living.m_21252_();
        if (elapsed < 2) {
            return;
        }
        AttributeModifier rapidSlashReach = new AttributeModifier("RapidSlashReach", -3.0, AttributeModifier.Operation.ADDITION);
        AttributeInstance attributeInstance = living.m_21051_((Attribute)ForgeMod.ENTITY_REACH.get());
        if (attributeInstance != null) {
            attributeInstance.m_22118_(rapidSlashReach);
        }
        AttackManager.areaAttack((LivingEntity)living, livingEntity -> {}, (float)0.44f, (boolean)true, (boolean)false, (boolean)true);
        if (attributeInstance != null) {
            attributeInstance.m_22130_(rapidSlashReach);
        }
    }).addTickAction(living -> {
        long elapsed = ComboState.getElapsed((LivingEntity)living);
        if (elapsed == 0L) {
            living.m_9236_().m_6263_(null, living.m_20185_(), living.m_20186_(), living.m_20189_(), SoundEvents.f_11677_, SoundSource.PLAYERS, 1.0f, 1.0f);
        }
        if (elapsed <= 3L && living.m_20096_()) {
            living.m_19920_(living.m_20069_() ? 1.25f : 0.8f, new Vec3(0.0, 0.0, 1.0));
        }
        Vec3 centerOffset = AttackManager.genRushOffset((LivingEntity)living);
        if (2L <= elapsed && elapsed < 6L) {
            float roll = -45.0f + 90.0f * living.m_217043_().m_188501_();
            if (elapsed % 2L == 0L) {
                roll += 180.0f;
            }
            boolean critical = AttackManager.isPowered((LivingEntity)living);
            AttackManager.doSlash((LivingEntity)living, (float)roll, (Vec3)centerOffset, (boolean)false, (boolean)critical, (double)0.4f);
            WaveEdge.doSlash((LivingEntity)living, (float)roll, (int)100, (Vec3)Vec3.f_82478_, (boolean)critical, (double)0.2f, (float)2.0f, (float)2.0f, (int)1);
        }
        if (elapsed == 7L) {
            AttackManager.doSlash((LivingEntity)living, (float)-30.0f, (Vec3)centerOffset, (boolean)false, (boolean)true, (double)0.4f);
            WaveEdge.doSlash((LivingEntity)living, (float)-30.0f, (int)100, (Vec3)Vec3.f_82478_, (boolean)true, (double)0.2f, (float)2.0f, (float)2.0f, (int)4);
        }
        if (7L <= elapsed && elapsed <= 10L) {
            UserPoseOverrider.setRot((Entity)living, (float)90.0f, (boolean)true);
        }
        if (10L < elapsed) {
            UserPoseOverrider.setRot((Entity)living, (float)0.0f, (boolean)false);
        }
    }).addHitEffect(StunManager::setStun).releaseAction(ComboState::releaseActionQuickCharge)).build());
    public static final RegistryObject<ComboState> WAVE_SLASH_QUICK = COMBO_STATE.register("wave_slash_quick", () -> ((ComboState.Builder)ComboState.Builder.newInstance().startAndEnd(2000, 2001).priority(70).next(entity -> HuaJiAgeMod.prefix("wave_slash_quick")).nextOfTimeout(entity -> HuaJiAgeMod.prefix("wave_slash")).addTickAction((Consumer)ComboState.TimeLineTickAction.getBuilder().put(0, AttackManager::playQuickSheathSoundAction).build()).releaseAction(ComboState::releaseActionQuickCharge)).build());
    public static final RegistryObject<ComboState> WAVE_SLASH_END = COMBO_STATE.register("wave_slash_end", () -> ((ComboState.Builder)ComboState.Builder.newInstance().startAndEnd(2019, 2054).priority(70).next(entity -> SlashBlade.prefix((String)"none")).nextOfTimeout(entity -> HuaJiAgeMod.prefix("wave_slash_end2")).releaseAction(ComboState::releaseActionQuickCharge)).build());
    public static final RegistryObject<ComboState> WAVE_SLASH_END2 = COMBO_STATE.register("wave_slash_end2", () -> ((ComboState.Builder)ComboState.Builder.newInstance().startAndEnd(2054, 2073).priority(70).next(entity -> SlashBlade.prefix((String)"none")).nextOfTimeout(entity -> SlashBlade.prefix((String)"none")).addTickAction((Consumer)ComboState.TimeLineTickAction.getBuilder().put(0, AttackManager::playQuickSheathSoundAction).build()).releaseAction(ComboState::releaseActionQuickCharge)).build());
}

