/*
 * Decompiled with CFR 0.152.
 */
package net.mrqx.huajiage.event.handler;

import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Abilities;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;
import net.mrqx.huajiage.capability.stand.IStandData;
import net.mrqx.huajiage.capability.stand.StandDataCapabilityProvider;
import net.mrqx.huajiage.data.HuaJiDamageTypes;
import net.mrqx.huajiage.event.HuaJiCanFlyEvent;
import net.mrqx.huajiage.network.NetworkManager;
import net.mrqx.huajiage.network.StandSyncMessage;
import net.mrqx.huajiage.stand.Stand;
import net.mrqx.huajiage.utils.AdvancementHelper;
import net.mrqx.huajiage.utils.HuaJiDamageSources;
import net.mrqx.huajiage.utils.HuaJiSoundPlayer;

@Mod.EventBusSubscriber
public class TickHandler {
    public static final String HUAJI_FLY_KEY = "huajiage.flying";

    @SubscribeEvent
    public static void onPlayerTickEvent(TickEvent.PlayerTickEvent event) {
        Player player = event.player;
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            CompoundTag persistentData = serverPlayer.getPersistentData();
            HuaJiCanFlyEvent canFlyEvent = new HuaJiCanFlyEvent(serverPlayer);
            MinecraftForge.EVENT_BUS.post((Event)canFlyEvent);
            if (canFlyEvent.canFly()) {
                serverPlayer.m_150110_().f_35936_ = true;
                serverPlayer.m_6885_();
                persistentData.m_128379_(HUAJI_FLY_KEY, true);
            } else if (persistentData.m_128471_(HUAJI_FLY_KEY)) {
                Abilities abilities = new Abilities();
                serverPlayer.f_8941_.m_9290_().m_46398_(abilities);
                if (!abilities.f_35936_) {
                    serverPlayer.m_150110_().f_35936_ = false;
                    serverPlayer.m_150110_().f_35935_ = false;
                    serverPlayer.m_6885_();
                }
                persistentData.m_128379_(HUAJI_FLY_KEY, false);
            }
            if (persistentData.m_128425_("huajiage.singularityCount", 3)) {
                int count = persistentData.m_128451_("huajiage.singularityCount");
                if (count <= 0 && serverPlayer.m_6084_()) {
                    persistentData.m_128473_("huajiage.singularityCount");
                    serverPlayer.getCapability(StandDataCapabilityProvider.STAND_DATA).ifPresent(data -> {
                        Stand stand = Stand.getStand(data.getStand());
                        if (stand != null && stand.getMaxLevel() >= data.getLevel() + 1) {
                            data.setLevel(Math.min(stand.getMaxLevel(), data.getLevel() + 1));
                            HuaJiSoundPlayer.playMovingSoundToClient((Entity)serverPlayer, SoundEvents.f_12496_, 2.0f);
                            AdvancementHelper.grantCriterion(serverPlayer, AdvancementHelper.SINGULARITY);
                            Level patt3661$temp = serverPlayer.m_9236_();
                            if (patt3661$temp instanceof ServerLevel) {
                                ServerLevel level = (ServerLevel)patt3661$temp;
                                Vec3 targetCoordinates = serverPlayer.m_146892_();
                                for (int d = 0; d < 360; d += 15) {
                                    level.m_8767_((ParticleOptions)ParticleTypes.f_123767_, targetCoordinates.f_82479_ + 0.5 * Math.sin(d), targetCoordinates.f_82480_ + 0.1, targetCoordinates.f_82481_ + 0.5 * Math.cos(d), 0, 0.5 * Math.sin(d), 0.0, 0.5 * Math.cos(d), 1.0);
                                }
                            }
                        }
                    });
                } else {
                    persistentData.m_128405_("huajiage.singularityCount", count - 1);
                    serverPlayer.getCapability(StandDataCapabilityProvider.STAND_DATA).ifPresent(data -> serverPlayer.m_6469_(HuaJiDamageSources.simpleNullSource(serverPlayer.m_9236_(), HuaJiDamageTypes.SINGULARITY), (float)data.getLevel()));
                    serverPlayer.m_6469_(HuaJiDamageSources.simpleNullSource(serverPlayer.m_9236_(), HuaJiDamageTypes.SINGULARITY), 1.0f);
                    if (!serverPlayer.m_6084_()) {
                        persistentData.m_128473_("huajiage.singularityCount");
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public static void onLivingTickEvent(LivingEvent.LivingTickEvent event) {
        event.getEntity().getCapability(StandDataCapabilityProvider.STAND_DATA).ifPresent(data -> {
            Stand stand = Stand.getStand(data.getStand());
            data.getScheduler().onTick(event.getEntity());
            if (stand != null) {
                stand.tick(event.getEntity(), (IStandData)data);
            }
            if (!event.getEntity().m_9236_().f_46443_) {
                StandSyncMessage message = new StandSyncMessage();
                message.data = IStandData.serializeNBT(data);
                message.entityId = event.getEntity().m_19879_();
                event.getEntity().m_9236_().m_6907_().forEach(player -> {
                    if (player instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = (ServerPlayer)player;
                        NetworkManager.INSTANCE.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)message);
                    }
                });
            }
        });
    }
}

