/*
 * Decompiled with CFR 0.152.
 */
package net.mrqx.huajiage.item.equipment;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.entity.player.CriticalHitEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.mrqx.huajiage.data.HuaJiDamageTypes;
import net.mrqx.huajiage.init.HuaJiTiers;
import net.mrqx.huajiage.registy.HuaJiItems;
import net.mrqx.huajiage.registy.HuaJiSoundEvents;
import net.mrqx.huajiage.utils.HuaJiDamageSources;
import net.mrqx.huajiage.utils.HuaJiMathHelper;
import net.mrqx.huajiage.utils.HuaJiSoundPlayer;
import net.mrqx.huajiage.utils.ItemTagHelper;
import org.jetbrains.annotations.Nullable;

@Mod.EventBusSubscriber
public class ItemExglutenbur
extends SwordItem {
    public ItemExglutenbur() {
        super((Tier)HuaJiTiers.EXGLUTENBUR.get(), 6, -2.4f, new Item.Properties().m_41497_(Rarity.EPIC).m_41486_().m_41503_(5400));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.m_237110_((String)(this.m_5524_() + ".tooltips.1"), (Object[])new Object[]{Minecraft.m_91087_().f_91066_.f_92090_.m_90863_().m_6881_().m_130944_(new ChatFormatting[]{ChatFormatting.YELLOW, ChatFormatting.ITALIC}), Minecraft.m_91087_().f_91066_.f_92095_.m_90863_().m_6881_().m_130944_(new ChatFormatting[]{ChatFormatting.YELLOW, ChatFormatting.ITALIC})}).m_130944_(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.BOLD}));
        switch (Flavor.getFlavor(stack)) {
            case FRAGRANT: {
                tooltip.add((Component)Component.m_237110_((String)(this.m_5524_() + ".tooltips.2"), (Object[])new Object[]{Component.m_237115_((String)(this.m_5524_() + ".tooltips.flavor.1")).m_130940_(ChatFormatting.GOLD)}));
                break;
            }
            case SPICY: {
                tooltip.add((Component)Component.m_237110_((String)(this.m_5524_() + ".tooltips.2"), (Object[])new Object[]{Component.m_237115_((String)(this.m_5524_() + ".tooltips.flavor.2")).m_130940_(ChatFormatting.RED)}));
                break;
            }
            case LIME: {
                tooltip.add((Component)Component.m_237110_((String)(this.m_5524_() + ".tooltips.2"), (Object[])new Object[]{Component.m_237115_((String)(this.m_5524_() + ".tooltips.flavor.3")).m_130944_(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.BOLD})}));
                break;
            }
            default: {
                tooltip.add((Component)Component.m_237110_((String)(this.m_5524_() + ".tooltips.2"), (Object[])new Object[]{Component.m_237115_((String)(this.m_5524_() + ".tooltips.flavor.0"))}));
            }
        }
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        HashMultimap multimap = HashMultimap.create();
        if (slot == EquipmentSlot.MAINHAND) {
            multimap.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Weapon modifier", Flavor.getFlavor(stack).equals((Object)Flavor.FRAGRANT) ? -1.7 : -2.4, AttributeModifier.Operation.ADDITION));
            switch (Flavor.getFlavor(stack)) {
                case FRAGRANT: {
                    multimap.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Weapon modifier", (double)(15.0f + this.m_43299_()), AttributeModifier.Operation.ADDITION));
                    break;
                }
                case SPICY: {
                    multimap.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Weapon modifier", (double)(1.0f + this.m_43299_()), AttributeModifier.Operation.ADDITION));
                    break;
                }
                case LIME: {
                    multimap.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Weapon modifier", (double)(10.0f + this.m_43299_()), AttributeModifier.Operation.ADDITION));
                    break;
                }
                default: {
                    multimap.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Weapon modifier", (double)this.m_43299_(), AttributeModifier.Operation.ADDITION));
                    break;
                }
            }
        } else {
            return super.getAttributeModifiers(slot, stack);
        }
        return multimap;
    }

    public boolean onLeftClickEntity(ItemStack pStack, Player pAttacker, Entity pTarget) {
        if (Flavor.getFlavor(pStack) == Flavor.LIME) {
            boolean flag2 = pAttacker.m_36403_(0.5f) > 0.9f && pAttacker.f_19789_ > 0.0f && !pAttacker.m_20096_() && !pAttacker.m_6147_() && !pAttacker.m_20069_() && !pAttacker.m_21023_(MobEffects.f_19610_) && !pAttacker.m_20159_() && pTarget instanceof LivingEntity;
            flag2 = flag2 && !pAttacker.m_20142_();
            CriticalHitEvent hitResult = ForgeHooks.getCriticalHit((Player)pAttacker, (Entity)pTarget, (boolean)flag2, (float)(flag2 ? 1.5f : 1.0f));
            boolean bl = flag2 = hitResult != null;
            if (flag2 || pTarget.m_9236_().m_213780_().m_188500_() < 0.3) {
                pAttacker.m_5634_(10.0f);
                pStack.m_41622_(87, (LivingEntity)pAttacker, living -> living.m_21166_(EquipmentSlot.MAINHAND));
                pTarget.m_6469_(HuaJiDamageSources.simple((Entity)pAttacker, HuaJiDamageTypes.KE_DAI_JIN_LA), 50.0f);
                HuaJiSoundPlayer.playMovingSoundToClient(pTarget, (SoundEvent)HuaJiSoundEvents.EXGLUTENBUR_HIT.get());
                pAttacker.m_213846_((Component)Component.m_237115_((String)"message.huajiage.exglutenbur.kdjl").m_130944_(new ChatFormatting[]{ChatFormatting.DARK_GRAY, ChatFormatting.BOLD}));
                pTarget.m_213846_((Component)Component.m_237115_((String)"message.huajiage.exglutenbur.kdjl").m_130944_(new ChatFormatting[]{ChatFormatting.DARK_GRAY, ChatFormatting.BOLD}));
                List entities = pTarget.m_9236_().m_45976_(LivingEntity.class, pTarget.m_20191_().m_82400_(5.0));
                for (LivingEntity entity : entities) {
                    Vec3 vec;
                    if (entity == pAttacker || entity == pTarget || (vec = HuaJiMathHelper.getVectorEntity(pTarget, (Entity)entity)).m_82553_() == 0.0) continue;
                    entity.m_6469_(HuaJiDamageSources.simple((Entity)pAttacker, HuaJiDamageTypes.KE_DAI_JIN_LA), (float)(20.0 / vec.m_82553_()));
                    entity.m_20256_(entity.m_20184_().m_82520_(-vec.f_82479_ / vec.m_82553_(), -vec.f_82480_ / vec.m_82553_(), -vec.f_82481_ / vec.m_82553_()));
                }
            }
        }
        return super.onLeftClickEntity(pStack, pAttacker, pTarget);
    }

    public boolean m_7579_(ItemStack pStack, LivingEntity pTarget, LivingEntity pAttacker) {
        switch (Flavor.getFlavor(pStack)) {
            case FRAGRANT: {
                pTarget.m_7292_(new MobEffectInstance(MobEffects.f_19612_, 600, 3));
                if (pAttacker instanceof Player) {
                    Player player = (Player)pAttacker;
                    FoodData foodData = player.m_36324_();
                    foodData.m_38705_(foodData.m_38702_() + 1);
                    foodData.m_38717_(foodData.m_38722_() + 10.0f);
                }
                pTarget.m_20334_(pTarget.m_20184_().f_82479_, 1.0, pTarget.m_20184_().f_82481_);
                pStack.m_41622_(8, pAttacker, living -> living.m_21166_(EquipmentSlot.MAINHAND));
                break;
            }
            case SPICY: {
                pTarget.m_20254_(5);
                HuaJiSoundPlayer.playMovingSoundToClient((Entity)pTarget, SoundEvents.f_11930_, pAttacker.m_5720_());
                List entities = pTarget.m_9236_().m_45976_(LivingEntity.class, pTarget.m_20191_().m_82400_(2.0));
                for (LivingEntity entity : entities) {
                    if (entity.equals((Object)pAttacker) || entity.equals((Object)pTarget)) continue;
                    entity.m_6469_(entity.m_9236_().m_269111_().m_269387_(), 5.0f);
                    entity.m_20254_(3);
                }
                pTarget.m_9236_().m_46796_(2007, pTarget.m_20183_(), 16729344);
                pStack.m_41622_(1, pAttacker, living -> living.m_21166_(EquipmentSlot.MAINHAND));
                break;
            }
            case LIME: {
                HuaJiSoundPlayer.playMovingSoundToClient((Entity)pTarget, SoundEvents.f_12442_, pAttacker.m_5720_());
                HuaJiSoundPlayer.playMovingSoundToClient((Entity)pTarget, SoundEvents.f_11937_, pAttacker.m_5720_());
                pTarget.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 60, 2));
                pTarget.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 60, 9));
                pTarget.m_9236_().m_46796_(2001, pTarget.m_20183_(), Block.m_49956_((BlockState)Blocks.f_50080_.m_49966_()));
                pAttacker.m_5634_(1.0f);
                pStack.m_41622_(12, pAttacker, living -> living.m_21166_(EquipmentSlot.MAINHAND));
            }
        }
        return super.m_7579_(pStack, pTarget, pAttacker);
    }

    public void m_6883_(ItemStack pStack, Level pLevel, Entity pEntity, int pSlotId, boolean pIsSelected) {
        if (pEntity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)pEntity;
            switch (Flavor.getFlavor(pStack)) {
                case FRAGRANT: {
                    if (pLevel.f_46443_) break;
                    living.m_7292_(new MobEffectInstance(MobEffects.f_19607_, 60, 0, false, false));
                    living.m_7292_(new MobEffectInstance(MobEffects.f_19600_, 60, 2, false, false));
                    living.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 60, 2, false, false));
                    break;
                }
                case LIME: {
                    if (pLevel.f_46443_) break;
                    living.m_7292_(new MobEffectInstance(MobEffects.f_19615_, 60, 1, false, false));
                    living.m_7292_(new MobEffectInstance(MobEffects.f_19600_, 60, 1, false, false));
                    living.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 60, 4, false, false));
                }
            }
        }
        super.m_6883_(pStack, pLevel, pEntity, pSlotId, pIsSelected);
    }

    @SubscribeEvent
    public static void onRightClick(PlayerInteractEvent event) {
        if (!event.getEntity().m_21205_().m_150930_((Item)HuaJiItems.EXGLUTENBUR.get()) || !event.getEntity().m_6144_() || event.getEntity().m_36335_().m_41519_((Item)HuaJiItems.EXGLUTENBUR.get())) {
            return;
        }
        Player player = event.getEntity();
        if (event instanceof PlayerInteractEvent.RightClickItem || event instanceof PlayerInteractEvent.RightClickBlock || event instanceof PlayerInteractEvent.EntityInteractSpecific) {
            Flavor.nextFlavor(event.getEntity().m_21205_());
            player.m_36335_().m_41524_((Item)HuaJiItems.EXGLUTENBUR.get(), 10);
            if (!player.m_9236_().f_46443_) {
                switch (Flavor.getFlavor(event.getEntity().m_21205_())) {
                    case FRAGRANT: {
                        HuaJiSoundPlayer.playMovingSoundToClient((Entity)player, (SoundEvent)HuaJiSoundEvents.EXGLUTENBUR_1.get(), player.m_5720_());
                        player.m_213846_((Component)Component.m_237115_((String)"message.huajiage.exglutenbur.flavor.1").m_130940_(ChatFormatting.GOLD));
                        break;
                    }
                    case SPICY: {
                        HuaJiSoundPlayer.playMovingSoundToClient((Entity)player, (SoundEvent)HuaJiSoundEvents.EXGLUTENBUR_2.get(), player.m_5720_());
                        player.m_213846_((Component)Component.m_237115_((String)"message.huajiage.exglutenbur.flavor.2").m_130940_(ChatFormatting.RED));
                        break;
                    }
                    case LIME: {
                        HuaJiSoundPlayer.playMovingSoundToClient((Entity)player, (SoundEvent)HuaJiSoundEvents.EXGLUTENBUR_3.get(), player.m_5720_());
                        player.m_213846_((Component)Component.m_237115_((String)"message.huajiage.exglutenbur.flavor.3").m_130944_(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.BOLD}));
                        break;
                    }
                }
            }
        }
    }

    public static enum Flavor {
        BASE,
        FRAGRANT,
        SPICY,
        LIME;


        public static Flavor getFlavor(ItemStack itemStack) {
            switch (ItemTagHelper.getInt(itemStack, "exglutenbur_flavor", 0)) {
                case 1: {
                    return FRAGRANT;
                }
                case 2: {
                    return SPICY;
                }
                case 3: {
                    return LIME;
                }
            }
            return BASE;
        }

        @CanIgnoreReturnValue
        public static Flavor nextFlavor(ItemStack itemStack) {
            switch (Flavor.getFlavor(itemStack)) {
                case FRAGRANT: {
                    ItemTagHelper.setInt(itemStack, "exglutenbur_flavor", 2);
                    return FRAGRANT;
                }
                case SPICY: {
                    ItemTagHelper.setInt(itemStack, "exglutenbur_flavor", 3);
                    return SPICY;
                }
                case LIME: {
                    ItemTagHelper.setInt(itemStack, "exglutenbur_flavor", 0);
                    return LIME;
                }
            }
            ItemTagHelper.setInt(itemStack, "exglutenbur_flavor", 1);
            return BASE;
        }
    }
}

