/*
 * Decompiled with CFR 0.152.
 */
package net.mrqx.huajiage.item.equipment;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.mrqx.huajiage.init.HuaJiTiers;
import net.mrqx.huajiage.registy.HuaJiItems;
import net.mrqx.huajiage.utils.HuaJiSoundPlayer;
import net.mrqx.huajiage.utils.ItemTagHelper;
import org.jetbrains.annotations.Nullable;

@Mod.EventBusSubscriber
public class ItemHuajiLaTiaoSword
extends SwordItem {
    public ItemHuajiLaTiaoSword() {
        super((Tier)HuaJiTiers.HUAJI_LATIAO.get(), 12, -1.0f, new Item.Properties().m_41497_(Rarity.RARE).m_41503_(3998));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.m_237110_((String)(this.m_5524_() + ".tooltips.1"), (Object[])new Object[]{Minecraft.m_91087_().f_91066_.f_92090_.m_90863_().m_6881_().m_130944_(new ChatFormatting[]{ChatFormatting.YELLOW, ChatFormatting.ITALIC}), Minecraft.m_91087_().f_91066_.f_92095_.m_90863_().m_6881_().m_130944_(new ChatFormatting[]{ChatFormatting.YELLOW, ChatFormatting.ITALIC})}).m_130944_(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.BOLD}));
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        HashMultimap multimap = HashMultimap.create();
        if (slot == EquipmentSlot.MAINHAND) {
            multimap.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Weapon modifier", Mode.getMode(stack).equals((Object)Mode.ON) ? -2.4 : -1.0, AttributeModifier.Operation.ADDITION));
            if (Mode.getMode(stack) == Mode.ON) {
                multimap.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Weapon modifier", (double)(6.0f + this.m_43299_()), AttributeModifier.Operation.ADDITION));
            } else {
                multimap.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Weapon modifier", (double)this.m_43299_(), AttributeModifier.Operation.ADDITION));
            }
        } else {
            return super.getAttributeModifiers(slot, stack);
        }
        return multimap;
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        Player player;
        LivingEntity living;
        super.m_6883_(stack, level, entity, slotId, isSelected);
        if (entity instanceof LivingEntity && (living = (LivingEntity)entity).m_21205_().equals(stack) && Mode.getMode(stack) == Mode.ON) {
            living.m_7292_(new MobEffectInstance(MobEffects.f_19607_, 60, 0, false, false));
            living.m_7292_(new MobEffectInstance(MobEffects.f_19600_, 60, 1, false, false));
            living.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 60, 1, false, false));
        } else if (entity instanceof Player && (player = (Player)entity).m_21205_().equals(stack) && player.m_36324_().m_38702_() > 0 && stack.m_41768_()) {
            player.m_36324_().m_38703_(4.0f);
            stack.m_41721_(Math.max(stack.m_41773_() - 1, 0));
            HuaJiSoundPlayer.playMovingSoundToClient((Entity)player, SoundEvents.f_12190_);
        }
    }

    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (Mode.getMode(stack).equals((Object)Mode.ON)) {
            target.m_6469_(target.m_9236_().m_269111_().m_269233_(), 10.0f);
            target.m_20254_(8);
            HuaJiSoundPlayer.playMovingSoundToClient((Entity)target, SoundEvents.f_11705_);
            HuaJiSoundPlayer.playMovingSoundToClient((Entity)target, SoundEvents.f_11909_, 1.0f, 0.1f);
        } else {
            target.m_7292_(new MobEffectInstance(MobEffects.f_19612_, 600, 2));
            stack.m_41622_(1, attacker, living -> living.m_21166_(EquipmentSlot.MAINHAND));
        }
        return super.m_7579_(stack, target, attacker);
    }

    @SubscribeEvent
    public static void onRightClick(PlayerInteractEvent event) {
        if (!event.getEntity().m_21205_().m_150930_((Item)HuaJiItems.HUAJI_LATIAO_SWORD.get()) || event.getEntity().m_36335_().m_41519_((Item)HuaJiItems.HUAJI_LATIAO_SWORD.get())) {
            return;
        }
        Player player = event.getEntity();
        if (event instanceof PlayerInteractEvent.RightClickItem || event instanceof PlayerInteractEvent.RightClickBlock || event instanceof PlayerInteractEvent.EntityInteractSpecific) {
            ItemStack itemStack = player.m_21205_();
            if (player.m_6144_()) {
                Mode.changeMode(itemStack);
                player.m_36335_().m_41524_((Item)HuaJiItems.HUAJI_LATIAO_SWORD.get(), 10);
                if (Mode.getMode(itemStack).equals((Object)Mode.ON)) {
                    HuaJiSoundPlayer.playMovingSoundToClient((Entity)player, SoundEvents.f_11705_);
                }
            } else if (Mode.getMode(itemStack).equals((Object)Mode.ON) && player instanceof ServerPlayer) {
                Level level;
                ServerPlayer serverPlayer = (ServerPlayer)player;
                if (serverPlayer.m_36324_().m_38702_() < 20) {
                    serverPlayer.m_36324_().m_38705_(serverPlayer.m_36324_().m_38702_() + 2);
                    itemStack.m_41622_(20, (LivingEntity)serverPlayer, living -> living.m_21166_(EquipmentSlot.MAINHAND));
                }
                serverPlayer.m_20334_(serverPlayer.m_20184_().f_82479_, 0.6, serverPlayer.m_20184_().f_82481_);
                serverPlayer.f_19789_ = 0.0f;
                player.m_36335_().m_41524_((Item)HuaJiItems.HUAJI_LATIAO_SWORD.get(), 10);
                MinecraftServer server = serverPlayer.m_20194_();
                if (server != null) {
                    server.m_6846_().m_11314_().forEach(serverPlayer1 -> serverPlayer1.f_8906_.m_9829_((Packet)new ClientboundSetEntityMotionPacket((Entity)serverPlayer)));
                }
                if ((level = serverPlayer.m_9236_()) instanceof ServerLevel) {
                    ServerLevel level2 = (ServerLevel)level;
                    Vec3 targetCoordinates = serverPlayer.m_20182_();
                    for (int d = 0; d < 360; d += 15) {
                        level2.m_8767_((ParticleOptions)ParticleTypes.f_123744_, targetCoordinates.f_82479_ + 0.5 * Math.sin(d), targetCoordinates.f_82480_ + 0.1, targetCoordinates.f_82481_ + 0.5 * Math.cos(d), 0, 0.5 * Math.sin(d), 0.0, 0.5 * Math.cos(d), 1.0);
                    }
                }
            }
        }
    }

    public static enum Mode {
        ON,
        OFF;


        public static Mode getMode(ItemStack itemStack) {
            if (ItemTagHelper.getBoolean(itemStack, "huaji_latiao_sword_mode", false)) {
                return ON;
            }
            return OFF;
        }

        public static Mode changeMode(ItemStack itemStack) {
            if (Mode.getMode(itemStack) == OFF) {
                ItemTagHelper.setBoolean(itemStack, "huaji_latiao_sword_mode", true);
                return ON;
            }
            ItemTagHelper.setBoolean(itemStack, "huaji_latiao_sword_mode", false);
            return OFF;
        }
    }
}

