/*
 * Decompiled with CFR 0.152.
 */
package net.mrqx.huajiage.item.equipment;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.mrqx.huajiage.init.HuaJiTiers;
import net.mrqx.huajiage.registy.HuaJiItems;
import net.mrqx.huajiage.registy.HuaJiSoundEvents;
import net.mrqx.huajiage.utils.HuaJiSoundPlayer;
import net.mrqx.huajiage.utils.ItemTagHelper;
import org.jetbrains.annotations.Nullable;

@Mod.EventBusSubscriber
public class ItemHuajiStarSword
extends SwordItem {
    public ItemHuajiStarSword() {
        super((Tier)HuaJiTiers.HUAJI_STAR.get(), 14, -1.4f, new Item.Properties().m_41497_(Rarity.RARE).m_41503_(5400));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.m_237110_((String)(this.m_5524_() + ".tooltips.1"), (Object[])new Object[]{Minecraft.m_91087_().f_91066_.f_92090_.m_90863_().m_6881_().m_130944_(new ChatFormatting[]{ChatFormatting.YELLOW, ChatFormatting.ITALIC}), Minecraft.m_91087_().f_91066_.f_92095_.m_90863_().m_6881_().m_130944_(new ChatFormatting[]{ChatFormatting.YELLOW, ChatFormatting.ITALIC})}).m_130944_(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.BOLD}));
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        HashMultimap multimap = HashMultimap.create();
        if (slot == EquipmentSlot.MAINHAND) {
            multimap.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Weapon modifier", Mode.getMode(stack).equals((Object)Mode.ON) ? -1.4 : -2.4, AttributeModifier.Operation.ADDITION));
            if (Mode.getMode(stack) == Mode.ON) {
                multimap.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Weapon modifier", (double)(9.0f + this.m_43299_()), AttributeModifier.Operation.ADDITION));
            } else {
                multimap.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Weapon modifier", (double)this.m_43299_(), AttributeModifier.Operation.ADDITION));
            }
        } else {
            return super.getAttributeModifiers(slot, stack);
        }
        return multimap;
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        LivingEntity living;
        super.m_6883_(stack, level, entity, slotId, isSelected);
        if (entity instanceof LivingEntity && (living = (LivingEntity)entity).m_21205_().equals(stack) && Mode.getMode(stack) == Mode.ON) {
            living.m_7292_(new MobEffectInstance(MobEffects.f_19612_, 40, 0, false, false));
            living.m_7292_(new MobEffectInstance(MobEffects.f_19600_, 40, 3, false, false));
            living.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 40, 3, false, false));
        }
    }

    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (Mode.getMode(stack).equals((Object)Mode.ON)) {
            target.m_6469_(target.m_9236_().m_269111_().m_269341_(), 10.0f);
            target.m_20254_(5);
            HuaJiSoundPlayer.playMovingSoundToClient((Entity)target, (SoundEvent)HuaJiSoundEvents.WAVE1.get());
            HuaJiSoundPlayer.playMovingSoundToClient((Entity)target, (SoundEvent)HuaJiSoundEvents.ENERGY_HIT.get(), 1.0f, 0.1f);
        } else {
            target.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 60, 2));
            target.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 60, 2));
        }
        return super.m_7579_(stack, target, attacker);
    }

    @SubscribeEvent
    public static void onRightClick(PlayerInteractEvent event) {
        if (!event.getEntity().m_21205_().m_150930_((Item)HuaJiItems.HUAJI_STAR_SWORD.get()) || !event.getEntity().m_6144_() || event.getEntity().m_36335_().m_41519_((Item)HuaJiItems.HUAJI_STAR_SWORD.get())) {
            return;
        }
        Player player = event.getEntity();
        if (event instanceof PlayerInteractEvent.RightClickItem || event instanceof PlayerInteractEvent.RightClickBlock || event instanceof PlayerInteractEvent.EntityInteractSpecific) {
            Mode.changeMode(player.m_21205_());
            player.m_36335_().m_41524_((Item)HuaJiItems.HUAJI_STAR_SWORD.get(), 10);
            if (Mode.getMode(player.m_21205_()).equals((Object)Mode.ON)) {
                HuaJiSoundPlayer.playMovingSoundToClient((Entity)player, (SoundEvent)HuaJiSoundEvents.CHARGE.get());
            }
        }
    }

    public static enum Mode {
        ON,
        OFF;


        public static Mode getMode(ItemStack itemStack) {
            if (ItemTagHelper.getBoolean(itemStack, "huaji_star_sword_mode", false)) {
                return ON;
            }
            return OFF;
        }

        public static Mode changeMode(ItemStack itemStack) {
            if (Mode.getMode(itemStack) == OFF) {
                ItemTagHelper.setBoolean(itemStack, "huaji_star_sword_mode", true);
                return ON;
            }
            ItemTagHelper.setBoolean(itemStack, "huaji_star_sword_mode", false);
            return OFF;
        }
    }
}

