/*
 * Decompiled with CFR 0.152.
 */
package net.mrqx.huajiage.item.equipment.armor;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.mrqx.huajiage.client.HuaJiKeyMappings;
import net.mrqx.huajiage.client.HuaJiLayers;
import net.mrqx.huajiage.client.model.ModelFiftyFiftyHelmet;
import net.mrqx.huajiage.event.HuaJiCanFlyEvent;
import net.mrqx.huajiage.event.KeyInputEvent;
import net.mrqx.huajiage.item.equipment.armor.HuaJiArmorMaterials;
import net.mrqx.huajiage.network.HuaJiKeyMessage;
import net.mrqx.huajiage.registy.HuaJiEffects;
import net.mrqx.huajiage.registy.HuaJiItems;
import net.mrqx.huajiage.utils.HuaJiDamageSources;
import net.mrqx.huajiage.utils.ItemTagHelper;
import org.jetbrains.annotations.Nullable;

@Mod.EventBusSubscriber
public class ItemFiftyFiftyHelmet
extends ArmorItem {
    public static final String FIFTY_FIFTY_ACTIVE_KEY = "huajiage.fiftyFiftyActive";
    public static final String FIFTY_FIFTY_LORD_KEY = "huajiage.fiftyFiftyLord";

    public static boolean isFiftyFiftyActive(LivingEntity livingEntity) {
        return ItemFiftyFiftyHelmet.hasFiftyFiftyHelmet(livingEntity) && ItemTagHelper.getBoolean(livingEntity.m_6844_(EquipmentSlot.HEAD), FIFTY_FIFTY_ACTIVE_KEY, false);
    }

    public static void setFiftyFiftyActive(LivingEntity livingEntity, boolean isActive) {
        ItemTagHelper.setBoolean(livingEntity.m_6844_(EquipmentSlot.HEAD), FIFTY_FIFTY_ACTIVE_KEY, isActive);
    }

    public static boolean isFiftyFiftyLord(LivingEntity livingEntity) {
        return ItemFiftyFiftyHelmet.hasFiftyFiftyHelmet(livingEntity) && ItemTagHelper.getBoolean(livingEntity.m_6844_(EquipmentSlot.HEAD), FIFTY_FIFTY_LORD_KEY, false);
    }

    public static void setFiftyFiftyLord(LivingEntity livingEntity, boolean isLord) {
        ItemTagHelper.setBoolean(livingEntity.m_6844_(EquipmentSlot.HEAD), FIFTY_FIFTY_LORD_KEY, isLord);
    }

    public static boolean hasFiftyFiftyHelmet(LivingEntity livingEntity) {
        return livingEntity.m_6844_(EquipmentSlot.HEAD).m_150930_((Item)HuaJiItems.FIFTY_FIFTY_HELMET.get());
    }

    public ItemFiftyFiftyHelmet() {
        super((ArmorMaterial)HuaJiArmorMaterials.FIFTY_FIFTY, ArmorItem.Type.HELMET, new Item.Properties().m_41497_(Rarity.EPIC).m_41486_());
    }

    @Nullable
    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
        return "huajiage:textures/models/armor/50_50_helmet.png";
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.m_237110_((String)(this.m_5524_() + ".tooltips.1"), (Object[])new Object[]{Minecraft.m_91087_().f_91066_.f_92090_.m_90863_().m_6881_().m_130944_(new ChatFormatting[]{ChatFormatting.YELLOW, ChatFormatting.ITALIC})}).m_130940_(ChatFormatting.GRAY));
        tooltip.add((Component)Component.m_237110_((String)"item.huajiage.tooltips.shift.1", (Object[])new Object[]{Minecraft.m_91087_().f_91066_.f_92090_.m_90863_().m_6881_().m_130944_(new ChatFormatting[]{ChatFormatting.YELLOW, ChatFormatting.ITALIC})}).m_130940_(ChatFormatting.DARK_RED));
        if (Screen.m_96638_() && Minecraft.m_91087_().f_91074_ != null) {
            if (ItemFiftyFiftyHelmet.isFiftyFiftyLord((LivingEntity)Minecraft.m_91087_().f_91074_)) {
                tooltip.add((Component)Component.m_237110_((String)"message.huajiage.prefix", (Object[])new Object[]{Component.m_237115_((String)(this.m_5524_() + ".tooltips.shift.3")).m_130940_(ChatFormatting.YELLOW).m_130940_(ChatFormatting.BOLD)}));
            } else if (ItemFiftyFiftyHelmet.isFiftyFiftyActive((LivingEntity)Minecraft.m_91087_().f_91074_)) {
                tooltip.add((Component)Component.m_237110_((String)"message.huajiage.prefix", (Object[])new Object[]{Component.m_237110_((String)(this.m_5524_() + ".tooltips.shift.2"), (Object[])new Object[]{Component.m_237115_((String)((Item)HuaJiItems.LORD_KEY.get()).m_5524_()).m_130940_(ChatFormatting.DARK_GREEN)}).m_130940_(ChatFormatting.DARK_RED)}));
            } else {
                tooltip.add((Component)Component.m_237110_((String)"message.huajiage.prefix", (Object[])new Object[]{Component.m_237110_((String)(this.m_5524_() + ".tooltips.shift.1"), (Object[])new Object[]{Component.m_237115_((String)((Item)HuaJiItems.LORD_CORE.get()).m_5524_()).m_130940_(ChatFormatting.GREEN)}).m_130940_(ChatFormatting.RED)}));
            }
        }
        tooltip.add((Component)Component.m_237110_((String)(this.m_5524_() + ".tooltips.2"), (Object[])new Object[]{HuaJiKeyMappings.KEY_CHANGE_MODE.m_90863_().m_6881_().m_130944_(new ChatFormatting[]{ChatFormatting.YELLOW, ChatFormatting.ITALIC})}).m_130940_(ChatFormatting.GOLD));
        tooltip.add((Component)Component.m_237110_((String)(this.m_5524_() + ".tooltips.mode"), (Object[])new Object[]{Mode.getMode(stack).equals((Object)Mode.ON) ? Component.m_237115_((String)(this.m_5524_() + ".tooltips.mode.on")).m_130940_(ChatFormatting.GOLD) : Component.m_237115_((String)(this.m_5524_() + ".tooltips.mode.off")).m_130940_(ChatFormatting.GRAY)}).m_130940_(ChatFormatting.GRAY));
    }

    public void m_6883_(ItemStack pStack, Level pLevel, Entity pEntity, int pSlotId, boolean pIsSelected) {
        super.m_6883_(pStack, pLevel, pEntity, pSlotId, pIsSelected);
        if (!pLevel.f_46443_ && pEntity instanceof Player) {
            Player player = (Player)pEntity;
            if (((ItemStack)player.m_150109_().f_35975_.get(3)).equals(pStack) && Mode.getMode(pStack).equals((Object)Mode.ON)) {
                if (ItemFiftyFiftyHelmet.isFiftyFiftyActive((LivingEntity)player)) {
                    boolean isLord = ItemFiftyFiftyHelmet.isFiftyFiftyLord((LivingEntity)player);
                    player.m_7292_(new MobEffectInstance(MobEffects.f_19611_, 300, 0, false, false));
                    player.m_7292_(new MobEffectInstance(MobEffects.f_19607_, 50, 0, false, false));
                    player.m_7292_(new MobEffectInstance(MobEffects.f_19608_, 50, 0, false, false));
                    player.m_7292_(new MobEffectInstance(MobEffects.f_19600_, 50, isLord ? 5 : 2, false, false));
                    if (isLord) {
                        player.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 50, 5, false, false));
                        player.m_7292_(new MobEffectInstance((MobEffect)HuaJiEffects.FIVE.get(), 50, 0, false, true));
                    }
                } else {
                    Mode.changeMode(pStack);
                }
            }
        }
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        if (Mode.getMode(stack).equals((Object)Mode.ON)) {
            HashMultimap multimap = HashMultimap.create();
            if (slot == EquipmentSlot.HEAD) {
                multimap.putAll(super.getAttributeModifiers(slot, stack));
                multimap.put((Object)Attributes.f_22276_, (Object)new AttributeModifier(UUID.fromString("ebb91868-6aed-11e9-a923-1681be663d3e"), "Fifty Fifty Helmet modifier", 5.0, AttributeModifier.Operation.MULTIPLY_BASE));
                multimap.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(UUID.fromString("05fd4064-6aee-11e9-a923-1681be663d3e"), "Fifty Fifty Helmet modifier", 5.0, AttributeModifier.Operation.MULTIPLY_BASE));
                multimap.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(UUID.fromString("1cb6e486-6aee-11e9-a923-1681be663d3e"), "Fifty Fifty Helmet modifier", 5.0, AttributeModifier.Operation.MULTIPLY_BASE));
                multimap.put((Object)Attributes.f_22279_, (Object)new AttributeModifier(UUID.fromString("1cb6e710-6aee-11e9-a923-1681be663d3e"), "Fifty Fifty Helmet modifier", 5.0, AttributeModifier.Operation.MULTIPLY_BASE));
            }
            return multimap;
        }
        return super.getAttributeModifiers(slot, stack);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){

            public HumanoidModel<?> getHumanoidArmorModel(LivingEntity livingEntity, ItemStack itemStack, EquipmentSlot equipmentSlot, HumanoidModel<?> original) {
                EntityModelSet models = Minecraft.m_91087_().m_167973_();
                ModelPart root = models.m_171103_(HuaJiLayers.FIFTY_FIFTY_HELMET);
                return new ModelFiftyFiftyHelmet(root, itemStack);
            }
        });
    }

    @SubscribeEvent
    public static void onChangeModeEvent(KeyInputEvent event) {
        if (!event.oldCommand.contains((Object)HuaJiKeyMessage.Keys.CHANGE_MODE) && event.currentCommand.contains((Object)HuaJiKeyMessage.Keys.CHANGE_MODE)) {
            if (ItemFiftyFiftyHelmet.isFiftyFiftyActive((LivingEntity)event.getEntity())) {
                ItemStack itemStack = event.getEntity().m_6844_(EquipmentSlot.HEAD);
                Mode.changeMode(itemStack);
                if (Mode.getMode(itemStack).equals((Object)Mode.ON)) {
                    event.getEntity().m_213846_((Component)Component.m_237110_((String)"message.huajiage.50_50_helmet.open", (Object[])new Object[]{event.getEntity().m_5446_()}).m_130944_(new ChatFormatting[]{ChatFormatting.YELLOW, ChatFormatting.BOLD}));
                }
            } else {
                event.getEntity().m_213846_((Component)Component.m_237110_((String)"message.huajiage.50_50_helmet.failed", (Object[])new Object[]{event.getEntity().m_5446_()}).m_130940_(ChatFormatting.DARK_RED));
            }
        }
    }

    @SubscribeEvent
    public static void onLivingHurtEvent(LivingHurtEvent event) {
        Player player;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player && ItemFiftyFiftyHelmet.isFiftyFiftyLord((LivingEntity)(player = (Player)livingEntity))) {
            if (event.getSource().m_7639_() != null) {
                event.getSource().m_7639_().m_6469_(HuaJiDamageSources.five(event.getSource().m_7639_().m_9236_(), event.getSource()), event.getAmount() * 0.5f);
            }
            event.setAmount(event.getAmount() * 0.5f);
        }
    }

    @SubscribeEvent
    public static void onHuaJiCanFlyEvent(HuaJiCanFlyEvent event) {
        if (ItemFiftyFiftyHelmet.isFiftyFiftyLord((LivingEntity)event.getEntity())) {
            event.setCanFly(true);
        }
    }

    public static enum Mode {
        ON,
        OFF;


        public static Mode getMode(ItemStack itemStack) {
            if (ItemTagHelper.getBoolean(itemStack, "50_50_mode", false)) {
                return ON;
            }
            return OFF;
        }

        public static Mode changeMode(ItemStack itemStack) {
            if (Mode.getMode(itemStack) == OFF) {
                ItemTagHelper.setBoolean(itemStack, "50_50_mode", true);
                return ON;
            }
            ItemTagHelper.setBoolean(itemStack, "50_50_mode", false);
            return OFF;
        }
    }
}

