/*
 * Decompiled with CFR 0.152.
 */
package net.mrqx.huajiage.stand;

import com.mega.endinglib.util.time.TimeStopUtils;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.boss.EnderDragonPart;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.mrqx.huajiage.HuaJiAgeMod;
import net.mrqx.huajiage.capability.stand.IStandData;
import net.mrqx.huajiage.capability.stand.StandDataCapabilityProvider;
import net.mrqx.huajiage.client.HuaJiLayers;
import net.mrqx.huajiage.client.model.stand.ModelKillerQueen;
import net.mrqx.huajiage.client.model.stand.ModelKillerQueenPunch;
import net.mrqx.huajiage.client.model.stand.ModelStandBase;
import net.mrqx.huajiage.data.HuaJiDamageTypes;
import net.mrqx.huajiage.entity.EntityRoadRoller;
import net.mrqx.huajiage.entity.EntitySheerHeartAttack;
import net.mrqx.huajiage.item.ItemKillerQueenTrigger;
import net.mrqx.huajiage.registy.HuaJiItems;
import net.mrqx.huajiage.registy.HuaJiSoundEvents;
import net.mrqx.huajiage.stand.Stand;
import net.mrqx.huajiage.utils.HuaJiDamageSources;
import net.mrqx.huajiage.utils.HuaJiMathHelper;
import net.mrqx.huajiage.utils.HuaJiSoundPlayer;

@Mod.EventBusSubscriber
public class StandKillerQueen
extends Stand {
    public static final BiConsumer<LivingEntity, IStandData> KILLER_QUEEN_TICK = (living, data) -> {
        Stand stand = Stand.getStand(data.getStand());
        if (stand != null && !living.m_9236_().f_46443_ && "huajiage.punch".equals(data.getState())) {
            living.m_9236_().m_45976_(Entity.class, living.m_20191_().m_82400_((double)(stand.getDistance((LivingEntity)living, (IStandData)data) / 50.0f))).forEach(entity -> {
                LivingEntity target;
                if (HuaJiMathHelper.getDegreeXZ(living.m_20154_(), HuaJiMathHelper.getVectorEntityEye((Entity)living, entity)) > 45.0) {
                    return;
                }
                Vec3 back = HuaJiMathHelper.getVectorEntityEye((Entity)living, entity);
                DamageSource damageSource = HuaJiDamageSources.simple((Entity)living, HuaJiDamageTypes.STAND_HIT);
                if (entity instanceof EnderDragonPart) {
                    EnderDragonPart enderDragonPart = (EnderDragonPart)entity;
                    enderDragonPart.f_31010_.m_31120_(enderDragonPart.f_31010_.f_31080_, damageSource, stand.getDamage((LivingEntity)living, (IStandData)data));
                } else if (entity instanceof LivingEntity && !(target = (LivingEntity)entity).equals(living)) {
                    boolean isTimeStopping;
                    boolean bl = isTimeStopping = TimeStopUtils.isTimeStop && TimeStopUtils.andSameDimension((Level)living.m_9236_());
                    if (living.m_9236_().m_46467_() % 4L == 0L || isTimeStopping) {
                        target.f_19802_ = 0;
                        target.m_6469_(damageSource, stand.getDamage((LivingEntity)living, (IStandData)data) / 2.0f);
                        target.f_19802_ = 0;
                        if (!isTimeStopping) {
                            living.m_9236_().m_46796_(2001, target.m_20183_().m_7918_(0, (int)(target.m_20299_((float)0.0f).f_82480_ - target.m_20182_().f_82480_), 0), Block.m_49956_((BlockState)Blocks.f_50080_.m_49966_()));
                        }
                        if (HuaJiMathHelper.getVectorEntityEye((Entity)living, (Entity)target).m_82553_() < (double)(stand.getDistance((LivingEntity)living, (IStandData)data) / 25.0f)) {
                            target.m_20256_(back);
                        }
                    }
                } else if (!(entity instanceof ItemEntity) && !(entity instanceof ExperienceOrb)) {
                    if (entity instanceof EntityRoadRoller) {
                        EntityRoadRoller roadRoller = (EntityRoadRoller)((Object)((Object)entity));
                        roadRoller.m_6469_(damageSource, stand.getDamage((LivingEntity)living, (IStandData)data) / 2.0f);
                    } else {
                        entity.m_20256_(back.m_82490_((double)(stand.getDamage((LivingEntity)living, (IStandData)data) / 10.0f)));
                    }
                }
            });
        }
    };
    public static final BiConsumer<LivingEntity, IStandData> KILLER_QUEEN_DO_SKILL = (living, data) -> {
        OwnableEntity ownable;
        LivingEntity patt5562$temp;
        if (living instanceof Player) {
            Player player = (Player)living;
            EntitySheerHeartAttack sheerHeartAttack = new EntitySheerHeartAttack(living.m_9236_());
            sheerHeartAttack.m_21828_(player);
            sheerHeartAttack.m_146884_(living.m_146892_());
            sheerHeartAttack.m_20256_(living.m_20154_().m_82490_(0.5));
            living.m_9236_().m_7967_((Entity)sheerHeartAttack);
            HuaJiSoundPlayer.playMovingSoundToClient((Entity)living, (SoundEvent)HuaJiSoundEvents.STAND_KILLER_QUEEN_TRIGGER.get(), 2.0f);
        } else if (living instanceof OwnableEntity && (patt5562$temp = (ownable = (OwnableEntity)living).m_269323_()) instanceof Player) {
            Player player = (Player)patt5562$temp;
            EntitySheerHeartAttack sheerHeartAttack = new EntitySheerHeartAttack(living.m_9236_());
            sheerHeartAttack.m_21828_(player);
            sheerHeartAttack.m_146884_(living.m_146892_());
            sheerHeartAttack.m_20256_(living.m_20154_().m_82490_(0.5));
            living.m_9236_().m_7967_((Entity)sheerHeartAttack);
            HuaJiSoundPlayer.playMovingSoundToClient((Entity)living, (SoundEvent)HuaJiSoundEvents.STAND_KILLER_QUEEN_TRIGGER.get(), 2.0f);
        }
    };
    @OnlyIn(value=Dist.CLIENT)
    public static final ModelLayerLocation DEFAULT_LAYER = HuaJiLayers.create("killer_queen", "huajiage.default");
    @OnlyIn(value=Dist.CLIENT)
    public static final ModelLayerLocation PUNCH_LAYER = HuaJiLayers.create("killer_queen", "huajiage.punch");
    @OnlyIn(value=Dist.CLIENT)
    public static final Map<String, ModelLayerLocation> MODEL_LAYER_MAP = Map.of("huajiage.default", DEFAULT_LAYER, "huajiage.punch", PUNCH_LAYER);
    @OnlyIn(value=Dist.CLIENT)
    public static final Map<String, ResourceLocation> TEXTURE_MAP = Map.of("huajiage.default", HuaJiAgeMod.prefix("textures/entity/stand/killer_queen_default.png"), "huajiage.punch", HuaJiAgeMod.prefix("textures/entity/stand/killer_queen_punch.png"));
    @OnlyIn(value=Dist.CLIENT)
    public static final Map<String, List<Double>> TRANSLATION_MAP = Map.of("huajiage.default", List.of(Double.valueOf(0.9), Double.valueOf(-0.1), Double.valueOf(-0.8)), "huajiage.punch", List.of(Double.valueOf(0.0), Double.valueOf(0.0), Double.valueOf(-0.9)));
    @OnlyIn(value=Dist.CLIENT)
    public static final Map<ModelLayerLocation, Supplier<LayerDefinition>> MODEL_MAP = Map.of(DEFAULT_LAYER, ModelKillerQueen::createBodyLayer, PUNCH_LAYER, ModelKillerQueenPunch::createBodyLayer);
    @OnlyIn(value=Dist.CLIENT)
    public static final Map<ModelLayerLocation, Function<ModelPart, ModelStandBase>> MODEL_FUNCTION_MAP = Map.of(DEFAULT_LAYER, ModelKillerQueen::new, PUNCH_LAYER, ModelKillerQueenPunch::new);

    public StandKillerQueen() {
        super(KILLER_QUEEN_TICK, KILLER_QUEEN_DO_SKILL);
    }

    @Override
    public void onTriggered(LivingEntity livingEntity, IStandData data) {
        super.onTriggered(livingEntity, data);
        HuaJiSoundPlayer.playMovingSoundToClient((Entity)livingEntity, livingEntity.m_9236_().m_213780_().m_188499_() ? (SoundEvent)HuaJiSoundEvents.STAND_KILLER_QUEEN_SHOW_1.get() : (SoundEvent)HuaJiSoundEvents.STAND_KILLER_QUEEN_SHOW_2.get());
    }

    @Override
    public int skillEnergyDemand(LivingEntity livingEntity, IStandData data) {
        return data.getLevel() > 0 ? 60000 : -1;
    }

    @Override
    public int getMaxLevel() {
        return 1;
    }

    @Override
    public float getDamage(LivingEntity livingEntity, IStandData data) {
        return 8.0f * (1.0f + (float)data.getLevel() / 2.0f);
    }

    @Override
    public float getSpeed(LivingEntity livingEntity, IStandData data) {
        return 0.6f;
    }

    @Override
    public int getDuration(LivingEntity livingEntity, IStandData data) {
        return 300;
    }

    @Override
    public float getDistance(LivingEntity livingEntity, IStandData data) {
        return 100.0f;
    }

    @Override
    public int chargePerTick(LivingEntity livingEntity, IStandData data) {
        return data.isTriggered() && data.getState().equals("huajiage.default") ? 104 : 80;
    }

    @Override
    public List<String> getStates() {
        return List.of("huajiage.default", "huajiage.punch");
    }

    @SubscribeEvent
    public static void onRightClick(PlayerInteractEvent event) {
        Player player = event.getEntity();
        if (event instanceof PlayerInteractEvent.LeftClickBlock || event instanceof PlayerInteractEvent.RightClickBlock) {
            player.getCapability(StandDataCapabilityProvider.STAND_DATA).ifPresent(data -> {
                Stand stand = Stand.getStand(data.getStand());
                if (stand instanceof StandKillerQueen && data.isTriggered()) {
                    Inventory inventory = player.m_150109_();
                    if (!inventory.m_216874_(itemStack -> itemStack.m_150930_((Item)HuaJiItems.KILLER_QUEEN_TRIGGER.get()))) {
                        ItemStack itemStack2 = ((Item)HuaJiItems.KILLER_QUEEN_TRIGGER.get()).m_7968_();
                        ItemKillerQueenTrigger.addTrigger(itemStack2, new ItemKillerQueenTrigger.Trigger().setTarget(event.getPos()), data.getLevel() + 1);
                        player.m_150109_().m_36054_(itemStack2);
                    } else {
                        for (int j = 0; j < inventory.m_6643_(); ++j) {
                            ItemStack itemStack3 = inventory.m_8020_(j);
                            if (!itemStack3.m_150930_((Item)HuaJiItems.KILLER_QUEEN_TRIGGER.get())) continue;
                            ItemKillerQueenTrigger.addTrigger(itemStack3, new ItemKillerQueenTrigger.Trigger().setTarget(event.getPos()), data.getLevel() + 1);
                            break;
                        }
                    }
                }
            });
        }
    }

    @SubscribeEvent
    public static void onLivingAttackEvent(LivingAttackEvent event) {
        Entity entity = event.getSource().m_7639_();
        if (entity != null) {
            entity.getCapability(StandDataCapabilityProvider.STAND_DATA).ifPresent(data -> {
                block6: {
                    Stand stand = Stand.getStand(data.getStand());
                    if (!(stand instanceof StandKillerQueen) || !data.isTriggered() || !(entity instanceof LivingEntity)) break block6;
                    LivingEntity living = (LivingEntity)entity;
                    if (living instanceof Player) {
                        Player player = (Player)living;
                        Inventory inventory = player.m_150109_();
                        if (!inventory.m_216874_(itemStack -> itemStack.m_150930_((Item)HuaJiItems.KILLER_QUEEN_TRIGGER.get()))) {
                            ItemStack itemStack2 = ((Item)HuaJiItems.KILLER_QUEEN_TRIGGER.get()).m_7968_();
                            ItemKillerQueenTrigger.addTrigger(itemStack2, new ItemKillerQueenTrigger.Trigger().setTarget(event.getEntity().m_20148_()), data.getLevel() + 1);
                            player.m_150109_().m_36054_(itemStack2);
                        } else {
                            for (int j = 0; j < inventory.m_6643_(); ++j) {
                                ItemStack itemStack3 = inventory.m_8020_(j);
                                if (!itemStack3.m_150930_((Item)HuaJiItems.KILLER_QUEEN_TRIGGER.get())) continue;
                                ItemKillerQueenTrigger.addTrigger(itemStack3, new ItemKillerQueenTrigger.Trigger().setTarget(event.getEntity().m_20148_()), data.getLevel() + 1);
                                break;
                            }
                        }
                    } else {
                        for (ItemStack itemStack4 : living.m_20158_()) {
                            if (!itemStack4.m_150930_((Item)HuaJiItems.KILLER_QUEEN_TRIGGER.get())) continue;
                            ItemKillerQueenTrigger.addTrigger(itemStack4, new ItemKillerQueenTrigger.Trigger().setTarget(event.getEntity().m_20148_()), data.getLevel() + 1);
                            break;
                        }
                    }
                }
            });
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Map<String, ModelLayerLocation> getModelLocations() {
        return MODEL_LAYER_MAP;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Map<String, ResourceLocation> getModelTextures() {
        return TEXTURE_MAP;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Map<String, List<Double>> getModelTranslations() {
        return TRANSLATION_MAP;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Map<ModelLayerLocation, Supplier<LayerDefinition>> getModels() {
        return MODEL_MAP;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Map<ModelLayerLocation, Function<ModelPart, ModelStandBase>> getModelFunction() {
        return MODEL_FUNCTION_MAP;
    }

    @Override
    public boolean shouldRenderHand(LivingEntity livingEntity, IStandData data) {
        return !data.isTriggered() || !data.getState().equals("huajiage.punch");
    }
}

