/*
 * Decompiled with CFR 0.152.
 */
package net.mrqx.huajiage.client.event;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.mrqx.huajiage.capability.stand.StandDataCapabilityProvider;
import net.mrqx.huajiage.client.layer.LayerStand;
import net.mrqx.huajiage.item.equipment.armor.ItemOrgaArmor;
import net.mrqx.huajiage.item.stand.ItemOrgaRequiem;
import net.mrqx.huajiage.mixin.AccessorLivingEntityRenderer;
import net.mrqx.huajiage.registy.HuaJiEffects;
import net.mrqx.huajiage.registy.HuaJiSoundEvents;
import net.mrqx.huajiage.stand.Stand;
import net.mrqx.huajiage.stand.StandOrgaRequiem;
import net.mrqx.huajiage.utils.HuaJiSoundPlayer;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber
public class OrgaClientHandler {
    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void onLivingTickEvent(LivingEvent.LivingTickEvent event) {
        LivingEntity entity = event.getEntity();
        OrgaClientHandler.startRequiemMusic(entity);
        OrgaClientHandler.stopRequiemMusic(entity);
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static <T extends LivingEntity, M extends EntityModel<T>> void onRenderPlayerEvent(RenderLivingEvent.Pre<T, M> event) {
        LivingEntity entity = event.getEntity();
        entity.getCapability(StandDataCapabilityProvider.STAND_DATA).ifPresent(data -> {
            Stand stand = Stand.getStand(data.getStand());
            if (stand instanceof StandOrgaRequiem && data.isTriggered() && data.getState().equals("huajiage.fly")) {
                event.setCanceled(true);
                AccessorLivingEntityRenderer accessorLivingEntityRenderer = (AccessorLivingEntityRenderer)event.getRenderer();
                accessorLivingEntityRenderer.getLayers().forEach(layer -> {
                    if (layer instanceof LayerStand) {
                        Entity patt3206$temp;
                        LayerStand layerStand = (LayerStand)((Object)((Object)layer));
                        PoseStack poseStack = event.getPoseStack();
                        poseStack.m_85836_();
                        boolean shouldSit = entity.m_20159_() && entity.m_20202_() != null && entity.m_20202_().shouldRiderSit();
                        float partialTicks = event.getPartialTick();
                        float f = Mth.m_14189_((float)partialTicks, (float)entity.f_20884_, (float)entity.f_20883_);
                        float f1 = Mth.m_14189_((float)partialTicks, (float)entity.f_20886_, (float)entity.f_20885_);
                        float f2 = f1 - f;
                        if (shouldSit && (patt3206$temp = entity.m_20202_()) instanceof LivingEntity) {
                            LivingEntity livingentity = (LivingEntity)patt3206$temp;
                            f = Mth.m_14189_((float)partialTicks, (float)livingentity.f_20884_, (float)livingentity.f_20883_);
                            f2 = f1 - f;
                            float f3 = Mth.m_14177_((float)f2);
                            if (f3 < -85.0f) {
                                f3 = -85.0f;
                            }
                            if (f3 >= 85.0f) {
                                f3 = 85.0f;
                            }
                            f = f1 - f3;
                            if (f3 * f3 > 2500.0f) {
                                f += f3 * 0.2f;
                            }
                            f2 = f1 - f;
                        }
                        float f6 = Mth.m_14179_((float)partialTicks, (float)entity.f_19860_, (float)entity.m_146909_());
                        if (LivingEntityRenderer.m_194453_((LivingEntity)entity)) {
                            f6 *= -1.0f;
                            f2 *= -1.0f;
                        }
                        float f8 = 0.0f;
                        float f5 = 0.0f;
                        if (!shouldSit && entity.m_6084_()) {
                            f8 = entity.f_267362_.m_267711_(partialTicks);
                            f5 = entity.f_267362_.m_267590_(partialTicks);
                            if (entity.m_6162_()) {
                                f5 *= 3.0f;
                            }
                            if (f8 > 1.0f) {
                                f8 = 1.0f;
                            }
                        }
                        float f7 = (float)entity.f_19797_ + partialTicks;
                        accessorLivingEntityRenderer.huaJiAgeInvokeSetupRotations(entity, poseStack, f7, f, partialTicks);
                        poseStack.m_85841_(-1.0f, -1.0f, 1.0f);
                        accessorLivingEntityRenderer.huaJiAgeInvokeScale(entity, poseStack, partialTicks);
                        poseStack.m_252880_(0.0f, -1.501f, 0.0f);
                        layerStand.render(poseStack, event.getMultiBufferSource(), event.getPackedLight(), entity, f5, f8, partialTicks, f7, f2, f6);
                        poseStack.m_85849_();
                    }
                });
            }
        });
    }

    private static void startRequiemMusic(LivingEntity living) {
        int requiemDuration;
        MobEffectInstance effect;
        if (living.m_21023_((MobEffect)HuaJiEffects.REQUIEM.get()) && (effect = living.m_21124_((MobEffect)HuaJiEffects.REQUIEM.get())) != null && (requiemDuration = effect.m_19557_()) == 599 && living.m_9236_().f_46443_) {
            Minecraft.m_91087_().m_91106_().m_120405_();
            HuaJiSoundPlayer.playMusic((SoundEvent)HuaJiSoundEvents.ORGA_REQUIEM_GOLD.get());
        }
    }

    private static void stopRequiemMusic(LivingEntity target) {
        if (target instanceof Player) {
            boolean hasOrga;
            Player player = (Player)target;
            boolean bl = hasOrga = ItemOrgaArmor.hasAllOrgaArmor((LivingEntity)player) || player.getCapability(StandDataCapabilityProvider.STAND_DATA).map(data -> Stand.getStand(data.getStand()) instanceof StandOrgaRequiem).orElse(false) != false;
            if (hasOrga && player.m_21023_((MobEffect)HuaJiEffects.REQUIEM.get())) {
                boolean hasRequiemItem = ItemOrgaRequiem.hasValidOrgaRequiem((LivingEntity)player);
                boolean hasStandPotion = player.m_21023_((MobEffect)HuaJiEffects.STAND_POWER.get());
                if (!hasRequiemItem && !hasStandPotion) {
                    Minecraft.m_91087_().m_91106_().m_120405_();
                }
            }
        }
    }
}

