/*
 * Decompiled with CFR 0.152.
 */
package net.mrqx.huajiage.compat;

import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraftforge.eventbus.api.IEventBus;
import net.mrqx.huajiage.compat.curios.CuriosItemFactory;
import net.mrqx.huajiage.compat.ltc2.LaTiaoCraftFactory;
import net.mrqx.huajiage.compat.slashblade.SlashBladeFactory;
import net.mrqx.huajiage.item.ItemInfiniteCharm;
import org.apache.logging.log4j.util.LoaderUtil;

public class HuaJiCompat {
    public static final TagKey<Item> LATIAO_TAG = ItemTags.create((ResourceLocation)new ResourceLocation("ltc2", "latiao"));
    public static final TagKey<Item> CHARM_ITEM_TAG = ItemTags.create((ResourceLocation)new ResourceLocation("curios", "charm"));
    private static final HuaJiCompat INSTANCE = new HuaJiCompat();
    public final boolean hasJEI = LoaderUtil.isClassAvailable((String)"mezz.jei.api.JeiPlugin");
    public final boolean hasPatchouli = LoaderUtil.isClassAvailable((String)"vazkii.patchouli.api.IComponentProcessor");
    public final boolean hasCurios = LoaderUtil.isClassAvailable((String)"top.theillusivec4.curios.api.type.capability.ICurioItem");
    public final boolean hasFantasyEnding = LoaderUtil.isClassAvailable((String)"com.mega.uom.ModSource");
    public final boolean hasSlashBlade = LoaderUtil.isClassAvailable((String)"mods.flammpfeil.slashblade.SlashBlade");
    public final boolean hasTetra = LoaderUtil.isClassAvailable((String)"se.mickelus.tetra.TetraMod");
    public final boolean hasLaTiaoCraft = LoaderUtil.isClassAvailable((String)"com.doggystudio.chirencqr.ltc.server.LatiaoCraft");

    public static HuaJiCompat getInstance() {
        return INSTANCE;
    }

    private HuaJiCompat() {
    }

    public static Item makeInfiniteCharmCurios() {
        if (HuaJiCompat.getInstance().hasCurios) {
            return CuriosItemFactory.makeInfiniteCharm();
        }
        return new ItemInfiniteCharm();
    }

    public static void register(IEventBus modEventBus) {
        if (HuaJiCompat.getInstance().hasSlashBlade) {
            SlashBladeFactory.register(modEventBus);
        }
    }

    public static void commonSetup() {
        if (HuaJiCompat.getInstance().hasLaTiaoCraft) {
            LaTiaoCraftFactory.init();
        }
    }
}

