/*
 * Decompiled with CFR 0.152.
 */
package net.mrqx.huajiage.data.loot;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSyntaxException;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class RandomNbtFunction
extends LootItemConditionalFunction {
    public static LootItemFunctionType TYPE = null;
    private final ListTag tags;
    private final int number;

    protected RandomNbtFunction(LootItemCondition[] predicates, ListTag tags, int number) {
        super(predicates);
        this.tags = tags;
        this.number = number;
    }

    protected ItemStack m_7372_(ItemStack stack, LootContext context) {
        CompoundTag compoundTag = stack.m_41784_();
        int count = this.tags.size();
        int number = context.m_230907_().m_188503_(count);
        CompoundTag tag = number < count ? this.tags.m_128728_(number) : this.tags.m_128728_(count - 1);
        compoundTag.m_128391_(tag);
        stack.m_41751_(compoundTag);
        return stack;
    }

    public static void register() {
        TYPE = (LootItemFunctionType)Registry.m_122965_((Registry)BuiltInRegistries.f_256753_, (ResourceLocation)new ResourceLocation("huajiage", "random_nbt_function"), (Object)new LootItemFunctionType((net.minecraft.world.level.storage.loot.Serializer)new Serializer()));
    }

    public LootItemFunctionType m_7162_() {
        return TYPE;
    }

    public static LootItemConditionalFunction.Builder<?> setTags(ListTag tags, int number) {
        return RandomNbtFunction.m_80683_(conditions -> new RandomNbtFunction((LootItemCondition[])conditions, tags, number));
    }

    public static final class Serializer
    extends LootItemConditionalFunction.Serializer<RandomNbtFunction> {
        public void serialize(JsonObject object, RandomNbtFunction functionObject, JsonSerializationContext context) {
            int count = functionObject.tags.size();
            for (int i = 0; i < count; ++i) {
                CompoundTag tag = functionObject.tags.m_128728_(i);
                object.addProperty("tag" + (i + 1), tag.toString());
            }
            object.addProperty("number", (Number)functionObject.number);
        }

        public RandomNbtFunction deserialize(JsonObject object, JsonDeserializationContext context, LootItemCondition[] conditions) {
            try {
                ListTag list = new ListTag();
                int size = GsonHelper.m_13927_((JsonObject)object, (String)"number");
                if (size < 1) {
                    size = 1;
                }
                for (int i = 0; i < size; ++i) {
                    String id;
                    CompoundTag nbtTag = TagParser.m_129359_((String)GsonHelper.m_13906_((JsonObject)object, (String)("tag" + (i + 1))));
                    if (nbtTag.m_128441_("StandId") && (id = nbtTag.m_128461_("StandId")).contains("-")) {
                        nbtTag.m_128359_("StandId", id.replace("-", ":"));
                    }
                    list.add((Object)nbtTag);
                }
                return new RandomNbtFunction(conditions, list, size);
            }
            catch (Exception e) {
                throw new JsonSyntaxException((Throwable)e);
            }
        }
    }
}

