/*
 * Decompiled with CFR 0.152.
 */
package net.mrqx.huajiage.entity;

import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Fireball;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.network.PlayMessages;
import net.mrqx.huajiage.HuaJiAgeMod;
import net.mrqx.huajiage.entity.ExplosionHuaJi;
import net.mrqx.huajiage.utils.HuaJiDamageSources;

public class EntityFivePower
extends Fireball {
    private static final EntityDataAccessor<Float> DAMAGE = SynchedEntityData.m_135353_(EntityFivePower.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Boolean> IS_DE = SynchedEntityData.m_135353_(EntityFivePower.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Long> DELAY = SynchedEntityData.m_135353_(EntityFivePower.class, (EntityDataSerializer)EntityDataSerializers.f_244073_);
    public final long randomSeed;
    public boolean timeStopFix = false;

    public EntityFivePower(EntityType<? extends Fireball> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.randomSeed = pLevel.f_46441_.m_188505_();
    }

    public EntityFivePower(LivingEntity pShooter, double pOffsetX, double pOffsetY, double pOffsetZ, Level pLevel) {
        super(HuaJiAgeMod.RegistryEvents.fivePowerEntityType, pShooter, pOffsetX, pOffsetY, pOffsetZ, pLevel);
        this.randomSeed = pLevel.f_46441_.m_188505_();
    }

    public static EntityFivePower createInstance(PlayMessages.SpawnEntity packet, Level worldIn) {
        return new EntityFivePower(HuaJiAgeMod.RegistryEvents.fivePowerEntityType, worldIn);
    }

    public static EntityFivePower create(EntityType<? extends Fireball> pEntityType, Level pLevel) {
        return new EntityFivePower(pEntityType, pLevel);
    }

    public ItemStack m_37018_() {
        return Items.f_41852_.m_7968_();
    }

    @Nullable
    public ItemStack getPickedResult(HitResult target) {
        return Items.f_41852_.m_7968_();
    }

    public boolean m_6087_() {
        return false;
    }

    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128350_("damage", this.getDamage());
        pCompound.m_128379_("is_de", this.isDe());
        pCompound.m_128356_("delay", this.getDelay());
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DAMAGE, (Object)Float.valueOf(15.0f));
        this.f_19804_.m_135372_(IS_DE, (Object)false);
        this.f_19804_.m_135372_(DELAY, (Object)0L);
    }

    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.setDamage(pCompound.m_128457_("damage"));
        this.setIsDe(pCompound.m_128471_("is_de"));
        this.setDelay(pCompound.m_128454_("delay"));
    }

    public boolean m_20068_() {
        return true;
    }

    protected boolean m_5931_() {
        return false;
    }

    protected float m_6884_() {
        return 1.0f;
    }

    protected ParticleOptions m_5967_() {
        return this.isDe() ? ParticleTypes.f_123744_ : ParticleTypes.f_123762_;
    }

    public void m_8119_() {
        this.setDelay(this.getDelay() - 1L);
        if (this.getDelay() <= 0L) {
            super.m_8119_();
            if (this.getDelay() < -300L) {
                this.m_146870_();
            }
        }
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        return false;
    }

    protected void m_8060_(BlockHitResult pResult) {
        super.m_8060_(pResult);
        if (!this.m_9236_().f_46443_) {
            this.explode();
        }
    }

    protected void m_5790_(EntityHitResult pResult) {
        super.m_5790_(pResult);
        if (!(pResult.m_82443_() instanceof EntityFivePower || pResult.m_82443_().equals((Object)this.m_19749_()) || this.m_9236_().f_46443_)) {
            this.explode();
        }
    }

    protected void explode() {
        ExplosionHuaJi explosion = new ExplosionHuaJi(this.m_9236_(), this.m_19749_(), HuaJiDamageSources.five(this.m_9236_(), (Entity)this, this.m_19749_(), this.m_20182_()), null, this.m_20185_(), this.m_20186_(), this.m_20189_(), 1.9f, Explosion.BlockInteraction.KEEP, this.getDamage(), 0.0, false, entity -> {
            if (this.isDe() && entity instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity;
                living.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 60));
                living.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 60, 2));
                living.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 60, 2));
                living.m_7292_(new MobEffectInstance(MobEffects.f_19619_, 60));
            } else if (!this.isDe()) {
                Entity patt6548$temp;
                entity.m_20254_(3);
                entity.m_6469_(HuaJiDamageSources.five(this.m_9236_(), (Entity)this, this.m_19749_(), this.m_20182_()), 15.0f);
                if (!this.timeStopFix) {
                    for (int i = 0; i < 3; ++i) {
                        LightningBolt bolt = new LightningBolt(EntityType.f_20465_, entity.m_9236_());
                        bolt.m_146884_(entity.m_20182_());
                        bolt.m_20874_(true);
                        entity.m_9236_().m_7967_((Entity)bolt);
                    }
                    this.timeStopFix = true;
                }
                if ((patt6548$temp = this.m_19749_()) instanceof LivingEntity) {
                    LivingEntity living = (LivingEntity)patt6548$temp;
                    living.m_5634_(2.0f);
                }
            }
        });
        explosion.m_46061_();
        explosion.m_46075_(true);
    }

    public float getDamage() {
        return ((Float)this.f_19804_.m_135370_(DAMAGE)).floatValue();
    }

    public void setDamage(float damage) {
        this.f_19804_.m_135381_(DAMAGE, (Object)Float.valueOf(damage));
    }

    public boolean isDe() {
        return (Boolean)this.f_19804_.m_135370_(IS_DE);
    }

    public void setIsDe(boolean isDe) {
        this.f_19804_.m_135381_(IS_DE, (Object)isDe);
    }

    public long getDelay() {
        return (Long)this.f_19804_.m_135370_(DELAY);
    }

    public void setDelay(long delay) {
        this.f_19804_.m_135381_(DELAY, (Object)delay);
    }
}

