/*
 * Decompiled with CFR 0.152.
 */
package net.mrqx.huajiage.event.handler;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.UUID;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.mrqx.huajiage.capability.stand.StandDataCapabilityProvider;
import net.mrqx.huajiage.data.HuaJiDamageTypes;
import net.mrqx.huajiage.item.equipment.armor.ItemOrgaArmor;
import net.mrqx.huajiage.item.stand.ItemOrgaRequiem;
import net.mrqx.huajiage.registy.HuaJiEffects;
import net.mrqx.huajiage.registy.HuaJiItems;
import net.mrqx.huajiage.registy.HuaJiSoundEvents;
import net.mrqx.huajiage.stand.Stand;
import net.mrqx.huajiage.stand.StandOrgaRequiem;
import net.mrqx.huajiage.utils.HuaJiDamageSources;
import net.mrqx.huajiage.utils.HuaJiSoundPlayer;
import org.jetbrains.annotations.Nullable;

@Mod.EventBusSubscriber
public class OrgaEventHandler {
    private static final String PLAYER_UUID = "huajiage.orgaPlayerUuid";
    private static final String REQUIEM = "huajiage.orgaRequiem";
    public static final int HOPE_FLOWER_TIME = 2720;
    private static final List<Integer> SING_LIST = ImmutableList.of((Object)104, (Object)244, (Object)368, (Object)474, (Object)544, (Object)776, (Object)862, (Object)942, (Object)962, (Object)1010, (Object)1096, (Object)1226, (Object[])new Integer[]{1364, 1460, 1470, 1520, 1566, 1620, 1700, 1876, 1956, 2008, 2226, 2260, 2280, 2520});

    @SubscribeEvent
    public static void onLivingTickEvent(LivingEvent.LivingTickEvent event) {
        LivingEntity entity = event.getEntity();
        if (entity.m_9236_().f_46443_) {
            return;
        }
        OrgaEventHandler.handleOrgaEntityUpdate(entity);
        OrgaEventHandler.handleRequiemTargetUpdate(entity);
        OrgaEventHandler.handleRequiemStateUpdate(entity);
    }

    @SubscribeEvent
    public static void onLivingDeathEvent(LivingDeathEvent event) {
        LivingEntity entity = event.getEntity();
        if (entity.m_9236_().f_46443_) {
            return;
        }
        OrgaEventHandler.handleOrgaEntityDeath(event, entity);
        OrgaEventHandler.handleStandOrgaDeath(event, entity);
    }

    @SubscribeEvent
    public static void onLivingHurtEvent(LivingHurtEvent event) {
        LivingEntity entity = event.getEntity();
        if (entity.m_9236_().f_46443_) {
            return;
        }
        Entity attacker = event.getSource().m_7639_();
        OrgaEventHandler.handleOrgaEntityHurt(event, entity, attacker);
        OrgaEventHandler.handleStandOrgaHurt(event, entity, attacker);
    }

    @SubscribeEvent
    public static void onLivingAttackEvent(LivingAttackEvent event) {
        LivingEntity living;
        Entity entity = event.getSource().m_7639_();
        LivingEntity target = event.getEntity();
        if (target.m_9236_().f_46443_) {
            return;
        }
        if (entity instanceof LivingEntity && (living = (LivingEntity)entity).m_21023_((MobEffect)HuaJiEffects.REQUIEM.get()) && target instanceof LivingEntity) {
            HuaJiSoundPlayer.playMovingSoundToClient((Entity)target, (SoundEvent)HuaJiSoundEvents.ORGA_REQUIEM_HIT.get());
            target.m_6469_(HuaJiDamageSources.simpleNullSource(living.m_9236_(), HuaJiDamageTypes.REQUIEM), 5.0f);
            target.getPersistentData().m_128405_(REQUIEM, 60);
            target.getPersistentData().m_128359_(PLAYER_UUID, living.m_20149_());
        }
    }

    private static void handleOrgaEntityUpdate(LivingEntity living) {
        MobEffectInstance effectRequiem;
        MobEffectInstance effectHopeFlower = living.m_21124_((MobEffect)HuaJiEffects.HOPE_FLOWER.get());
        if (effectHopeFlower != null) {
            int hopeDuration = effectHopeFlower.m_19557_();
            if (ItemOrgaRequiem.hasValidOrgaRequiem(living)) {
                living.m_21195_((MobEffect)HuaJiEffects.HOPE_FLOWER.get());
                living.m_21195_(MobEffects.f_19597_);
            }
            if (hopeDuration == 2720) {
                living.m_7292_(new MobEffectInstance(MobEffects.f_19597_, hopeDuration, 5));
                living.m_7292_(new MobEffectInstance(MobEffects.f_19599_, hopeDuration, 5));
                living.m_7292_(new MobEffectInstance(MobEffects.f_19613_, hopeDuration, 5));
                HuaJiSoundPlayer.playMovingSoundToClient((Entity)living, (SoundEvent)HuaJiSoundEvents.ORGA_FLOWER.get(), 5.0f);
            }
            if (hopeDuration == 844) {
                living.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 844, 9));
                living.m_7292_(new MobEffectInstance(MobEffects.f_19599_, 844, 9));
                living.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 844, 9));
                living.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 844));
                living.m_7292_(new MobEffectInstance(MobEffects.f_216964_, 844));
            }
            if (hopeDuration < 20 && !living.getCapability(StandDataCapabilityProvider.STAND_DATA).map(data -> Stand.getStand(data.getStand()) instanceof StandOrgaRequiem).orElse(false).booleanValue()) {
                living.m_6469_(HuaJiDamageSources.simpleNullSource(living.m_9236_(), HuaJiDamageTypes.HOPE_FLOWER), 2.1474836E9f);
            }
        }
        if ((effectRequiem = living.m_21124_((MobEffect)HuaJiEffects.REQUIEM.get())) != null) {
            int requiemDuration;
            boolean hasOrga = ItemOrgaArmor.hasAllOrgaArmor(living);
            if (hasOrga) {
                boolean hasRequiemItem = ItemOrgaRequiem.hasValidOrgaRequiem(living);
                boolean hasStandPotion = living.m_21023_((MobEffect)HuaJiEffects.STAND_POWER.get());
                if (!hasRequiemItem && !hasStandPotion) {
                    living.m_21195_((MobEffect)HuaJiEffects.REQUIEM.get());
                }
            }
            if ((requiemDuration = effectRequiem.m_19557_()) == 599) {
                living.m_213846_((Component)Component.m_237115_((String)"message.huajiage.orga_requiem.bgm.1"));
                living.m_213846_((Component)Component.m_237115_((String)"message.huajiage.orga_requiem.bgm.2"));
            }
        }
    }

    private static void handleRequiemTargetUpdate(LivingEntity target) {
        int targetDuration;
        MobEffectInstance effectOrgaTarget;
        Player player;
        String playerUuid = target.getPersistentData().m_128461_(PLAYER_UUID);
        if (!playerUuid.isEmpty() && (player = target.m_9236_().m_46003_(UUID.fromString(playerUuid))) != null) {
            int requiemTime = target.getPersistentData().m_128451_(REQUIEM);
            if (requiemTime <= 0) {
                return;
            }
            target.getPersistentData().m_128405_(REQUIEM, requiemTime - 1);
            if (target.f_19797_ % 5 == 0) {
                target.m_6469_(HuaJiDamageSources.simpleNullSource(player.m_9236_(), HuaJiDamageTypes.REQUIEM), player.m_21233_() / 2.0f);
            }
        }
        if ((effectOrgaTarget = target.m_21124_((MobEffect)HuaJiEffects.ORGA_TARGET.get())) != null && (targetDuration = effectOrgaTarget.m_19557_()) == 30) {
            Player nearestPlayer = target.m_9236_().m_45930_((Entity)target, 100.0);
            if (nearestPlayer != null && target != nearestPlayer) {
                if (!nearestPlayer.m_150109_().m_36063_(new ItemStack((ItemLike)HuaJiItems.ORGA_REQUIEM.get()))) {
                    nearestPlayer.m_213846_((Component)Component.m_237115_((String)"message.huajiage.orga.shot"));
                }
                target.m_6469_(HuaJiDamageSources.simple((Entity)nearestPlayer, HuaJiDamageTypes.ORGA_SHOT), 30.0f);
            } else {
                target.m_6469_(HuaJiDamageSources.simpleNullSource(target.m_9236_(), HuaJiDamageTypes.ORGA_SHOT), 30.0f);
            }
        }
    }

    private static void handleRequiemStateUpdate(LivingEntity target) {
        String playerUuid;
        if (target.m_21023_((MobEffect)HuaJiEffects.REQUIEM_TARGET.get()) && !target.m_21023_((MobEffect)HuaJiEffects.HOPE_FLOWER.get()) && !target.m_21023_((MobEffect)HuaJiEffects.REQUIEM.get()) && !(playerUuid = target.getPersistentData().m_128461_(PLAYER_UUID)).isEmpty()) {
            Player player = target.m_9236_().m_46003_(UUID.fromString(playerUuid));
            if (target.f_19797_ % (target instanceof Player ? 10 : 5) == 0) {
                if (player != null) {
                    target.m_6469_(HuaJiDamageSources.simple((Entity)player, HuaJiDamageTypes.REQUIEM), 12.0f + player.m_21233_());
                } else {
                    target.m_6469_(HuaJiDamageSources.simpleNullSource(target.m_9236_(), HuaJiDamageTypes.REQUIEM), 32.0f);
                }
            }
        }
    }

    private static void handleOrgaEntityDeath(LivingDeathEvent event, LivingEntity living) {
        MobEffectInstance effect;
        if (ItemOrgaArmor.hasAllOrgaArmor(living) && !living.m_21023_((MobEffect)HuaJiEffects.HOPE_FLOWER.get()) && !living.m_21023_((MobEffect)HuaJiEffects.REQUIEM.get())) {
            if (ItemOrgaRequiem.hasValidOrgaRequiem(living)) {
                living.m_7292_(new MobEffectInstance((MobEffect)HuaJiEffects.REQUIEM.get(), 600));
            } else {
                int hopeDuration = 2820;
                living.m_7292_(new MobEffectInstance((MobEffect)HuaJiEffects.HOPE_FLOWER.get(), hopeDuration));
            }
        }
        if ((effect = living.m_21124_((MobEffect)HuaJiEffects.HOPE_FLOWER.get())) == null || effect.m_19557_() >= 20) {
            event.setCanceled(true);
            living.m_21153_(1.0f);
        }
    }

    private static void handleStandOrgaDeath(LivingDeathEvent event, LivingEntity entity) {
        entity.getCapability(StandDataCapabilityProvider.STAND_DATA).ifPresent(data -> {
            Stand stand = Stand.getStand(data.getStand());
            if (stand instanceof StandOrgaRequiem && data.isTriggered()) {
                event.setCanceled(true);
                entity.m_21153_(1.0f);
                entity.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 100, 4));
                entity.m_7292_(new MobEffectInstance(MobEffects.f_19603_, 100, 2));
                HuaJiSoundPlayer.playMovingSoundToClient((Entity)entity, (SoundEvent)HuaJiSoundEvents.ORGA_REQUIEM_PROTECT.get());
            }
        });
    }

    private static void handleOrgaEntityHurt(LivingHurtEvent event, LivingEntity living, @Nullable Entity attacker) {
        if (living.m_21023_((MobEffect)HuaJiEffects.HOPE_FLOWER.get()) && attacker instanceof LivingEntity) {
            LivingEntity livingAttacker = (LivingEntity)attacker;
            if (attacker != living) {
                if (ItemOrgaRequiem.hasValidOrgaRequiem(living)) {
                    attacker.m_6469_(HuaJiDamageSources.simple((Entity)living, HuaJiDamageTypes.REQUIEM), event.getAmount() * 2.0f);
                }
                if (living.m_21223_() < 2.0f && !livingAttacker.m_21023_((MobEffect)HuaJiEffects.ORGA_TARGET.get())) {
                    if (!ItemOrgaRequiem.hasValidOrgaRequiem(living)) {
                        HuaJiSoundPlayer.playMovingSoundToClient((Entity)living, (SoundEvent)HuaJiSoundEvents.ORGA_SHOT.get());
                    }
                    livingAttacker.m_7292_(new MobEffectInstance((MobEffect)HuaJiEffects.ORGA_TARGET.get(), 100));
                }
            }
        }
    }

    private static void handleStandOrgaHurt(LivingHurtEvent event, LivingEntity entity, @Nullable Entity attacker) {
        entity.getCapability(StandDataCapabilityProvider.STAND_DATA).ifPresent(data -> {
            Stand stand = Stand.getStand(data.getStand());
            if (stand instanceof StandOrgaRequiem && data.isTriggered() && attacker instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)attacker;
                if (attacker != entity) {
                    attacker.m_6469_(HuaJiDamageSources.simple((Entity)entity, HuaJiDamageTypes.REQUIEM), event.getAmount() * 2.0f);
                    if (entity.m_21223_() < 2.0f && !living.m_21023_((MobEffect)HuaJiEffects.REQUIEM_TARGET.get())) {
                        living.m_7292_(new MobEffectInstance((MobEffect)HuaJiEffects.REQUIEM_TARGET.get(), 100));
                    }
                }
            }
        });
    }

    @SubscribeEvent
    public static void onOrgaSinging(LivingEvent.LivingTickEvent event) {
        LivingEntity living = event.getEntity();
        if (living.m_9236_().f_46443_) {
            return;
        }
        MobEffectInstance effect = living.m_21124_((MobEffect)HuaJiEffects.HOPE_FLOWER.get());
        if (effect != null) {
            int duration = 2720 - effect.m_19557_();
            if (SING_LIST.contains(duration)) {
                int i = SING_LIST.indexOf(duration) + 1;
                living.m_213846_((Component)Component.m_237115_((String)("message.huajiage.orga.sing." + String.format("%02d", i))));
            }
            if (duration >= 1876 && duration <= 1893) {
                living.m_213846_((Component)Component.m_237115_((String)("message.huajiage.orga.sing.p" + String.format("%02d", duration - 1876))));
            }
        }
    }
}

