/*
 * Decompiled with CFR 0.152.
 */
package net.mrqx.huajiage.block.inventory;

import net.minecraft.core.BlockPos;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.mrqx.huajiage.block.blockentity.HuaJiPolyfurnaceBlockEntity;
import net.mrqx.huajiage.block.inventory.HuaJiPolyfurnaceFuelSlot;
import net.mrqx.huajiage.block.inventory.HuaJiResultSlot;
import net.mrqx.huajiage.registy.HuaJiMenus;
import net.mrqx.huajiage.registy.HuaJiRecipes;
import net.mrqx.huajiage.utils.HuaJiUtils;
import org.jetbrains.annotations.Nullable;

public class HuaJiPolyfurnaceMenu
extends AbstractContainerMenu {
    protected final Level level;
    protected final Container container;
    protected final ContainerData data;
    @Nullable
    public final HuaJiPolyfurnaceBlockEntity blockEntity;
    public static final int HOTBAR_SLOT_COUNT = 9;
    public static final int PLAYER_INVENTORY_ROW_COUNT = 3;
    public static final int PLAYER_INVENTORY_COLUMN_COUNT = 9;
    public static final int PLAYER_INVENTORY_SLOT_COUNT = 27;
    public static final int VANILLA_SLOT_COUNT = 36;
    public static final int FUEL_SLOTS_COUNT = 1;
    public static final int INPUT_SLOTS_COUNT = 1;
    public static final int OUTPUT_SLOTS_COUNT = 1;
    public static final int FURNACE_SLOTS_COUNT = 3;
    public static final int INPUT_SLOT_INDEX = 0;
    public static final int FUEL_SLOT_INDEX = 1;
    public static final int OUTPUT_SLOT_INDEX = 2;

    public HuaJiPolyfurnaceMenu(int pContainerId, Inventory pPlayerInventory, @Nullable Level level, @Nullable BlockPos worldPosition) {
        this((MenuType)HuaJiMenus.HUAJI_POLYFURNACE.get(), pContainerId, pPlayerInventory, (Container)new SimpleContainer(3), (ContainerData)new SimpleContainerData(5), level, worldPosition);
    }

    public HuaJiPolyfurnaceMenu(MenuType<?> pMenuType, int pContainerId, Inventory pPlayerInventory, Container pContainer, ContainerData pData, @Nullable Level level, @Nullable BlockPos worldPosition) {
        super(pMenuType, pContainerId);
        HuaJiPolyfurnaceBlockEntity huaJiPolyfurnaceBlockEntity;
        BlockEntity blockEntity;
        this.container = pContainer;
        this.data = pData;
        this.level = pPlayerInventory.f_35978_.m_9236_();
        this.m_38897_(new Slot(this.container, 0, 44, 25));
        this.m_38897_(new HuaJiPolyfurnaceFuelSlot(this, this.container, 1, 44, 48));
        this.m_38897_(new HuaJiResultSlot(pPlayerInventory.f_35978_, this.container, 2, 151, 25));
        int hotbarXpos = 16;
        int hotbarYpos = 129;
        for (int x = 0; x < 9; ++x) {
            this.m_38897_(new Slot((Container)pPlayerInventory, x, 16 + 18 * x, 129));
        }
        int playerInventoryXpos = 16;
        int playerInventoryYpos = 71;
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                int slotId = 9 + i * 9 + j;
                int posX = 16 + j * 18;
                int posY = 71 + i * 18;
                this.m_38897_(new Slot((Container)pPlayerInventory, slotId, posX, posY));
            }
        }
        this.m_38884_(this.data);
        this.blockEntity = level != null && worldPosition != null && (blockEntity = level.m_7702_(worldPosition)) instanceof HuaJiPolyfurnaceBlockEntity ? (huaJiPolyfurnaceBlockEntity = (HuaJiPolyfurnaceBlockEntity)blockEntity) : null;
    }

    public Container getContainer() {
        return this.container;
    }

    public double getProgress() {
        int i = this.data.m_6413_(1);
        int j = this.data.m_6413_(2);
        return j != 0 && i != 0 ? (double)i / (double)j : 0.0;
    }

    public int getEnergy() {
        return this.data.m_6413_(0);
    }

    public int getPool() {
        return this.data.m_6413_(3);
    }

    public double getFuel() {
        return (double)this.data.m_6413_(0) / (double)HuaJiPolyfurnaceBlockEntity.MAX_ENERGY;
    }

    protected boolean isFuel(ItemStack pStack) {
        return HuaJiUtils.isTagFuel(pStack, "huaji_polyfurnace/time_", 23);
    }

    public boolean m_6875_(Player pPlayer) {
        return this.container.m_6542_(pPlayer);
    }

    public ItemStack m_7648_(Player pPlayer, int pIndex) {
        ItemStack itemStack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(pIndex);
        if (slot.m_6657_()) {
            ItemStack itemStack1 = slot.m_7993_();
            itemStack = itemStack1.m_41777_();
            if (pIndex == 2) {
                if (!this.m_38903_(itemStack1, 3, 39, true)) {
                    return ItemStack.f_41583_;
                }
                slot.m_40234_(itemStack1, itemStack);
            } else if (pIndex != 0 && pIndex != 1 ? (this.canProcess(itemStack1) ? !this.m_38903_(itemStack1, 0, 1, false) : (this.isFuel(itemStack1) ? !this.m_38903_(itemStack1, 1, 2, false) : (pIndex >= 3 && pIndex < 30 ? !this.m_38903_(itemStack1, 30, 39, false) : pIndex >= 30 && pIndex < 39 && !this.m_38903_(itemStack1, 3, 30, false)))) : !this.m_38903_(itemStack1, 3, 39, false)) {
                return ItemStack.f_41583_;
            }
            if (itemStack1.m_41619_()) {
                slot.m_269060_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (itemStack1.m_41613_() == itemStack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(pPlayer, itemStack1);
        }
        return itemStack;
    }

    protected boolean canProcess(ItemStack pStack) {
        return this.level.m_7465_().m_44015_((RecipeType)HuaJiRecipes.HUAJI_POLYFURNACE_RECIPE_TYPE.get(), (Container)new SimpleContainer(new ItemStack[]{pStack}), this.level).isPresent();
    }
}

