/*
 * Decompiled with CFR 0.152.
 */
package net.mrqx.huajiage.client.event;

import com.google.gson.JsonSyntaxException;
import com.mega.endinglib.util.time.TimeContext;
import com.mega.endinglib.util.time.TimeStopUtils;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.PostChain;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ComputeFovModifierEvent;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.mrqx.huajiage.HuaJiAgeMod;
import net.mrqx.huajiage.client.renderer.shader.HuaJiShaderManager;
import net.mrqx.huajiage.compat.HuaJiCompat;
import net.mrqx.huajiage.registy.HuaJiSoundEvents;
import net.mrqx.huajiage.utils.HuaJiSoundPlayer;
import net.mrqx.huajiage.utils.QuadConsumer;
import org.apache.commons.lang3.tuple.MutablePair;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class ShaderHandler {
    public static final HashMap<ResourceLocation, Map.Entry<Long, Long>> TIME_STOP_EFFECT_TICK = new HashMap();
    public static final HashMap<ResourceLocation, Integer> TIME_STOPER = new HashMap();
    public static final ResourceLocation TIME_STOP_SHADER = HuaJiAgeMod.prefix("time_stop_shader");
    private static int time = 0;
    private static int lastRenderTime = 0;

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void onRenderLevelStageEvent(RenderLevelStageEvent event) {
        if (event.getStage().equals(RenderLevelStageEvent.Stage.AFTER_LEVEL)) {
            Minecraft minecraft = Minecraft.m_91087_();
            if (minecraft.f_91073_ != null && minecraft.f_91074_ != null && Minecraft.m_91404_() && minecraft.f_91080_ == null) {
                TIME_STOP_EFFECT_TICK.forEach((level, entry) -> {
                    if (minecraft.f_91073_.m_46472_().m_135782_().equals(level)) {
                        int timePassed;
                        long endTime = (Long)entry.getValue();
                        if (time == 0) {
                            time = (int)(TimeContext.Client.currentSeconds() * 20.0f);
                        }
                        if (lastRenderTime == (timePassed = (int)(TimeContext.Client.currentSeconds() * 20.0f - (float)time))) {
                            return;
                        }
                        if (timePassed == 1) {
                            ShaderHandler.addShader(new ResourceLocation("shaders/post/invert.json"));
                        } else if (timePassed == 20) {
                            if (!HuaJiCompat.getInstance().hasFantasyEnding) {
                                ShaderHandler.addShader(new ResourceLocation("shaders/post/desaturate.json"));
                            } else {
                                HuaJiShaderManager.removeShader(TIME_STOP_SHADER);
                            }
                        }
                        if (endTime - (long)timePassed == 20L) {
                            HuaJiSoundPlayer.playClient((SoundInstance)HuaJiSoundPlayer.getMovingSound((Entity)minecraft.f_91074_, (SoundEvent)HuaJiSoundEvents.THE_WORLD_RE.get(), SoundSource.PLAYERS, 1.0f));
                        } else if (endTime - (long)timePassed == 10L) {
                            ShaderHandler.addShader(new ResourceLocation("shaders/post/pencil.json"));
                        } else if (endTime - (long)timePassed <= 3L) {
                            HuaJiShaderManager.removeShader(TIME_STOP_SHADER);
                        }
                        lastRenderTime = timePassed;
                    }
                });
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void onComputeFovModifierEvent(ComputeFovModifierEvent event) {
        Minecraft minecraft = Minecraft.m_91087_();
        if (minecraft.f_91073_ != null && minecraft.f_91074_ != null && Minecraft.m_91404_() && minecraft.f_91080_ == null) {
            TIME_STOP_EFFECT_TICK.forEach((level, entry) -> {
                if (minecraft.f_91073_.m_46472_().m_135782_().equals(level) && TimeStopUtils.isTimeStop && TimeStopUtils.canMove((Entity)minecraft.f_91074_) && TimeStopUtils.andSameDimension((Level)minecraft.f_91073_) && TIME_STOPER.get(level).equals(minecraft.f_91074_.m_19879_())) {
                    float timePassed = TimeContext.Client.currentSeconds() * 20.0f - (float)time;
                    if (timePassed < 30.0f) {
                        event.setNewFovModifier(event.getNewFovModifier() + 0.3f);
                    } else {
                        event.setNewFovModifier(event.getNewFovModifier() + 0.1f);
                    }
                }
            });
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void onRenderGuiOverlayEvent(RenderGuiOverlayEvent.Post event) {
        Minecraft minecraft = Minecraft.m_91087_();
        if (event.getOverlay().id().equals((Object)VanillaGuiOverlay.VIGNETTE.id()) && minecraft.f_91073_ != null && minecraft.f_91074_ != null && (minecraft.f_91080_ == null || minecraft.f_91080_ instanceof ChatScreen)) {
            ArrayList removeList = new ArrayList();
            TIME_STOP_EFFECT_TICK.forEach((level, startTick) -> {
                if (minecraft.f_91073_.m_46472_().m_135782_().equals(level)) {
                    if (TimeStopUtils.isTimeStop && TimeStopUtils.canMove((Entity)minecraft.f_91074_) && TimeStopUtils.andSameDimension((Level)minecraft.f_91073_)) {
                        if (TIME_STOPER.get(level).equals(minecraft.f_91074_.m_19879_())) {
                            GuiGraphics guiGraphics = event.getGuiGraphics();
                            Window window = minecraft.m_91268_();
                            ShaderHandler.renderView(guiGraphics, HuaJiAgeMod.prefix("textures/misc/time_stop_view.png"));
                            ShaderHandler.renderElement(HuaJiAgeMod.prefix("textures/misc/gear_1.png"), 0, 0, 512.0f, 512.0f, 0.25f, 0.25f, false);
                            ShaderHandler.renderElement(HuaJiAgeMod.prefix("textures/misc/gear_2.png"), window.m_85445_(), window.m_85446_(), 512.0f, 512.0f, 0.25f, 0.25f, true);
                        }
                    } else {
                        removeList.add(level);
                        HuaJiShaderManager.removeShader(TIME_STOP_SHADER);
                    }
                }
            });
            removeList.forEach(TIME_STOP_EFFECT_TICK::remove);
        }
    }

    public static void addShader(ResourceLocation resourceLocation) {
        PostChain postChain = ShaderHandler.loadEffect(resourceLocation);
        if (postChain != null) {
            HuaJiShaderManager.removeShader(TIME_STOP_SHADER);
            HuaJiShaderManager.POST_CHAINS.put(TIME_STOP_SHADER, postChain);
        }
    }

    @Nullable
    public static PostChain loadEffect(ResourceLocation resourceLocation) {
        PostChain postEffect = null;
        Minecraft minecraft = Minecraft.m_91087_();
        try {
            postEffect = new PostChain(minecraft.m_91097_(), minecraft.m_91098_(), minecraft.m_91385_(), resourceLocation);
            postEffect.m_110025_(minecraft.m_91268_().m_85441_(), minecraft.m_91268_().m_85442_());
        }
        catch (IOException ioexception) {
            HuaJiAgeMod.LOGGER.warn("Failed to load shader: {}", (Object)resourceLocation, (Object)ioexception);
        }
        catch (JsonSyntaxException jsonsyntaxexception) {
            HuaJiAgeMod.LOGGER.warn("Failed to parse shader: {}", (Object)resourceLocation, (Object)jsonsyntaxexception);
        }
        return postEffect;
    }

    public static void renderView(GuiGraphics guiGraphics, ResourceLocation texture) {
        RenderSystem.enableDepthTest();
        RenderSystem.enableBlend();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ZERO, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_COLOR, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        RenderSystem.setShaderColor((float)0.25f, (float)0.25f, (float)0.25f, (float)1.0f);
        int width = guiGraphics.m_280182_();
        int height = guiGraphics.m_280206_();
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)texture);
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder buffer = tesselator.m_85915_();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        buffer.m_5483_(0.0, (double)height, -90.0).m_7421_(0.0f, 1.0f).m_5752_();
        buffer.m_5483_((double)width, (double)height, -90.0).m_7421_(1.0f, 1.0f).m_5752_();
        buffer.m_5483_((double)width, 0.0, -90.0).m_7421_(1.0f, 0.0f).m_5752_();
        buffer.m_5483_(0.0, 0.0, -90.0).m_7421_(0.0f, 0.0f).m_5752_();
        tesselator.m_85914_();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.disableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.defaultBlendFunc();
    }

    public static void renderElement(ResourceLocation texture, int x, int y, float width, float heigh, float xScale, float yScale, boolean reverse) {
        RenderSystem.disableDepthTest();
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ZERO, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_COLOR, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        RenderSystem.setShaderColor((float)0.3f, (float)0.3f, (float)0.3f, (float)1.0f);
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)texture);
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder buffer = tesselator.m_85915_();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        if (reverse) {
            x -= (int)(width * xScale);
            y -= (int)(heigh * yScale);
        }
        buffer.m_5483_((double)x, (double)((float)y + heigh * yScale), 0.0).m_7421_(0.0f, 1.0f).m_5752_();
        buffer.m_5483_((double)((float)x + width * xScale), (double)((float)y + heigh * yScale), 0.0).m_7421_(1.0f, 1.0f).m_5752_();
        buffer.m_5483_((double)((float)x + width * xScale), (double)y, 0.0).m_7421_(1.0f, 0.0f).m_5752_();
        buffer.m_5483_((double)x, (double)y, 0.0).m_7421_(0.0f, 0.0f).m_5752_();
        tesselator.m_85914_();
        RenderSystem.enableDepthTest();
        RenderSystem.disableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.defaultBlendFunc();
    }

    public static QuadConsumer<ResourceLocation, Long, Long, Integer> setClientTimeStopEffect() {
        return (level, tick, time, id) -> {
            TIME_STOP_EFFECT_TICK.put((ResourceLocation)level, (Map.Entry<Long, Long>)new MutablePair(tick, time));
            TIME_STOPER.put((ResourceLocation)level, (Integer)id);
            ShaderHandler.time = (int)(TimeContext.Client.currentSeconds() * 20.0f);
        };
    }
}

