/*
 * Decompiled with CFR 0.152.
 */
package net.mrqx.huajiage.client.layer;

import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderHandEvent;
import net.mrqx.huajiage.capability.stand.IStandData;
import net.mrqx.huajiage.capability.stand.StandDataCapabilityProvider;
import net.mrqx.huajiage.client.model.stand.ModelStandBase;
import net.mrqx.huajiage.registy.HuaJiStands;
import net.mrqx.huajiage.stand.Stand;

@OnlyIn(value=Dist.CLIENT)
public class LayerStand
extends RenderLayer<LivingEntity, EntityModel<LivingEntity>> {
    public static final Map<String, LayerStand> PLAYER_LAYERS_MAP = new HashMap<String, LayerStand>();
    public final Map<ModelLayerLocation, ModelStandBase> modelMap;

    public LayerStand(RenderLayerParent<LivingEntity, EntityModel<LivingEntity>> pRenderer, EntityModelSet pModelSet) {
        super(pRenderer);
        HashMap map = new HashMap();
        HuaJiStands.REGISTRY.get().forEach(stand -> stand.getStandResource().getModelFunction().forEach((modelLayerLocation, modelSupplier) -> map.put(modelLayerLocation, (ModelStandBase)((Object)((Object)((Object)modelSupplier.apply(pModelSet.m_171103_(modelLayerLocation))))))));
        this.modelMap = ImmutableMap.copyOf(map);
    }

    public void render(PoseStack pPoseStack, MultiBufferSource pBuffer, int pPackedLight, LivingEntity pLivingEntity, float pLimbSwing, float pLimbSwingAmount, float pPartialTick, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
        if (Minecraft.m_91087_().f_91074_ != null) {
            Minecraft.m_91087_().f_91074_.getCapability(StandDataCapabilityProvider.STAND_DATA).ifPresent(playerData -> {
                if (Stand.getStand(playerData.getStand()) != null) {
                    pLivingEntity.getCapability(StandDataCapabilityProvider.STAND_DATA).ifPresent(data -> {
                        Stand stand = Stand.getStand(data.getStand());
                        if (stand != null && data.isTriggered()) {
                            VertexConsumer vertexconsumer = pBuffer.m_6299_(RenderType.m_110470_((ResourceLocation)stand.getStandResource().getModelTextures().get(data.getState())));
                            ModelStandBase model = this.modelMap.get(stand.getStandResource().getModelLocations().get(data.getState()));
                            List<Double> translations = stand.getStandResource().getModelTranslations().get(data.getState());
                            pPoseStack.m_85836_();
                            RenderSystem.enableBlend();
                            pPoseStack.m_85837_(translations.get(0).doubleValue(), translations.get(1).doubleValue(), translations.get(2).doubleValue());
                            model.m_6973_((Entity)pLivingEntity, pLimbSwing, pLimbSwingAmount, pAgeInTicks, pNetHeadYaw, pHeadPitch);
                            model.m_7695_(pPoseStack, vertexconsumer, 0xF000F0, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
                            if (stand.shouldRenderExtra(pLivingEntity, (IStandData)data)) {
                                model.renderExtra(pPoseStack, pBuffer, pPackedLight, pLivingEntity, pLimbSwing, pLimbSwingAmount, pPartialTick, pAgeInTicks, pNetHeadYaw, pHeadPitch, (IStandData)data, stand);
                            }
                            RenderSystem.disableBlend();
                            pPoseStack.m_85849_();
                        }
                    });
                }
            });
        }
    }

    public void renderHand(RenderHandEvent event, LocalPlayer player) {
        player.getCapability(StandDataCapabilityProvider.STAND_DATA).ifPresent(data -> {
            Stand stand = Stand.getStand(data.getStand());
            if (stand != null && data.isTriggered()) {
                PoseStack poseStack = event.getPoseStack();
                ModelStandBase model = this.modelMap.get(stand.getStandResource().getModelLocations().get(data.getState()));
                poseStack.m_85836_();
                RenderSystem.enableBlend();
                poseStack.m_85837_(0.0, 0.8, 0.3);
                model.renderHand(event, player, stand, (IStandData)data);
                RenderSystem.disableBlend();
                poseStack.m_85849_();
                if (!stand.shouldRenderHand((LivingEntity)player, (IStandData)data)) {
                    event.setCanceled(true);
                }
            }
        });
    }
}

