/*
 * Decompiled with CFR 0.152.
 */
package net.mrqx.huajiage.entity;

import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Fireball;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.network.PlayMessages;
import net.mrqx.huajiage.HuaJiAgeMod;
import net.mrqx.huajiage.entity.ExplosionHuaJi;
import net.mrqx.huajiage.utils.HuaJiDamageSources;

public class EntityItemBullet
extends Fireball {
    private static final EntityDataAccessor<Float> DAMAGE = SynchedEntityData.m_135353_(EntityItemBullet.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Boolean> HUGE = SynchedEntityData.m_135353_(EntityItemBullet.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Long> DELAY = SynchedEntityData.m_135353_(EntityItemBullet.class, (EntityDataSerializer)EntityDataSerializers.f_244073_);
    public final long randomSeed;
    public final Consumer<EntityItemBullet> onShoot;
    private boolean hasExploded = false;

    public EntityItemBullet(EntityType<? extends Fireball> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.randomSeed = pLevel.f_46441_.m_188505_();
        this.onShoot = bullet -> {};
    }

    public EntityItemBullet(LivingEntity pShooter, double pOffsetX, double pOffsetY, double pOffsetZ, Level pLevel) {
        super(HuaJiAgeMod.RegistryEvents.itemBulletEntityType, pShooter, pOffsetX, pOffsetY, pOffsetZ, pLevel);
        this.randomSeed = pLevel.f_46441_.m_188505_();
        this.onShoot = bullet -> {};
    }

    public EntityItemBullet(LivingEntity pShooter, double pOffsetX, double pOffsetY, double pOffsetZ, Level pLevel, Consumer<EntityItemBullet> onShoot) {
        super(HuaJiAgeMod.RegistryEvents.itemBulletEntityType, pShooter, pOffsetX, pOffsetY, pOffsetZ, pLevel);
        this.randomSeed = pLevel.f_46441_.m_188505_();
        this.onShoot = onShoot;
    }

    public static EntityItemBullet createInstance(PlayMessages.SpawnEntity packet, Level worldIn) {
        return new EntityItemBullet(HuaJiAgeMod.RegistryEvents.itemBulletEntityType, worldIn);
    }

    public static EntityItemBullet create(EntityType<? extends Fireball> pEntityType, Level pLevel) {
        return new EntityItemBullet(pEntityType, pLevel);
    }

    @Nullable
    public ItemStack getPickedResult(HitResult target) {
        return Items.f_41852_.m_7968_();
    }

    public boolean m_6087_() {
        return false;
    }

    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128350_("damage", this.getDamage());
        pCompound.m_128379_("huge", this.isSplashHuge());
        pCompound.m_128356_("delay", this.getDelay());
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DAMAGE, (Object)Float.valueOf(5.0f));
        this.f_19804_.m_135372_(HUGE, (Object)false);
        this.f_19804_.m_135372_(DELAY, (Object)0L);
    }

    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.setDamage(pCompound.m_128457_("damage"));
        this.setSplashHuge(pCompound.m_128471_("huge"));
        this.setDelay(pCompound.m_128454_("delay"));
    }

    public boolean m_20068_() {
        return true;
    }

    protected boolean m_5931_() {
        return false;
    }

    protected float m_6884_() {
        return 1.0f;
    }

    public void m_8119_() {
        this.setDelay(this.getDelay() - 1L);
        double r1 = (this.m_9236_().f_46441_.m_188500_() - 0.5) * 0.2;
        double r2 = (this.m_9236_().f_46441_.m_188500_() - 0.5) * 0.2;
        double r3 = (this.m_9236_().f_46441_.m_188500_() - 0.5) * 0.2;
        if (r1 > 0.05) {
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_175830_, this.m_20185_() + r1, this.m_20188_() + r2, this.m_20189_() + r3, r1, r2, r3);
        }
        if (this.isSplashHuge()) {
            double r11 = (this.m_9236_().f_46441_.m_188500_() - 0.5) * 0.2;
            double r12 = (this.m_9236_().f_46441_.m_188500_() - 0.5) * 0.2;
            double r13 = (this.m_9236_().f_46441_.m_188500_() - 0.5) * 0.2;
            if (r11 > 0.05) {
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123748_, this.m_20185_() + r11, this.m_20188_() + r12, this.m_20189_() + r13, r11, r12, r13);
            }
        }
        if (this.getDelay() <= 0L) {
            if (this.getDelay() == 0L) {
                this.onShoot.accept(this);
            }
            super.m_8119_();
            if (this.getDelay() < -300L) {
                this.m_146870_();
            }
        }
    }

    protected ParticleOptions m_5967_() {
        return ParticleTypes.f_175830_;
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        return false;
    }

    protected void m_8060_(BlockHitResult pResult) {
        super.m_8060_(pResult);
        if (!this.hasExploded) {
            this.explode();
            this.setDelay(-300L);
        }
    }

    protected void m_5790_(EntityHitResult pResult) {
        super.m_5790_(pResult);
        if (!(pResult.m_82443_() instanceof EntityItemBullet || pResult.m_82443_().equals((Object)this.m_19749_()) || this.hasExploded)) {
            this.explode();
            this.setDelay(-300L);
        }
    }

    protected void explode() {
        this.hasExploded = true;
        ExplosionHuaJi explosion = new ExplosionHuaJi(this.m_9236_(), this.m_19749_(), HuaJiDamageSources.emeraldSplash(this.m_9236_(), (Entity)this, this.m_19749_(), this.m_20182_()), null, this.m_20185_(), this.m_20186_(), this.m_20189_(), 1.9f, Explosion.BlockInteraction.KEEP, this.getDamage(), 0.0, false);
        explosion.m_46061_();
        explosion.m_46075_(true);
    }

    public float getDamage() {
        return ((Float)this.f_19804_.m_135370_(DAMAGE)).floatValue();
    }

    public void setDamage(float damage) {
        this.f_19804_.m_135381_(DAMAGE, (Object)Float.valueOf(damage));
    }

    public boolean isSplashHuge() {
        return (Boolean)this.f_19804_.m_135370_(HUGE);
    }

    public void setSplashHuge(boolean isHuge) {
        this.f_19804_.m_135381_(HUGE, (Object)isHuge);
    }

    public long getDelay() {
        return (Long)this.f_19804_.m_135370_(DELAY);
    }

    public void setDelay(long delay) {
        this.f_19804_.m_135381_(DELAY, (Object)delay);
    }
}

