/*
 * Decompiled with CFR 0.152.
 */
package net.mrqx.huajiage.entity;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.MoveTowardsRestrictionGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.PlayMessages;
import net.mrqx.huajiage.HuaJiAgeMod;
import net.mrqx.huajiage.entity.ExplosionHuaJi;
import net.mrqx.huajiage.registy.HuaJiSoundEvents;
import net.mrqx.huajiage.utils.HuaJiMathHelper;
import net.mrqx.huajiage.utils.HuaJiSoundPlayer;
import org.jetbrains.annotations.Nullable;

public class EntitySheerHeartAttack
extends TamableAnimal {
    private static final EntityDataAccessor<Boolean> TRIGGER = SynchedEntityData.m_135353_(EntitySheerHeartAttack.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Long> LIFE = SynchedEntityData.m_135353_(EntitySheerHeartAttack.class, (EntityDataSerializer)EntityDataSerializers.f_244073_);

    public EntitySheerHeartAttack(EntityType<? extends TamableAnimal> entityType, Level level) {
        super(entityType, level);
    }

    public EntitySheerHeartAttack(Level level) {
        super(HuaJiAgeMod.RegistryEvents.sheerHeartAttackEntityType, level);
    }

    public static EntitySheerHeartAttack createInstance(PlayMessages.SpawnEntity packet, Level worldIn) {
        return new EntitySheerHeartAttack(HuaJiAgeMod.RegistryEvents.sheerHeartAttackEntityType, worldIn);
    }

    public static EntitySheerHeartAttack create(EntityType<? extends TamableAnimal> pEntityType, Level pLevel) {
        return new EntitySheerHeartAttack(pEntityType, pLevel);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 1.0).m_22268_(Attributes.f_22279_, 0.6).m_22268_(Attributes.f_22281_, 15.0);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, 0.5, false));
        this.f_21345_.m_25352_(4, (Goal)new FollowOwnerGoal((TamableAnimal)this, 1.0, 20.0f, 5.0f, false));
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.4));
        this.f_21345_.m_25352_(5, (Goal)new MoveTowardsRestrictionGoal((PathfinderMob)this, 0.4));
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 10.0f));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new OwnerHurtTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(2, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Mob.class, true));
        this.f_21346_.m_25352_(4, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
    }

    public boolean m_7757_(LivingEntity target, LivingEntity owner) {
        OwnableEntity ownable;
        return (!(target instanceof OwnableEntity) || !owner.equals((Object)(ownable = (OwnableEntity)target).m_269323_())) && super.m_7757_(target, owner);
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        if (player.equals((Object)this.m_269323_())) {
            player.m_5634_(player.m_21233_() / 2.0f);
            HuaJiSoundPlayer.playMovingSoundToClient((Entity)player, SoundEvents.f_11673_);
            player.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 300, 1));
            this.m_146870_();
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, hand);
    }

    public void m_8119_() {
        this.setLife(this.getLife() - 1L);
        super.m_8119_();
        LivingEntity target = this.m_5448_();
        if (target != null && HuaJiMathHelper.getDistance(this.m_20182_(), target.m_20182_()) < 8.0) {
            if (!this.isTriggered()) {
                HuaJiSoundPlayer.playMovingSoundToClient((Entity)this, (SoundEvent)HuaJiSoundEvents.STAND_KILLER_QUEEN_TRIGGER.get(), 2.0f);
                this.setTrigger(true);
            }
            if (this.f_19797_ % 20 == 0) {
                Vec3 vec = HuaJiMathHelper.getVectorEntityEye((Entity)this, (Entity)target);
                this.m_20256_(vec.m_82490_(0.8));
            }
        } else {
            this.setTrigger(false);
        }
        if (this.getLife() < 0L) {
            this.explode();
            this.m_146870_();
        }
    }

    public boolean m_7327_(Entity entity) {
        boolean hurtTarget = super.m_7327_(entity);
        if (hurtTarget) {
            this.explode();
        }
        return hurtTarget;
    }

    protected void explode() {
        ExplosionHuaJi explosion = new ExplosionHuaJi(this.m_9236_(), (Entity)this.m_269323_(), this.m_9236_().m_269111_().m_269036_((Entity)this.m_269323_(), (Entity)this), null, this.m_20185_(), this.m_20186_(), this.m_20189_(), 5.0f, Explosion.BlockInteraction.KEEP, this.m_21133_(Attributes.f_22281_), 0.0, true);
        explosion.m_46061_();
        explosion.m_46075_(true);
    }

    public boolean m_6469_(DamageSource source, float amount) {
        return false;
    }

    protected void m_6475_(DamageSource damageSource, float damageAmount) {
    }

    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128379_("trigger", this.isTriggered());
        pCompound.m_128356_("life", this.getLife());
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(TRIGGER, (Object)false);
        this.f_19804_.m_135372_(LIFE, (Object)400L);
    }

    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.setTrigger(pCompound.m_128471_("trigger"));
        this.setLife(pCompound.m_128454_("life"));
    }

    public boolean isTriggered() {
        return (Boolean)this.f_19804_.m_135370_(TRIGGER);
    }

    public void setTrigger(boolean isHuge) {
        this.f_19804_.m_135381_(TRIGGER, (Object)isHuge);
    }

    public long getLife() {
        return (Long)this.f_19804_.m_135370_(LIFE);
    }

    public void setLife(long delay) {
        this.f_19804_.m_135381_(LIFE, (Object)delay);
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel level, AgeableMob otherParent) {
        return null;
    }
}

