/*
 * Decompiled with CFR 0.152.
 */
package net.mrqx.huajiage.network;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.mrqx.huajiage.client.event.ShaderHandler;
import net.mrqx.huajiage.utils.QuadConsumer;

public class TimeStopEffectMessage {
    public ResourceLocation level = Level.f_46428_.m_135782_();
    public long effectStartTick;
    public long effectDuration;
    public int entityId;

    public static TimeStopEffectMessage decode(FriendlyByteBuf buf) {
        TimeStopEffectMessage timeStopEffectMessage = new TimeStopEffectMessage();
        timeStopEffectMessage.level = buf.m_130281_();
        timeStopEffectMessage.effectStartTick = buf.readLong();
        timeStopEffectMessage.effectDuration = buf.readLong();
        timeStopEffectMessage.entityId = buf.readInt();
        return timeStopEffectMessage;
    }

    public static void encode(TimeStopEffectMessage msg, FriendlyByteBuf buf) {
        buf.m_130085_(msg.level);
        buf.writeLong(msg.effectStartTick);
        buf.writeLong(msg.effectDuration);
        buf.writeInt(msg.entityId);
    }

    public static void handle(TimeStopEffectMessage timeStopEffectMessage, Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection() != NetworkDirection.PLAY_TO_CLIENT) {
            return;
        }
        QuadConsumer handler = (QuadConsumer)DistExecutor.safeCallWhenOn((Dist)Dist.CLIENT, () -> ShaderHandler::setClientTimeStopEffect);
        if (handler != null) {
            ctx.get().enqueueWork(() -> handler.accept(timeStopEffectMessage.level, timeStopEffectMessage.effectStartTick, timeStopEffectMessage.effectDuration, timeStopEffectMessage.entityId));
        }
        ctx.get().setPacketHandled(true);
    }
}

