/*
 * Decompiled with CFR 0.152.
 */
package net.mrqx.huajiage.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import net.minecraft.core.Holder;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraftforge.registries.ForgeRegistries;
import net.mrqx.huajiage.recipe.HuaJiBlenderRecipe;

public class HuaJiBlenderRecipeSerializer
implements RecipeSerializer<HuaJiBlenderRecipe> {
    private final int defaultProcessTime;
    private final CookieBaker<HuaJiBlenderRecipe> factory;

    public HuaJiBlenderRecipeSerializer(CookieBaker<HuaJiBlenderRecipe> pFactory, int pDefaultProcessTime) {
        this.factory = pFactory;
        this.defaultProcessTime = pDefaultProcessTime;
    }

    public HuaJiBlenderRecipeSerializer() {
        this(HuaJiBlenderRecipe::new, 100);
    }

    public HuaJiBlenderRecipe fromJson(ResourceLocation pRecipeId, JsonObject pJson) {
        ItemStack itemstack;
        String s = GsonHelper.m_13851_((JsonObject)pJson, (String)"group", (String)"");
        JsonArray jsonelement = GsonHelper.m_13885_((JsonObject)pJson, (String)"ingredient") ? GsonHelper.m_13933_((JsonObject)pJson, (String)"ingredient") : GsonHelper.m_13930_((JsonObject)pJson, (String)"ingredient");
        Ingredient ingredient = Ingredient.m_288218_((JsonElement)jsonelement, (boolean)false);
        if (!pJson.has("result")) {
            throw new JsonSyntaxException("Missing result, expected to find a string or object");
        }
        if (pJson.get("result").isJsonObject()) {
            itemstack = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)pJson, (String)"result"));
        } else {
            String s1 = GsonHelper.m_13906_((JsonObject)pJson, (String)"result");
            ResourceLocation resourcelocation = new ResourceLocation(s1);
            itemstack = new ItemStack((Holder)ForgeRegistries.ITEMS.getDelegate(resourcelocation).orElseThrow(() -> new IllegalStateException("Item: " + s1 + " does not exist")));
        }
        float f = GsonHelper.m_13820_((JsonObject)pJson, (String)"experience", (float)0.0f);
        int i = GsonHelper.m_13824_((JsonObject)pJson, (String)"processTime", (int)this.defaultProcessTime);
        return this.factory.create(pRecipeId, s, ingredient, itemstack, f, i);
    }

    public HuaJiBlenderRecipe fromNetwork(ResourceLocation pRecipeId, FriendlyByteBuf pBuffer) {
        String s = pBuffer.m_130277_();
        Ingredient ingredient = Ingredient.m_43940_((FriendlyByteBuf)pBuffer);
        ItemStack itemstack = pBuffer.m_130267_();
        float f = pBuffer.readFloat();
        int i = pBuffer.m_130242_();
        return this.factory.create(pRecipeId, s, ingredient, itemstack, f, i);
    }

    public void toNetwork(FriendlyByteBuf pBuffer, HuaJiBlenderRecipe pRecipe) {
        pBuffer.m_130070_(pRecipe.group());
        pRecipe.ingredient().m_43923_(pBuffer);
        pBuffer.m_130055_(pRecipe.result());
        pBuffer.writeFloat(pRecipe.experience());
        pBuffer.m_130130_(pRecipe.processTime());
    }

    public static interface CookieBaker<T extends HuaJiBlenderRecipe> {
        public T create(ResourceLocation var1, String var2, Ingredient var3, ItemStack var4, float var5, int var6);
    }
}

