/*
 * Decompiled with CFR 0.152.
 */
package net.mrqx.huajiage.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.mrqx.huajiage.recipe.HuaJiPolyfurnaceRecipeSerializer;
import net.mrqx.huajiage.registy.HuaJiItems;
import net.mrqx.huajiage.registy.HuaJiRecipes;

public class HuaJiPolyfurnaceRecipeBuilder
implements RecipeBuilder {
    private final Ingredient ingredient;
    private final float experience;
    private final int processTime;
    private final int point;
    @Nullable
    private String group;
    private final List<ICondition> recipeConditions;
    private final HuaJiPolyfurnaceRecipeSerializer serializer;

    public HuaJiPolyfurnaceRecipeBuilder(Ingredient ingredient, float experience, int processTime, int point) {
        this.ingredient = ingredient;
        this.experience = experience;
        this.processTime = processTime;
        this.point = point;
        this.recipeConditions = new ArrayList<ICondition>();
        this.serializer = (HuaJiPolyfurnaceRecipeSerializer)HuaJiRecipes.HUAJI_POLYFURNACE_RECIPE_SERIALIZER.get();
    }

    public static HuaJiPolyfurnaceRecipeBuilder create(Ingredient ingredient, float experience, int processTime, int point) {
        return new HuaJiPolyfurnaceRecipeBuilder(ingredient, experience, processTime, point);
    }

    public HuaJiPolyfurnaceRecipeBuilder unlockedBy(String pCriterionName, CriterionTriggerInstance pCriterionTrigger) {
        return this;
    }

    public HuaJiPolyfurnaceRecipeBuilder group(@Nullable String pGroupName) {
        this.group = pGroupName;
        return this;
    }

    public Item m_142372_() {
        return (Item)HuaJiItems.INFINITE_UNIVERSE_STAR.get();
    }

    public void m_176498_(Consumer<FinishedRecipe> pFinishedRecipeConsumer) {
        this.m_126140_(pFinishedRecipeConsumer, HuaJiPolyfurnaceRecipeBuilder.getDefaultRecipeId((ItemLike)this.ingredient.m_43908_()[0].m_41720_()));
    }

    public void m_126140_(Consumer<FinishedRecipe> pFinishedRecipeConsumer, ResourceLocation pRecipeId) {
        pFinishedRecipeConsumer.accept(new Result(pRecipeId, this.group == null ? "" : this.group, this.ingredient, this.experience, this.processTime, this.point, this.recipeConditions, this.serializer));
    }

    protected static ResourceLocation getDefaultRecipeId(ItemLike pItemLike) {
        return BuiltInRegistries.f_257033_.m_7981_((Object)pItemLike.m_5456_()).m_246208_("huaji_polyfurnace/");
    }

    record Result(ResourceLocation id, String group, Ingredient ingredient, float experience, int processTime, int point, List<ICondition> recipeConditions, HuaJiPolyfurnaceRecipeSerializer serializer) implements FinishedRecipe
    {
        public void m_7917_(JsonObject pJson) {
            if (!this.group.isEmpty()) {
                pJson.addProperty("group", this.group);
            }
            pJson.add("ingredient", this.ingredient.m_43942_());
            pJson.addProperty("experience", (Number)Float.valueOf(this.experience));
            pJson.addProperty("processTime", (Number)this.processTime);
            pJson.addProperty("point", (Number)this.point);
            if (this.recipeConditions.isEmpty()) {
                return;
            }
            JsonArray conditions = new JsonArray();
            this.recipeConditions.forEach(c -> conditions.add((JsonElement)CraftingHelper.serialize((ICondition)c)));
            pJson.add("conditions", (JsonElement)conditions);
        }

        public RecipeSerializer<?> m_6637_() {
            return this.serializer;
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        @Nullable
        public JsonObject m_5860_() {
            return null;
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return null;
        }
    }
}

