/*
 * Decompiled with CFR 0.152.
 */
package net.mrqx.huajiage.stand;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.mrqx.huajiage.HuaJiAgeMod;
import net.mrqx.huajiage.capability.stand.IStandData;
import net.mrqx.huajiage.capability.stand.StandDataCapabilityProvider;
import net.mrqx.huajiage.client.model.stand.ModelStandBase;
import net.mrqx.huajiage.config.HuaJiCommonConfig;
import net.mrqx.huajiage.registy.HuaJiEffects;
import net.mrqx.huajiage.registy.HuaJiStands;
import org.jetbrains.annotations.Nullable;

public abstract class Stand {
    public static final ResourceKey<Registry<Stand>> REGISTRY_KEY = ResourceKey.m_135788_((ResourceLocation)HuaJiAgeMod.prefix("stands"));
    public static final String STATE_DEFAULT = "huajiage.default";
    public static final String STATE_IDLE = "huajiage.idle";
    public static final String STATE_FLY = "huajiage.fly";
    public static final String STATE_PUNCH = "huajiage.punch";
    protected final BiConsumer<LivingEntity, IStandData> tick;
    protected final BiConsumer<LivingEntity, IStandData> doSkill;
    @Nullable
    private String descriptionId;

    protected Stand(BiConsumer<LivingEntity, IStandData> tick, BiConsumer<LivingEntity, IStandData> doSkill) {
        this.tick = tick;
        this.doSkill = doSkill;
    }

    public Component getDescription() {
        return Component.m_237115_((String)this.getDescriptionId());
    }

    public String toString() {
        return Objects.requireNonNull(HuaJiStands.REGISTRY.get().getKey((Object)this)).m_135815_();
    }

    protected String getOrCreateDescriptionId() {
        if (this.descriptionId == null) {
            this.descriptionId = Util.m_137492_((String)"stand", (ResourceLocation)HuaJiStands.REGISTRY.get().getKey((Object)this));
        }
        return this.descriptionId;
    }

    public String getDescriptionId() {
        return this.getOrCreateDescriptionId();
    }

    public void tick(LivingEntity livingEntity, IStandData data) {
        if (data.isTriggered()) {
            this.tick.accept(livingEntity, data);
            if (!livingEntity.m_21023_((MobEffect)HuaJiEffects.STAND_POWER.get())) {
                this.timeoutPenalty(livingEntity, data);
            }
        }
        data.setEnergy(Math.min(data.getEnergy() + (long)this.chargePerTick(livingEntity, data), data.getMaxEnergy()));
    }

    public boolean trySkill(LivingEntity livingEntity, IStandData data) {
        int energyDemand = this.skillEnergyDemand(livingEntity, data);
        if (energyDemand >= 0 && data.getEnergy() >= (long)energyDemand) {
            data.setEnergy(data.getEnergy() - (long)energyDemand);
            this.doSkill(livingEntity, data);
            return true;
        }
        if (energyDemand >= 0) {
            livingEntity.m_213846_((Component)Component.m_237115_((String)"message.huajiage.stand.trigger_failed").m_130940_(ChatFormatting.GRAY));
        }
        return false;
    }

    protected void doSkill(LivingEntity livingEntity, IStandData data) {
        this.doSkill.accept(livingEntity, data);
        livingEntity.m_213846_((Component)Component.m_237115_((String)(this.getDescriptionId() + ".skill")));
    }

    protected void timeoutPenalty(LivingEntity livingEntity, IStandData data) {
        if (!livingEntity.m_9236_().f_46443_) {
            livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19612_, 20, 24, false, false));
        }
    }

    public int skillEnergyDemand(LivingEntity livingEntity, IStandData data) {
        return -1;
    }

    public int chargePerTick(LivingEntity livingEntity, IStandData data) {
        return 0;
    }

    public void onTriggered(LivingEntity livingEntity, IStandData data) {
        data.setState(STATE_DEFAULT);
        livingEntity.m_213846_((Component)Component.m_237115_((String)(this.getDescriptionId() + ".triggered")));
        float cost = (float)data.getEnergy() / (float)((Integer)HuaJiCommonConfig.STAND_TRIGGER_COST.get()).intValue();
        if (cost > 1.0f) {
            cost = 1.0f;
        }
        data.setEnergy(data.getEnergy() - (long)(cost * (float)((Integer)HuaJiCommonConfig.STAND_TRIGGER_COST.get()).intValue()));
        livingEntity.m_7292_(new MobEffectInstance((MobEffect)HuaJiEffects.STAND_POWER.get(), (int)((float)this.getDuration(livingEntity, data) * cost), data.getLevel()));
    }

    public void onCancelTriggered(LivingEntity livingEntity, IStandData data) {
        MobEffectInstance mobEffectInstance = livingEntity.m_21124_((MobEffect)HuaJiEffects.STAND_POWER.get());
        if (mobEffectInstance != null) {
            data.setEnergy((long)((float)data.getEnergy() + (float)mobEffectInstance.m_19557_() / (float)this.getDuration(livingEntity, data) * (float)((Integer)HuaJiCommonConfig.STAND_TRIGGER_COST.get()).intValue()));
            livingEntity.m_21195_((MobEffect)HuaJiEffects.STAND_POWER.get());
        }
    }

    public int getMaxLevel() {
        return -1;
    }

    public abstract float getDamage(LivingEntity var1, IStandData var2);

    public abstract float getSpeed(LivingEntity var1, IStandData var2);

    public abstract int getDuration(LivingEntity var1, IStandData var2);

    public abstract float getDistance(LivingEntity var1, IStandData var2);

    public long getMaxEnergy(LivingEntity livingEntity, IStandData data) {
        return (long)this.chargePerTick(livingEntity, data) * 1200L;
    }

    public abstract List<String> getStates();

    @OnlyIn(value=Dist.CLIENT)
    public abstract AbstractStandResource getStandResource();

    public boolean shouldRenderHand(LivingEntity livingEntity, IStandData data) {
        return true;
    }

    public boolean shouldRenderExtra(LivingEntity livingEntity, IStandData data) {
        return false;
    }

    @Nullable
    public static Stand getStand(@Nullable ResourceLocation resourceLocation) {
        return resourceLocation == null ? null : (Stand)HuaJiStands.REGISTRY.get().getValue(resourceLocation);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static abstract class AbstractStandResource {
        @OnlyIn(value=Dist.CLIENT)
        public abstract Map<String, ModelLayerLocation> getModelLocations();

        @OnlyIn(value=Dist.CLIENT)
        public abstract Map<String, ResourceLocation> getModelTextures();

        @OnlyIn(value=Dist.CLIENT)
        public abstract Map<String, List<Double>> getModelTranslations();

        @OnlyIn(value=Dist.CLIENT)
        public abstract Map<ModelLayerLocation, Supplier<LayerDefinition>> getModels();

        @OnlyIn(value=Dist.CLIENT)
        public abstract Map<ModelLayerLocation, Function<ModelPart, ModelStandBase>> getModelFunction();

        @OnlyIn(value=Dist.CLIENT)
        public static BiConsumer<CompoundTag, Integer> setClientTag() {
            return (tag, id) -> {
                Entity entity;
                if (Minecraft.m_91087_().f_91073_ != null && (entity = Minecraft.m_91087_().f_91073_.m_6815_(id.intValue())) != null) {
                    entity.getCapability(StandDataCapabilityProvider.STAND_DATA).ifPresent(data -> IStandData.deserializeNBT(tag, data));
                }
            };
        }
    }
}

