/*
 * Decompiled with CFR 0.152.
 */
package net.mrqx.huajiage.stand;

import com.mega.endinglib.util.time.TimeStopUtils;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.boss.EnderDragonPart;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.mrqx.huajiage.HuaJiAgeMod;
import net.mrqx.huajiage.capability.stand.IStandData;
import net.mrqx.huajiage.capability.stand.StandDataCapabilityProvider;
import net.mrqx.huajiage.client.HuaJiLayers;
import net.mrqx.huajiage.client.model.stand.ModelOrgaRequiem;
import net.mrqx.huajiage.client.model.stand.ModelOrgaRequiemFly;
import net.mrqx.huajiage.client.model.stand.ModelStandBase;
import net.mrqx.huajiage.data.HuaJiDamageTypes;
import net.mrqx.huajiage.entity.EntityRoadRoller;
import net.mrqx.huajiage.event.HuaJiCanFlyEvent;
import net.mrqx.huajiage.registy.HuaJiEffects;
import net.mrqx.huajiage.registy.HuaJiItems;
import net.mrqx.huajiage.registy.HuaJiSoundEvents;
import net.mrqx.huajiage.stand.Stand;
import net.mrqx.huajiage.utils.HuaJiDamageSources;
import net.mrqx.huajiage.utils.HuaJiMathHelper;
import net.mrqx.huajiage.utils.HuaJiSoundPlayer;

@Mod.EventBusSubscriber
public class StandOrgaRequiem
extends Stand {
    public static final BiConsumer<LivingEntity, IStandData> ORGA_REQUIEM_TICK = (living, data) -> {
        Stand stand = Stand.getStand(data.getStand());
        if (stand != null && !living.m_9236_().f_46443_ && "huajiage.fly".equals(data.getState())) {
            living.m_9236_().m_45976_(Entity.class, living.m_20191_().m_82400_((double)(stand.getDistance((LivingEntity)living, (IStandData)data) / 25.0f))).forEach(entity -> {
                LivingEntity target;
                if (HuaJiMathHelper.getDegreeXZ(living.m_20154_(), HuaJiMathHelper.getVectorEntityEye((Entity)living, entity)) > 45.0) {
                    return;
                }
                Vec3 back = HuaJiMathHelper.getVectorEntityEye((Entity)living, entity);
                DamageSource damageSource = HuaJiDamageSources.simple((Entity)living, HuaJiDamageTypes.STAND_HIT);
                if (entity instanceof EnderDragonPart) {
                    EnderDragonPart enderDragonPart = (EnderDragonPart)entity;
                    enderDragonPart.f_31010_.m_31120_(enderDragonPart.f_31010_.f_31080_, damageSource, stand.getDamage((LivingEntity)living, (IStandData)data));
                } else if (entity instanceof LivingEntity && !(target = (LivingEntity)entity).equals(living)) {
                    boolean isTimeStopping;
                    boolean bl = isTimeStopping = TimeStopUtils.isTimeStop && TimeStopUtils.andSameDimension((Level)living.m_9236_());
                    if (living.m_9236_().m_46467_() % 4L == 0L || isTimeStopping) {
                        target.f_19802_ = 0;
                        target.m_6469_(damageSource, stand.getDamage((LivingEntity)living, (IStandData)data) / 2.0f);
                        target.f_19802_ = 0;
                        if (!isTimeStopping) {
                            living.m_9236_().m_46796_(2001, target.m_20183_().m_7918_(0, (int)(target.m_20299_((float)0.0f).f_82480_ - target.m_20182_().f_82480_), 0), Block.m_49956_((BlockState)Blocks.f_50080_.m_49966_()));
                        }
                        if (HuaJiMathHelper.getVectorEntityEye((Entity)living, (Entity)target).m_82553_() < (double)(stand.getDistance((LivingEntity)living, (IStandData)data) / 25.0f)) {
                            target.m_20256_(back);
                        }
                    }
                } else if (!(entity instanceof ItemEntity) && !(entity instanceof ExperienceOrb)) {
                    if (entity instanceof EntityRoadRoller) {
                        EntityRoadRoller roadRoller = (EntityRoadRoller)((Object)((Object)entity));
                        roadRoller.m_6469_(damageSource, stand.getDamage((LivingEntity)living, (IStandData)data) / 2.0f);
                    } else {
                        entity.m_20256_(back.m_82490_((double)(stand.getDamage((LivingEntity)living, (IStandData)data) / 10.0f)));
                    }
                }
            });
        }
    };
    public static final BiConsumer<LivingEntity, IStandData> ORGA_REQUIEM_DO_SKILL = (living, data) -> {
        Stand stand = Stand.getStand(data.getStand());
        if (living instanceof Player) {
            Player player = (Player)living;
            ItemStack itemStack = ((Item)HuaJiItems.ORGA_HAIR_KNIFE.get()).m_7968_();
            itemStack.m_41764_(16);
            player.m_36356_(itemStack);
            if (player.m_9236_().f_46441_.m_188500_() < 0.3) {
                player.m_36356_(((Item)HuaJiItems.BLACK_CAR.get()).m_7968_());
            }
        }
        if (stand != null) {
            living.m_7292_(new MobEffectInstance((MobEffect)HuaJiEffects.REQUIEM.get(), stand.getDuration((LivingEntity)living, (IStandData)data), data.getLevel()));
            living.m_7292_(new MobEffectInstance((MobEffect)HuaJiEffects.STAND_POWER.get(), stand.getDuration((LivingEntity)living, (IStandData)data), data.getLevel()));
        }
    };

    public StandOrgaRequiem() {
        super(ORGA_REQUIEM_TICK, ORGA_REQUIEM_DO_SKILL);
    }

    @Override
    public void onTriggered(LivingEntity livingEntity, IStandData data) {
        super.onTriggered(livingEntity, data);
        HuaJiSoundPlayer.playMovingSoundToClient((Entity)livingEntity, livingEntity.m_9236_().m_213780_().m_188499_() ? (SoundEvent)HuaJiSoundEvents.ORGA_REQUIEM_2.get() : (SoundEvent)HuaJiSoundEvents.ORGA_REQUIEM_3.get());
    }

    @Override
    public int skillEnergyDemand(LivingEntity livingEntity, IStandData data) {
        return 80000;
    }

    @Override
    public int getMaxLevel() {
        return 0;
    }

    @Override
    public float getDamage(LivingEntity livingEntity, IStandData data) {
        return livingEntity.m_21233_() / 2.0f;
    }

    @Override
    public float getSpeed(LivingEntity livingEntity, IStandData data) {
        return (float)(livingEntity.m_21133_(Attributes.f_22279_) / 2.5);
    }

    @Override
    public int getDuration(LivingEntity livingEntity, IStandData data) {
        return 650;
    }

    @Override
    public float getDistance(LivingEntity livingEntity, IStandData data) {
        return 50.0f;
    }

    @Override
    public int chargePerTick(LivingEntity livingEntity, IStandData data) {
        return data.isTriggered() && data.getState().equals("huajiage.default") ? 90 : 70;
    }

    @Override
    public List<String> getStates() {
        return List.of("huajiage.default", "huajiage.fly");
    }

    @SubscribeEvent
    public static void onHuaJiCanFlyEvent(HuaJiCanFlyEvent event) {
        event.getEntity().getCapability(StandDataCapabilityProvider.STAND_DATA).ifPresent(data -> {
            if (Stand.getStand(data.getStand()) instanceof StandOrgaRequiem && data.isTriggered() && data.getState().equals("huajiage.fly")) {
                event.setCanFly(true);
            }
        });
    }

    @Override
    public boolean shouldRenderHand(LivingEntity livingEntity, IStandData data) {
        return !data.isTriggered() || !data.getState().equals("huajiage.fly");
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Stand.AbstractStandResource getStandResource() {
        return StandResource.INSTANCE;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class StandResource
    extends Stand.AbstractStandResource {
        @OnlyIn(value=Dist.CLIENT)
        public static final StandResource INSTANCE = new StandResource();
        @OnlyIn(value=Dist.CLIENT)
        public static final ModelLayerLocation DEFAULT_LAYER = HuaJiLayers.create("orga_requiem", "huajiage.default");
        @OnlyIn(value=Dist.CLIENT)
        public static final ModelLayerLocation FLY_LAYER = HuaJiLayers.create("orga_requiem", "huajiage.fly");
        @OnlyIn(value=Dist.CLIENT)
        public static final Map<String, ModelLayerLocation> MODEL_LAYER_MAP = Map.of("huajiage.default", DEFAULT_LAYER, "huajiage.fly", FLY_LAYER);
        @OnlyIn(value=Dist.CLIENT)
        public static final Map<String, ResourceLocation> TEXTURE_MAP = Map.of("huajiage.default", HuaJiAgeMod.prefix("textures/entity/stand/orga_requiem_default.png"), "huajiage.fly", HuaJiAgeMod.prefix("textures/entity/stand/orga_requiem_fly.png"));
        @OnlyIn(value=Dist.CLIENT)
        public static final Map<String, List<Double>> TRANSLATION_MAP = Map.of("huajiage.default", List.of(Double.valueOf(-0.5), Double.valueOf(-0.7), Double.valueOf(0.75)), "huajiage.fly", List.of(Double.valueOf(0.0), Double.valueOf(-0.9), Double.valueOf(0.0)));
        @OnlyIn(value=Dist.CLIENT)
        public static final Map<ModelLayerLocation, Supplier<LayerDefinition>> MODEL_MAP = Map.of(DEFAULT_LAYER, ModelOrgaRequiem::createBodyLayer, FLY_LAYER, ModelOrgaRequiemFly::createBodyLayer);
        @OnlyIn(value=Dist.CLIENT)
        public static final Map<ModelLayerLocation, Function<ModelPart, ModelStandBase>> MODEL_FUNCTION_MAP = Map.of(DEFAULT_LAYER, ModelOrgaRequiem::new, FLY_LAYER, ModelOrgaRequiemFly::new);

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public Map<String, ModelLayerLocation> getModelLocations() {
            return MODEL_LAYER_MAP;
        }

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public Map<String, ResourceLocation> getModelTextures() {
            return TEXTURE_MAP;
        }

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public Map<String, List<Double>> getModelTranslations() {
            return TRANSLATION_MAP;
        }

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public Map<ModelLayerLocation, Supplier<LayerDefinition>> getModels() {
            return MODEL_MAP;
        }

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public Map<ModelLayerLocation, Function<ModelPart, ModelStandBase>> getModelFunction() {
            return MODEL_FUNCTION_MAP;
        }
    }
}

