/*
 * Decompiled with CFR 0.152.
 */
package net.mrqx.huajiage.utils;

import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.registries.ForgeRegistries;
import net.mrqx.huajiage.network.HuaJiSoundMessage;
import net.mrqx.huajiage.network.NetworkManager;
import net.mrqx.huajiage.sound.HuajiMovingSoundInstance;
import net.mrqx.huajiage.utils.PentaConsumer;
import org.jetbrains.annotations.Nullable;

public class HuaJiSoundPlayer {
    @Nullable
    private static SoundInstance currentMusic;

    @OnlyIn(value=Dist.CLIENT)
    public static void playMusic(SoundEvent sound) {
        if (Minecraft.m_91087_().f_91074_ != null) {
            currentMusic = SimpleSoundInstance.m_246411_((SoundEvent)sound, (Vec3)Minecraft.m_91087_().f_91074_.m_20182_());
            Minecraft.m_91087_().m_91106_().m_120367_(currentMusic);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void stopMusic(SoundEvent sound) {
        if (Minecraft.m_91087_().f_91074_ != null) {
            currentMusic = SimpleSoundInstance.m_246411_((SoundEvent)sound, (Vec3)Minecraft.m_91087_().f_91074_.m_20182_());
            Minecraft.m_91087_().m_91106_().m_120399_(currentMusic);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void playClient(SoundInstance sound) {
        Minecraft.m_91087_().m_91106_().m_120367_(sound);
    }

    public static void playMovingSoundToClient(Entity target, SoundEvent sound) {
        HuaJiSoundPlayer.playMovingSoundToClient(target, sound, target.m_5720_(), 1.0f, 1.0f);
    }

    public static void playMovingSoundToClient(Entity target, SoundEvent sound, float volume) {
        HuaJiSoundPlayer.playMovingSoundToClient(target, sound, target.m_5720_(), volume, 1.0f);
    }

    public static void playMovingSoundToClient(Entity target, SoundEvent sound, float volume, float pitch) {
        HuaJiSoundPlayer.playMovingSoundToClient(target, sound, target.m_5720_(), volume, pitch);
    }

    public static void playMovingSoundToClient(Entity target, SoundEvent sound, SoundSource category) {
        HuaJiSoundPlayer.playMovingSoundToClient(target, sound, category, 1.0f, 1.0f);
    }

    public static void playMovingSoundToClient(Entity target, SoundEvent sound, SoundSource category, float volume) {
        HuaJiSoundPlayer.playMovingSoundToClient(target, sound, category, volume, 1.0f);
    }

    public static void playMovingSoundToClient(Entity target, SoundEvent sound, SoundSource category, float volume, float pitch) {
        if (!target.m_9236_().f_46443_) {
            HuaJiSoundMessage message = new HuaJiSoundMessage();
            message.soundEvent = sound.m_11660_();
            message.source = category;
            message.entityId = target.m_19879_();
            message.volume = volume;
            message.pitch = pitch;
            target.m_9236_().m_6907_().forEach(player -> {
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    NetworkManager.INSTANCE.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)message);
                }
            });
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static PentaConsumer<ResourceLocation, SoundSource, Integer, Float, Float> playMovingSoundClient() {
        return (sound, category, target, volume, pitch) -> {
            if (!sound.equals((Object)SoundEvents.f_271165_.m_11660_())) {
                SoundEvent soundEvent;
                Entity entity;
                if (Minecraft.m_91087_().f_91073_ != null && (entity = Minecraft.m_91087_().f_91073_.m_6815_(target.intValue())) != null && (soundEvent = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(sound)) != null) {
                    HuaJiSoundPlayer.playClient((SoundInstance)HuaJiSoundPlayer.getMovingSound(entity, soundEvent, category, volume.floatValue(), pitch.floatValue()));
                }
            } else {
                Minecraft.m_91087_().m_91106_().m_120405_();
            }
        };
    }

    public static HuajiMovingSoundInstance getMovingSound(Entity entity, SoundEvent soundEvent, SoundSource category) {
        HuajiMovingSoundInstance soundInstance = new HuajiMovingSoundInstance(soundEvent, category, entity);
        soundInstance.m_7788_();
        return soundInstance;
    }

    public static HuajiMovingSoundInstance getMovingSound(Entity entity, SoundEvent soundEvent, SoundSource category, float volume) {
        return HuaJiSoundPlayer.getMovingSound(entity, soundEvent, category).setVolume(volume);
    }

    public static HuajiMovingSoundInstance getMovingSound(Entity entity, SoundEvent soundEvent, SoundSource category, float volume, float pitch) {
        return HuaJiSoundPlayer.getMovingSound(entity, soundEvent, category).setVolume(volume).setPitch(pitch);
    }
}

