/*
 * Decompiled with CFR 0.152.
 */
package us.timinc.mc.cobblemon.spawnchaining.influence;

import com.cobblemon.mod.common.api.pokemon.PokemonProperties;
import com.cobblemon.mod.common.api.reactive.Observable;
import com.cobblemon.mod.common.api.spawning.SpawnBucket;
import com.cobblemon.mod.common.api.spawning.context.SpawningContext;
import com.cobblemon.mod.common.api.spawning.context.calculators.SpawningContextCalculator;
import com.cobblemon.mod.common.api.spawning.detail.PokemonSpawnAction;
import com.cobblemon.mod.common.api.spawning.detail.SpawnAction;
import com.cobblemon.mod.common.api.spawning.detail.SpawnDetail;
import com.cobblemon.mod.common.api.spawning.influence.SpawningInfluence;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.FormData;
import com.cobblemon.mod.common.pokemon.Species;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import us.timinc.mc.cobblemon.counter.CounterMod;
import us.timinc.mc.cobblemon.counter.api.CounterManager;
import us.timinc.mc.cobblemon.counter.api.CounterType;
import us.timinc.mc.cobblemon.counter.api.CounterTypeRegistry;
import us.timinc.mc.cobblemon.counter.extension.PlayerExtensionKt;
import us.timinc.mc.cobblemon.spawnchaining.SpawnChaining;
import us.timinc.mc.cobblemon.spawnchaining.store.SpawnOverride;
import us.timinc.mc.cobblemon.timcore.Debugger;
import us.timinc.mc.cobblemon.timcore.LimitedList;
import us.timinc.mc.cobblemon.timcore.PokemonRepresentation;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\t\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001b\u0010\u000b\u001a\u00020\n2\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\bH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ5\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0005\u001a\u00020\u00042\u000e\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\r2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0015R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0016\u001a\u0004\b\u0017\u0010\u0018R\u0019\u0010\u0005\u001a\u0004\u0018\u00010\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0019\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006\u001c"}, d2={"Lus/timinc/mc/cobblemon/spawnchaining/influence/ReplacementInfluence;", "Lcom/cobblemon/mod/common/api/spawning/influence/SpawningInfluence;", "Lnet/minecraft/resources/ResourceLocation;", "context", "Lnet/minecraft/server/level/ServerPlayer;", "player", "<init>", "(Lnet/minecraft/resources/ResourceLocation;Lnet/minecraft/server/level/ServerPlayer;)V", "Lcom/cobblemon/mod/common/api/spawning/detail/SpawnAction;", "action", "", "affectAction", "(Lcom/cobblemon/mod/common/api/spawning/detail/SpawnAction;)V", "Lus/timinc/mc/cobblemon/timcore/Debugger$Case;", "Lus/timinc/mc/cobblemon/spawnchaining/SpawnChaining$SpawnChainingConfig;", "debugger", "Lus/timinc/mc/cobblemon/timcore/PokemonRepresentation;", "Lcom/cobblemon/mod/common/api/pokemon/PokemonProperties;", "pokemonRep", "", "getOverrideChance", "(Lnet/minecraft/server/level/ServerPlayer;Lus/timinc/mc/cobblemon/timcore/Debugger$Case;Lus/timinc/mc/cobblemon/timcore/PokemonRepresentation;)F", "Lnet/minecraft/resources/ResourceLocation;", "getContext", "()Lnet/minecraft/resources/ResourceLocation;", "Lnet/minecraft/server/level/ServerPlayer;", "getPlayer", "()Lnet/minecraft/server/level/ServerPlayer;", "common"})
@SourceDebugExtension(value={"SMAP\nReplacementInfluence.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReplacementInfluence.kt\nus/timinc/mc/cobblemon/spawnchaining/influence/ReplacementInfluence\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,105:1\n1#2:106\n*E\n"})
public final class ReplacementInfluence
implements SpawningInfluence {
    @NotNull
    private final ResourceLocation context;
    @Nullable
    private final ServerPlayer player;

    public ReplacementInfluence(@NotNull ResourceLocation context, @Nullable ServerPlayer player) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        this.player = player;
    }

    public /* synthetic */ ReplacementInfluence(ResourceLocation resourceLocation, ServerPlayer serverPlayer, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            serverPlayer = null;
        }
        this(resourceLocation, serverPlayer);
    }

    @NotNull
    public final ResourceLocation getContext() {
        return this.context;
    }

    @Nullable
    public final ServerPlayer getPlayer() {
        return this.player;
    }

    public void affectAction(@NotNull SpawnAction<?> action) {
        Entity entity;
        Intrinsics.checkNotNullParameter(action, (String)"action");
        if (!(action instanceof PokemonSpawnAction)) {
            return;
        }
        Debugger.Case debugger = Debugger.getCaseDebugger$default((Debugger)SpawnChaining.INSTANCE.getDebugger(), null, (int)1, null);
        PokemonRepresentation.FromProperties overriddenPokemonRep = new PokemonRepresentation.FromProperties(((PokemonSpawnAction)action).getProps());
        if (!LimitedList.PokemonMatcherList.INSTANCE.matchesList((Object)overriddenPokemonRep.getPokemon(), ((SpawnChaining.SpawnChainingConfig)SpawnChaining.INSTANCE.getConfig()).getOverrideWhitelist(), ((SpawnChaining.SpawnChainingConfig)SpawnChaining.INSTANCE.getConfig()).getOverrideBlacklist())) {
            Debugger.debug$default((Debugger)((Debugger)debugger), (String)"Invalid Pokemon to override, per the whitelist/blacklist.", (boolean)false, (int)2, null);
            return;
        }
        ServerPlayer serverPlayer = this.player;
        if (serverPlayer == null && (serverPlayer = (entity = action.getCtx().getCause().getEntity()) instanceof ServerPlayer ? (ServerPlayer)entity : null) == null) {
            return;
        }
        ServerPlayer player = serverPlayer;
        Debugger.debug$default((Debugger)((Debugger)debugger), (String)("Attempting a replacement influence for " + player.getName().getString() + " on the " + this.context + " context."), (boolean)false, (int)2, null);
        SpawnOverride.Entry override = SpawnOverride.INSTANCE.find(player, this.context);
        if (override == null) {
            Debugger.debug$default((Debugger)((Debugger)debugger), (String)"No override found.", (boolean)false, (int)2, null);
            return;
        }
        Debugger.debug$default((Debugger)((Debugger)debugger), (String)("Found an override of " + override.getProperties().getSpecies() + "|" + override.getProperties().getForm() + " with a level mod of " + override.getLevelMod() + "."), (boolean)false, (int)2, null);
        float overrideChance = this.getOverrideChance(player, (Debugger.Case<SpawnChaining.SpawnChainingConfig>)debugger, (PokemonRepresentation<PokemonProperties>)((PokemonRepresentation)new PokemonRepresentation.FromProperties(override.getProperties())));
        Debugger.debug$default((Debugger)((Debugger)debugger), (String)("Has a chance of " + overrideChance + "."), (boolean)false, (int)2, null);
        float overrideRoll = Random.Default.nextFloat();
        Debugger.debug$default((Debugger)((Debugger)debugger), (String)("Rolled a " + overrideRoll + "."), (boolean)false, (int)2, null);
        if (overrideRoll > overrideChance) {
            Debugger.debug$default((Debugger)((Debugger)debugger), (String)"Failed the roll.", (boolean)false, (int)2, null);
            return;
        }
        ((PokemonSpawnAction)action).setProps(override.getProperties());
        Debugger.debug$default((Debugger)((Debugger)debugger), (String)"Switched action's props to override's.", (boolean)false, (int)2, null);
        if (((SpawnChaining.SpawnChainingConfig)SpawnChaining.INSTANCE.getConfig()).getNotifyPlayer()) {
            player.sendSystemMessage((Component)SpawnChaining.TranslationComponents.INSTANCE.chained());
        }
        if (((SpawnChaining.SpawnChainingConfig)SpawnChaining.INSTANCE.getConfig()).getBreakOnSuccess()) {
            SpawnOverride.INSTANCE.remove(player);
            Debugger.debug$default((Debugger)((Debugger)debugger), (String)"Broke the spawn override.", (boolean)false, (int)2, null);
        }
        Observable.DefaultImpls.subscribe$default((Observable)((Observable)((PokemonSpawnAction)action).getEntity()), null, (Function1)((Function1)new Function1<PokemonEntity, Unit>(override, (Debugger.Case<SpawnChaining.SpawnChainingConfig>)debugger){
            final /* synthetic */ SpawnOverride.Entry $override;
            final /* synthetic */ Debugger.Case<SpawnChaining.SpawnChainingConfig> $debugger;
            {
                this.$override = $override;
                this.$debugger = $debugger;
                super(1);
            }

            public final void invoke(@NotNull PokemonEntity it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                SpawnChaining.CustomPokemonProperties.INSTANCE.getLEVEL_MOD().entityApplicator(it, (float)this.$override.getLevelMod());
                Debugger.debug$default((Debugger)((Debugger)this.$debugger), (String)"Saved the level mod onto the Pokemon.", (boolean)false, (int)2, null);
            }
        }), (int)1, null);
    }

    private final float getOverrideChance(ServerPlayer player, Debugger.Case<SpawnChaining.SpawnChainingConfig> debugger, PokemonRepresentation<PokemonProperties> pokemonRep) {
        CounterManager manager = PlayerExtensionKt.getCounterManager((ServerPlayer)player);
        float boost = 0.0f;
        for (Map.Entry<String, Map<String, Float>> entry : ((SpawnChaining.SpawnChainingConfig)SpawnChaining.INSTANCE.getConfig()).getPoints().entrySet()) {
            String counterTypeName = entry.getKey();
            Map<String, Float> scoreTypeList = entry.getValue();
            for (Map.Entry<String, Float> entry2 : scoreTypeList.entrySet()) {
                String scoreTypeName = entry2.getKey();
                float value = ((Number)entry2.getValue()).floatValue();
                try {
                    FormData form;
                    Species species;
                    CounterType counterType = CounterTypeRegistry.INSTANCE.findByType(counterTypeName);
                    Intrinsics.checkNotNull((Object)pokemonRep.getSpecies());
                    Intrinsics.checkNotNull((Object)pokemonRep.getForm());
                    int statScore = Intrinsics.areEqual((Object)scoreTypeName, (Object)CounterMod.ScoreTypes.INSTANCE.getSTREAK().getType()) ? manager.getStreakScore(counterType, species.getResourceIdentifier(), form.getName()) : manager.getCountScore(counterType, species.getResourceIdentifier(), form.getName());
                    boost += (float)statScore * value;
                }
                catch (Exception e) {
                    String it;
                    if (e.getMessage() == null) continue;
                    boolean bl = false;
                    Debugger.Case<SpawnChaining.SpawnChainingConfig> case_ = debugger;
                    if (case_ == null) continue;
                    Debugger.debug$default((Debugger)((Debugger)case_), (String)it, (boolean)false, (int)2, null);
                }
            }
        }
        return ((SpawnChaining.SpawnChainingConfig)SpawnChaining.INSTANCE.getConfig()).getInitialChance() + boost;
    }

    public float affectBucketWeight(@NotNull SpawnBucket bucket, float weight) {
        return SpawningInfluence.DefaultImpls.affectBucketWeight((SpawningInfluence)this, (SpawnBucket)bucket, (float)weight);
    }

    public void affectSpawn(@NotNull Entity entity) {
        SpawningInfluence.DefaultImpls.affectSpawn((SpawningInfluence)this, (Entity)entity);
    }

    public boolean affectSpawnable(@NotNull SpawnDetail detail, @NotNull SpawningContext ctx) {
        return SpawningInfluence.DefaultImpls.affectSpawnable((SpawningInfluence)this, (SpawnDetail)detail, (SpawningContext)ctx);
    }

    public float affectWeight(@NotNull SpawnDetail detail, @NotNull SpawningContext ctx, float weight) {
        return SpawningInfluence.DefaultImpls.affectWeight((SpawningInfluence)this, (SpawnDetail)detail, (SpawningContext)ctx, (float)weight);
    }

    public boolean isAllowedPosition(@NotNull ServerLevel world, @NotNull BlockPos pos, @NotNull SpawningContextCalculator<?, ?> contextCalculator) {
        return SpawningInfluence.DefaultImpls.isAllowedPosition((SpawningInfluence)this, (ServerLevel)world, (BlockPos)pos, contextCalculator);
    }

    public boolean isExpired() {
        return SpawningInfluence.DefaultImpls.isExpired((SpawningInfluence)this);
    }
}

