/*
 * Decompiled with CFR 0.152.
 */
package us.timinc.mc.cobblemon.spawnchaining.api;

import com.cobblemon.mod.common.api.pokemon.PokemonProperties;
import com.cobblemon.mod.common.pokemon.Pokemon;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import org.jetbrains.annotations.NotNull;
import us.timinc.mc.cobblemon.spawnchaining.SpawnChaining;
import us.timinc.mc.cobblemon.spawnchaining.extension.IntRangeExtensionsKt;
import us.timinc.mc.cobblemon.spawnchaining.store.SpawnOverride;
import us.timinc.mc.cobblemon.timcore.Debugger;
import us.timinc.mc.cobblemon.timcore.LimitedList;
import us.timinc.mc.cobblemon.timcore.PokemonExtensionsKt;
import us.timinc.mc.cobblemon.timcore.TimCore;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001J-\u0010\n\u001a\u00020\t2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00042\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016\u00a2\u0006\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lus/timinc/mc/cobblemon/spawnchaining/api/SpawnOverrideRecorder;", "", "Lnet/minecraft/server/level/ServerPlayer;", "player", "Lcom/cobblemon/mod/common/pokemon/Pokemon;", "pokemon", "Lus/timinc/mc/cobblemon/timcore/Debugger$Case;", "Lus/timinc/mc/cobblemon/spawnchaining/SpawnChaining$SpawnChainingConfig;", "debugger", "", "record", "(Lnet/minecraft/server/level/ServerPlayer;Lcom/cobblemon/mod/common/pokemon/Pokemon;Lus/timinc/mc/cobblemon/timcore/Debugger$Case;)Z", "common"})
public interface SpawnOverrideRecorder {
    public boolean record(@NotNull ServerPlayer var1, @NotNull Pokemon var2, @NotNull Debugger.Case<SpawnChaining.SpawnChainingConfig> var3);

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    @SourceDebugExtension(value={"SMAP\nSpawnOverrideRecorder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpawnOverrideRecorder.kt\nus/timinc/mc/cobblemon/spawnchaining/api/SpawnOverrideRecorder$DefaultImpls\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,61:1\n1#2:62\n*E\n"})
    public static final class DefaultImpls {
        public static boolean record(@NotNull SpawnOverrideRecorder $this, @NotNull ServerPlayer player, @NotNull Pokemon pokemon, @NotNull Debugger.Case<SpawnChaining.SpawnChainingConfig> debugger) {
            ResourceLocation spawnCause;
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            Intrinsics.checkNotNullParameter((Object)pokemon, (String)"pokemon");
            Intrinsics.checkNotNullParameter(debugger, (String)"debugger");
            if (!LimitedList.PokemonMatcherList.INSTANCE.matchesList((Object)pokemon, ((SpawnChaining.SpawnChainingConfig)SpawnChaining.INSTANCE.getConfig()).getChainingWhitelist(), ((SpawnChaining.SpawnChainingConfig)SpawnChaining.INSTANCE.getConfig()).getChainingBlacklist())) {
                Debugger.debug$default((Debugger)((Debugger)debugger), (String)(PokemonExtensionsKt.getIdentifier((Pokemon)pokemon) + " is prohibited by the blacklist/whitelist; not recording."), (boolean)false, (int)2, null);
                return false;
            }
            String string = PokemonExtensionsKt.getSpawnCause((Pokemon)pokemon);
            if (string != null) {
                String it = string;
                boolean bl = false;
                v1 = ResourceLocation.parse((String)it);
            } else {
                v1 = spawnCause = null;
            }
            if (spawnCause == null) {
                Debugger.debug$default((Debugger)((Debugger)debugger), (String)"No spawn cause recorded.", (boolean)false, (int)2, null);
                if (((SpawnChaining.SpawnChainingConfig)SpawnChaining.INSTANCE.getConfig()).getAssumePlayerSpawnered()) {
                    Debugger.debug$default((Debugger)((Debugger)debugger), (String)"Assuming player spawnered.", (boolean)false, (int)2, null);
                    spawnCause = TimCore.DataKeys.SpawnCauses.INSTANCE.getPLAYER_SPAWNER();
                } else {
                    Debugger.debug$default((Debugger)((Debugger)debugger), (String)"It hurt itself in its confusion (returning).", (boolean)false, (int)2, null);
                    return false;
                }
            }
            PokemonProperties props = new PokemonProperties();
            String string2 = pokemon.getSpecies().getName().toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
            String species = string2;
            props.setSpecies(species);
            Debugger.debug$default((Debugger)((Debugger)debugger), (String)("Set species to " + species + "."), (boolean)false, (int)2, null);
            String form = pokemon.getForm().getName();
            props.setForm(form);
            Debugger.debug$default((Debugger)((Debugger)debugger), (String)("Set form to " + form + "."), (boolean)false, (int)2, null);
            Float f = SpawnChaining.CustomPokemonProperties.INSTANCE.getLEVEL_MOD().getValue(pokemon);
            int previousLevelMod = f != null ? (int)f.floatValue() : 0;
            Debugger.debug$default((Debugger)((Debugger)debugger), (String)("Previous level mod was " + previousLevelMod + "."), (boolean)false, (int)2, null);
            int levelModRoll = RangesKt.random((IntRange)((SpawnChaining.SpawnChainingConfig)SpawnChaining.INSTANCE.getConfig()).getLevelModRange(), (Random)((Random)Random.Default));
            Debugger.debug$default((Debugger)((Debugger)debugger), (String)("Rolled a new level mod of " + levelModRoll + "."), (boolean)false, (int)2, null);
            int levelMod = IntRangeExtensionsKt.constrain(((SpawnChaining.SpawnChainingConfig)SpawnChaining.INSTANCE.getConfig()).getLevelModMaxRange(), levelModRoll + previousLevelMod);
            props.setLevel(Integer.valueOf(pokemon.getLevel() + levelMod - previousLevelMod));
            Debugger.debug$default((Debugger)((Debugger)debugger), (String)("Updated props level to " + props.getLevel() + "."), (boolean)false, (int)2, null);
            SpawnOverride.INSTANCE.record(player, props, spawnCause, levelMod);
            Debugger.debug$default((Debugger)((Debugger)debugger), (String)"Recorded props against player.", (boolean)false, (int)2, null);
            return true;
        }
    }
}

