package org.dfood.block;

import net.minecraft.block.*;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2498;
import net.minecraft.class_3619;
import net.minecraft.class_3620;
import net.minecraft.class_4970;
import org.dfood.sound.ModSoundGroups;
import org.dfood.util.IntPropertyManager;
import org.dfood.util.DFoodUtils;

import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;

/**
 * 关于原版的食物方块定义
 */
public class FoodBlocks {
    public static final Map<String, class_2248> FOOD_BLOCK_REGISTRY = new HashMap<>();

    // 零食
    public static final class_2248 COOKIE = createFoodBlock("cookie", 10,
            class_3620.field_16013, 0.2F, null);
    public static final class_2248 APPLE = createFoodBlock("apple", 5,
            class_3620.field_16020, 0.2F, null);
    public static final class_2248 MELON_SLICE = createFoodBlock("melon_slice", 5,
            class_3620.field_15997, 0.2F, null);
    public static final class_2248 BREAD = createFoodBlock("bread", 5,
            class_3620.field_16013, 0.2F, ModSoundGroups.BREAD);

    // 蔬菜类
    public static final class_2248 BEETROOT = createFoodBlock("beetroot", 5,
            class_3620.field_16020, 0.2F, class_2498.field_27196);
    public static final class_2248 POTATO = createFoodBlock("potato",
            class_3620.field_15994, 0.2F, class_2498.field_27196, 5, EnforceAsItems.POTATO);
    public static final class_2248 BAKED_POTATO = createFoodBlock("baked_potato", 5,
            class_3620.field_15994, 0.2F, class_2498.field_27196);
    public static final class_2248 CARROT = createFoodBlock("carrot",
            class_3620.field_16010, 0.2F, class_2498.field_27196, 5, EnforceAsItems.CARROT);
    public static final class_2248 SWEET_BERRIES = createFoodBlock("sweet_berries",
            class_3620.field_16020, 0.2F, class_2498.field_17579, 5, EnforceAsItems.SWEET_BERRIES);
    public static final class_2248 GLOW_BERRIES = registerFoodBlock("glow_berries", 12,
            class_4970.class_2251.method_9637()
                    .method_31710(class_3620.field_16010)
                    .method_9629(0.2F, 0.2F)
                    .method_22488()
                    .method_9626(class_2498.field_17579)
                    .method_50012(class_3619.field_15971)
                    .method_9631(state -> {
                        if (state.method_26204() instanceof FoodBlock) {
                            return state.method_11654(IntPropertyManager.create("number_of_food", 12)) + 3;
                        }
                        return 0;
                    }),
            ((settings, integer) -> new FoodBlock(settings, integer, EnforceAsItems.GLOW_BERRIES)));

    // 金制食物
    public static final class_2248 GOLDEN_APPLE = createFoodBlock("golden_apple", 5,
            class_3620.field_15994, 0.2F, null);
    public static final class_2248 GOLDEN_CARROT = createFoodBlock("golden_carrot", 5,
            class_3620.field_15994, 0.2F, class_2498.field_27196);
    public static final class_2248 GLISTERING_MELON_SLICE = createFoodBlock("glistering_melon_slice", 5,
            class_3620.field_16024, 0.2F, null);

    // 生熟肉类
    public static final class_2248 CHICKEN = createFoodBlock("chicken", 1,
            class_3620.field_15993, 0.2F, ModSoundGroups.MEAT);
    public static final class_2248 COOKED_CHICKEN = createFoodBlock("cooked_chicken", 1,
            class_3620.field_16013, 0.2F, ModSoundGroups.MEAT);
    public static final class_2248 BEEF = createFoodBlock("beef", 3,
            class_3620.field_15977, 0.3F, ModSoundGroups.MEAT);
    public static final class_2248 COOKED_BEEF = createFoodBlock("cooked_beef", 3,
            class_3620.field_15992, 0.3F, ModSoundGroups.MEAT);
    public static final class_2248 MUTTON = createFoodBlock("mutton", 3,
            class_3620.field_16030, 0.2F, ModSoundGroups.MEAT);
    public static final class_2248 COOKED_MUTTON = createFoodBlock("cooked_mutton", 3,
            class_3620.field_15989, 0.2F, ModSoundGroups.MEAT);
    public static final class_2248 PORKCHOP = createFoodBlock("porkchop", 3,
            class_3620.field_16030, 0.2F, ModSoundGroups.MEAT);
    public static final class_2248 COOKED_PORKCHOP = createFoodBlock("cooked_porkchop", 3,
            class_3620.field_15989, 0.2F, ModSoundGroups.MEAT);
    public static final class_2248 RABBIT = createFoodBlock("rabbit", 1,
            class_3620.field_15977, 0.2F, ModSoundGroups.MEAT);
    public static final class_2248 COOKED_RABBIT = createFoodBlock("cooked_rabbit", 1,
            class_3620.field_15992, 0.2F, ModSoundGroups.MEAT);

    // 鱼类
    public static final class_2248 COD = createFoodBlock("cod", 3,
            class_3620.field_16024, 0.2F, ModSoundGroups.FISH);
    public static final class_2248 COOKED_COD = createFoodBlock("cooked_cod", 3,
            class_3620.field_15991, 0.2F, ModSoundGroups.FISH);
    public static final class_2248 SALMON = createFoodBlock("salmon", 3,
            class_3620.field_16024, 0.2F, ModSoundGroups.FISH);
    public static final class_2248 COOKED_SALMON = createFoodBlock("cooked_salmon", 3,
            class_3620.field_15991, 0.2F, ModSoundGroups.FISH);
    public static final class_2248 PUFFERFISH = createFoodBlock("pufferfish", 1,
            class_3620.field_16024, 0.2F, ModSoundGroups.FISH);

    // 炖菜
    public static final class_2248 RABBIT_STEW = createFoodBlock("rabbit_stew", 1,
            class_3620.field_15977, 0.1F, class_2498.field_42771);
    public static final class_2248 MUSHROOM_STEW = createFoodBlock("mushroom_stew", 1,
            class_3620.field_15977, 0.1F, class_2498.field_42771);
    public static final class_2248 BEETROOT_SOUP = createFoodBlock("beetroot_soup", 1,
            class_3620.field_15977, 0.1F, class_2498.field_42771);
    public static final class_2248 SUSPICIOUS_STEW = registerFoodBlock("suspicious_stew", 1,
            class_4970.class_2251.method_9637()
                    .method_31710(class_3620.field_15977)
                    .method_9629(0.1F, 0.1F)
                    .method_22488()
                    .method_9626(class_2498.field_42771)
                    .method_50012(class_3619.field_15971),
            SuspiciousStewBlock::new);
    public static final class_2248 BOWL = createFoodBlock("bowl", 1,
            class_3620.field_15977, 0.1F, class_2498.field_42771);

    // 桶
    public static final class_2248 BUCKET = createFoodBlock("bucket", 1,
            class_3620.field_16022, 0.2F, ModSoundGroups.BUCKET);
    public static final class_2248 WATER_BUCKET = createFoodBlock("water_bucket", 1,
            class_3620.field_15984, 0.2F, ModSoundGroups.WATER_BUCKET);
    public static final class_2248 MILK_BUCKET = createFoodBlock("milk_bucket", 1,
            class_3620.field_16022, 0.2F, ModSoundGroups.WATER_BUCKET);
    public static final class_2248 LAVA_BUCKET = createFoodBlock("lava_bucket", 1,
            class_3620.field_15987, 0.2F, ModSoundGroups.LAVA_BUCKET);

    // 其他
    public static final class_2248 PUMPKIN_PIE = createFoodBlock("pumpkin_pie", 1,
            class_3620.field_15981, 0.2F, class_2498.field_11543);
    public static final class_2248 CHORUS_FRUIT = registerFoodBlock("chorus_fruit", 5,
            class_4970.class_2251.method_9637()
                    .method_31710(class_3620.field_16014)
                    .method_9629(0.2F, 0.2F)
                    .method_22488()
                    .method_9626(ModSoundGroups.CHORUS_FRUIT)
                    .method_50012(class_3619.field_15971),
            ChorusFruitBlock::new);
    public static final class_2248 EGG = createFoodBlock("egg", 5, class_3620.field_16022, 0.2F, ModSoundGroups.EGG);
    public static final class_2248 TOTEM_OF_UNDYING = registerFoodBlock("totem_of_undying", 1,
            class_4970.class_2251.method_9637()
                    .method_31710(class_3620.field_16010)
                    .method_9629(0.2F, 0.2F)
                    .method_22488()
                    .method_9626(ModSoundGroups.EGG)
                    .method_50012(class_3619.field_15971),
            (settings, foodVal) -> new ModTotemBlock(settings));

    // 药水
    public static final class_2248 POTION = registerFoodBlock("potion", 3,
            class_4970.class_2251.method_9637()
                    .method_31710(class_3620.field_16014)
                    .method_9629(0.2F, 0.2F)
                    .method_22488()
                    .method_26236(class_2246::method_26122)
                    .method_9626(ModSoundGroups.POTION)
                    .method_50012(class_3619.field_15971),
            PotionBlock::new);
    public static final class_2248 GLASS_BOTTLE = createFoodBlock("glass_bottle", 3,
            class_3620.field_16022, 0.2F, ModSoundGroups.POTION);
    public static final class_2248 HONEY_BOTTLE = createFoodBlock("honey_bottle", 3,
            class_3620.field_15987, 0.2F, ModSoundGroups.POTION);

    /**
     * 基础方法：注册食物方块
     *
     * @param id 方块ID
     * @param foodValue 食物值（用于确定最大数量）
     * @param settings 方块设置
     * @param blockCreator 创建方块的函数
     * @return 创建的方块
     */
    private static class_2248 registerFoodBlock(String id, int foodValue, class_4970.class_2251 settings,
                                           BiFunction<class_4970.class_2251, Integer, class_2248> blockCreator) {
        class_2248 block = DFoodUtils.createFoodBlock(foodValue, settings, blockCreator);
        FOOD_BLOCK_REGISTRY.put(id, block);
        return block;
    }

    /**
     * 创建普通食物方块的通用方法
     */
    private static class_2248 createFoodBlock(String id, int foodValue, class_3620 mapColor, float strength, class_2498 sound) {
        return createFoodBlock(id, mapColor, strength, sound, foodValue, null);
    }

    /**
     * 创建普通食物方块的通用方法（作物类型）
     */
    private static class_2248 createFoodBlock(String id, class_3620 mapColor, float strength, class_2498 sound,
                                         int foodValue, FoodBlock.EnforceAsItem cropType) {
        class_4970.class_2251 settings = class_4970.class_2251.method_9637()
                .method_31710(mapColor)
                .method_9629(strength, strength)
                .method_22488()
                .method_50012(class_3619.field_15971);

        if (sound != null) {
            settings = settings.method_9626(sound);
        }

        if (cropType != null) {
            return registerFoodBlock(id, foodValue, settings, (s, foodVal) -> new FoodBlock(s, foodVal, cropType));
        } else {
            return registerFoodBlock(id, foodValue, settings, FoodBlock::new);
        }
    }
}