package org.dfood.block;

import net.minecraft.class_1264;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2551;
import net.minecraft.class_2586;
import net.minecraft.class_2625;
import net.minecraft.class_2680;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3481;
import org.dfood.util.mixin.dFoodSignBlockEntity;

/**
 * 告示牌物品悬挂功能管理器 - 简化版
 * 处理告示牌上物品的悬挂和破坏掉落逻辑
 */
public class ModAbstractSignBlock {

    /**
     * 处理告示牌破坏时的物品掉落
     */
    public static void handleSignBreak(class_1937 world, class_2338 pos, class_1657 player) {
        class_2586 blockEntity = world.method_8321(pos);
        if (!(blockEntity instanceof dFoodSignBlockEntity signEntity)) {
            return;
        }

        // 掉落正面和背面的物品
        dropAllItems(world, pos, signEntity);

        // 返还铁粒
        returnIronNuggets(world, pos, signEntity);

        // 清空数据
        clearSignData(signEntity);
    }

    /**
     * 掉落告示牌上的所有物品
     */
    private static void dropAllItems(class_1937 world, class_2338 pos, dFoodSignBlockEntity signEntity) {
        class_2371<class_1799> items = class_2371.method_10211();

        class_1799 frontItem = signEntity.dFood$getItem(true);
        if (!frontItem.method_7960()) {
            items.add(frontItem.method_7972());
        }

        class_1799 backItem = signEntity.dFood$getItem(false);
        if (!backItem.method_7960()) {
            items.add(backItem.method_7972());
        }

        if (!items.isEmpty()) {
            class_1264.method_17349(world, pos, items);
        }
    }

    /**
     * 返还铁粒
     */
    private static void returnIronNuggets(class_1937 world, class_2338 pos, dFoodSignBlockEntity signEntity) {
        int ironNuggetsToReturn = signEntity.dFood$getIronNuggetsToReturn();

        if (ironNuggetsToReturn > 0) {
            class_2371<class_1799> ironStacks = class_2371.method_10213(1,
                    new class_1799(class_1802.field_8675, ironNuggetsToReturn));
            class_1264.method_17349(world, pos, ironStacks);
        }
    }

    /**
     * 清空告示牌数据
     */
    private static void clearSignData(dFoodSignBlockEntity signEntity) {
        signEntity.dFood$setItem(true, class_1799.field_8037);
        signEntity.dFood$setItem(false, class_1799.field_8037);
    }

    /**
     * 检查是否为有效的告示牌
     */
    public static boolean isValidSign(class_2680 state) {
        return state.method_26164(class_3481.field_15492);
    }

    /**
     * 尝试悬挂物品到告示牌
     */
    public static boolean tryHangItem(class_1937 world, class_2338 pos, class_2680 state,
                                      class_1657 player, class_2625 signBlockEntity) {

        class_1799 mainHandStack = player.method_6047();
        class_1799 offHandStack = player.method_6079();

        // 检查悬挂条件：主手有物品且副手有铁粒
        if (mainHandStack.method_7960() || !offHandStack.method_31574(class_1802.field_8675)) {
            return false;
        }

        boolean isFront = signBlockEntity.method_49834(player);

        // 检查对应面是否有空间
        if (signBlockEntity.dFood$hasItem(isFront)) {
            return false;
        }

        // 检查墙上告示牌的背面限制
        if (state.method_26204() instanceof class_2551 && !isFront) {
            // 墙上告示牌不能在背面悬挂物品
            return false;
        }

        // 尝试添加物品
        class_1799 stackToAdd = mainHandStack.method_7972();
        if (!signBlockEntity.dFood$tryAddItem(isFront, stackToAdd)) {
            return false;
        }

        // 处理悬挂成功逻辑
        processSuccessfulHang(world, pos, state, player, stackToAdd);
        return true;
    }

    /**
     * 处理悬挂成功后的逻辑
     */
    private static void processSuccessfulHang(class_1937 world, class_2338 pos, class_2680 state,
                                              class_1657 player, class_1799 stackToAdd) {

        // 消耗铁粒
        if (!player.method_7337()) {
            class_1799 offHandStack = player.method_6079();
            offHandStack.method_7934(1);
        }

        // 更新玩家物品栏
        if (!player.method_7337()) {
            player.method_6122(class_1268.field_5808, stackToAdd);
        }

        // 播放效果
        world.method_20290(2001, pos, class_2248.method_9507(state));

        // 播放音效
        world.method_8396(null, pos, class_3417.field_24063, class_3419.field_15245, 0.5F, 1.0F);

        // 强制更新方块状态
        world.method_8413(pos, state, state, 3);
    }
}