package org.dfood.item;

import org.jetbrains.annotations.Nullable;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1836;
import net.minecraft.class_1844;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;

public class ModSuspiciousStewItem extends class_1747 {

    public ModSuspiciousStewItem(class_2248 block, class_1793 settings) {
        super(block, settings);
    }

    private static void forEachEffect(class_1799 stew, Consumer<class_1293> effectConsumer) {
        class_2487 nbtCompound = stew.method_7969();
        if (nbtCompound != null && nbtCompound.method_10573("Effects", class_2520.field_33259)) {
            class_2499 nbtList = nbtCompound.method_10554("Effects", class_2520.field_33260);

            for (int i = 0; i < nbtList.size(); i++) {
                class_2487 nbtCompound2 = nbtList.method_10602(i);
                int j;
                if (nbtCompound2.method_10573("EffectDuration", class_2520.field_33263)) {
                    j = nbtCompound2.method_10550("EffectDuration");
                } else {
                    j = 160;
                }

                class_1291 statusEffect = class_1291.method_5569(nbtCompound2.method_10550("EffectId"));
                if (statusEffect != null) {
                    effectConsumer.accept(new class_1293(statusEffect, j));
                }
            }
        }
    }

    @Override
    public void method_7851(class_1799 stack, @Nullable class_1937 world, List<class_2561> tooltip, class_1836 context) {
        super.method_7851(stack, world, tooltip, context);
        if (context.method_47370()) {
            List<class_1293> list = new ArrayList<>();
            forEachEffect(stack, list::add);
            class_1844.method_8065(list, tooltip, 1.0F);
        }
    }

    @Override
    public class_1799 method_7861(class_1799 stack, class_1937 world, class_1309 user) {
        class_1799 itemStack = super.method_7861(stack, world, user);
        forEachEffect(itemStack, user::method_6092);
        return user instanceof class_1657 && ((class_1657)user).method_31549().field_7477 ? itemStack : new class_1799(class_1802.field_8428);
    }
}
