package org.dfood.mixin;

import net.minecraft.block.*;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2338;
import net.minecraft.class_2478;
import net.minecraft.class_2586;
import net.minecraft.class_2625;
import net.minecraft.class_2680;
import net.minecraft.class_3737;
import net.minecraft.class_3965;
import org.dfood.block.ModAbstractSignBlock;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

/**
 * 告示牌物品悬挂功能混入类
 */
@Mixin(class_2478.class)
public abstract class AbstractSignBlockMixin extends class_2237 implements class_3737 {

    protected AbstractSignBlockMixin(class_2251 settings) {
        super(settings);
    }

    @Override
    public void method_9576(class_1937 world, class_2338 pos, class_2680 state, class_1657 player) {
        if (!ModAbstractSignBlock.isValidSign(state)) {
            super.method_9576(world, pos, state, player);
            return;
        }

        if (!world.field_9236) {
            ModAbstractSignBlock.handleSignBreak(world, pos, player);
        }

        super.method_9576(world, pos, state, player);
    }

    @Inject(method = "onUse", at = @At("HEAD"), cancellable = true)
    private void dFood$onUse(class_2680 state, class_1937 world, class_2338 pos,
                             class_1657 player, class_1268 hand, class_3965 hit,
                             CallbackInfoReturnable<class_1269> cir) {

        if (!ModAbstractSignBlock.isValidSign(state) || world.field_9236) {
            return;
        }

        class_2586 blockEntity = world.method_8321(pos);
        if (!(blockEntity instanceof class_2625 signBlockEntity)) {
            return;
        }

        // 尝试悬挂物品
        if (ModAbstractSignBlock.tryHangItem(world, pos, state, player, signBlockEntity)) {
            cir.setReturnValue(class_1269.field_5812);
        }
    }
}