package org.dfood.mixin;

import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1750;
import net.minecraft.class_1838;
import net.minecraft.class_2680;
import org.dfood.util.DFoodUtils;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(class_1747.class)
public abstract class BlockItemMixin{

    @Shadow
    @Nullable
    protected abstract class_2680 getPlacementState(class_1750 context);

    /**
     *阻止玩家在站立状态下放置食物方块，
     * 解决了放置与食用的冲突问题。
     */
    @Inject(method = "useOnBlock", at = @At("HEAD"), cancellable = true)
    private void useOnBlockMixin(class_1838 context, CallbackInfoReturnable<class_1269> cir){
        class_1657 player = context.method_8036();
        class_1750 placementContext = new class_1750(context);
        class_2680 expectedState = getPlacementState(placementContext);

        if (expectedState != null && player != null &&
                !player.method_5715() && DFoodUtils.isModFoodBlock(expectedState.method_26204())) {
            cir.setReturnValue(class_1269.field_5811);
        }
    }
}
