package org.dfood.mixin;

import org.dfood.util.mixin.dFoodSignBlockEntity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.HashSet;
import java.util.Set;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2625;
import net.minecraft.class_2680;

@Mixin(class_2625.class)
public abstract class SignBlockEntityMixin extends class_2586 implements dFoodSignBlockEntity {
    /** 正面物品和背面物品 */
    @Unique
    private class_1799 dFood$frontItem = class_1799.field_8037;
    @Unique
    private class_1799 dFood$backItem = class_1799.field_8037;

    /** 定义允许放入的物品 */
    @Unique
    private static final Set<class_1792> ALLOWED_ITEMS = new HashSet<>();

    static {
        ALLOWED_ITEMS.add(class_1802.field_8429);
        ALLOWED_ITEMS.add(class_1802.field_8373);
        ALLOWED_ITEMS.add(class_1802.field_8209);
        ALLOWED_ITEMS.add(class_1802.field_8509);
    }

    public SignBlockEntityMixin(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    @Inject(method = "readNbt", at = @At("TAIL"))
    private void dFood$readNbt(class_2487 nbt, CallbackInfo ci) {
        // 读取正面物品
        if (nbt.method_10573("dfood_front_item", 10)) {
            this.dFood$frontItem = class_1799.method_7915(nbt.method_10562("dfood_front_item"));
        } else {
            this.dFood$frontItem = class_1799.field_8037;
        }

        // 读取背面物品
        if (nbt.method_10573("dfood_back_item", 10)) {
            this.dFood$backItem = class_1799.method_7915(nbt.method_10562("dfood_back_item"));
        } else {
            this.dFood$backItem = class_1799.field_8037;
        }
    }

    @Inject(method = "writeNbt", at = @At("TAIL"))
    private void dFood$writeNbt(class_2487 nbt, CallbackInfo ci) {
        // 保存正面物品
        if (!this.dFood$frontItem.method_7960()) {
            class_2487 frontNbt = new class_2487();
            this.dFood$frontItem.method_7953(frontNbt);
            nbt.method_10566("dfood_front_item", frontNbt);
        }

        // 保存背面物品
        if (!this.dFood$backItem.method_7960()) {
            class_2487 backNbt = new class_2487();
            this.dFood$backItem.method_7953(backNbt);
            nbt.method_10566("dfood_back_item", backNbt);
        }
    }

    @Override
    public class_1799 dFood$getItem(boolean front) {
        return front ? dFood$frontItem : dFood$backItem;
    }

    @Override
    public void dFood$setItem(boolean front, class_1799 stack) {
        if (front) {
            this.dFood$frontItem = stack;
        } else {
            this.dFood$backItem = stack;
        }
        this.method_5431();

        // 同步数据到客户端
        if (this.field_11863 != null && !this.field_11863.field_9236) {
            this.field_11863.method_8413(this.method_11016(), this.method_11010(), this.method_11010(), 3);
        }
    }

    @Override
    public boolean dFood$tryAddItem(boolean front, class_1799 stack) {

        if (stack.method_7960() || !ALLOWED_ITEMS.contains(stack.method_7909())) {
            return false;
        }

        // 检查对应面是否已有物品
        if (dFood$hasItem(front)) {
            return false;
        }

        // 设置物品（最大堆叠数为1）
        class_1799 singleStack = new class_1799(stack.method_7909(), 1);
        dFood$setItem(front, singleStack);
        stack.method_7934(1);

        return true;
    }

    @Override
    public boolean dFood$hasItem(boolean front) {
        class_1799 item = front ? dFood$frontItem : dFood$backItem;
        return !item.method_7960();
    }

    @Override
    public int dFood$getIronNuggetsToReturn() {
        int count = 0;
        if (!dFood$frontItem.method_7960()) count++;
        if (!dFood$backItem.method_7960()) count++;
        return count;
    }
}