package org.dfood.mixin.client;

import net.minecraft.class_1799;
import net.minecraft.class_2350;
import net.minecraft.class_2383;
import net.minecraft.class_2551;
import net.minecraft.class_2625;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_7833;
import net.minecraft.class_837;
import org.dfood.render.HangingItemTransform;
import org.dfood.util.DFoodUtils;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_837.class)
public class SignBlockEntityRendererMixin {
    @Unique
    private static final float STANDING_Z_OFFSET = 0.01f;
    @Unique
    private static final float WALL_Z_OFFSET = 0.015f;

    @Inject(method = "render(Lnet/minecraft/block/entity/SignBlockEntity;FLnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/VertexConsumerProvider;II)V",
            at = @At("TAIL"))
    private void dFood$renderHangingItems(class_2625 signBlockEntity, float f, class_4587 matrixStack,
                                          class_4597 vertexConsumerProvider, int i, int j, CallbackInfo ci) {
        // 渲染正面物品
        class_1799 frontItem = signBlockEntity.dFood$getItem(true);
        if (!frontItem.method_7960()) {
            renderSideItem(signBlockEntity, frontItem, true, matrixStack, vertexConsumerProvider, i, j);
        }

        // 渲染背面物品
        class_1799 backItem = signBlockEntity.dFood$getItem(false);
        if (!backItem.method_7960()) {
            renderSideItem(signBlockEntity, backItem, false, matrixStack, vertexConsumerProvider, i, j);
        }
    }

    /**
     * 渲染一侧的物品
     * @param signBlockEntity 告示牌方块实体
     * @param stack 需要渲染的物品
     * @param front 是否为正面
     */
    @Unique
    private void renderSideItem(class_2625 signBlockEntity, class_1799 stack,
                                boolean front, class_4587 matrixStack,
                                class_4597 vertexConsumerProvider, int light, int overlay) {
        // 获取物品对应的方块状态
        class_2680 blockState = DFoodUtils.getBlockStateFromItem(stack.method_7909());
        if (blockState == null) {
            return;
        }

        // 获取告示牌的方块状态
        class_2680 signState = signBlockEntity.method_11010();
        boolean isWallSign = signState.method_26204() instanceof class_2551;

        // 计算物品朝向
        class_2350 itemFacing = calculateItemFacing(signState, front);

        matrixStack.method_22903();

        // 根据告示牌类型设置位置
        if (isWallSign) {
            setupWallItemPosition(matrixStack, signState, front, itemFacing);
        } else {
            setupStandingItemPosition(matrixStack, signState, front, itemFacing);
        }

        // 不同的物品应用不同的变换
        HangingItemTransform.applyTransformation(stack, matrixStack, signState, itemFacing);

        // 渲染悬挂物品
        class_310.method_1551().method_1541().method_3353(
                blockState, matrixStack, vertexConsumerProvider, light, overlay
        );

        matrixStack.method_22909();
    }

    /**
     * 计算悬挂物品的朝向
     * @param signState 悬挂的告示牌的方块状态
     * @param front 是否为正面
     * @return 物品朝向
     */
    @Unique
    private class_2350 calculateItemFacing(class_2680 signState, boolean front) {
        boolean isWallSign = signState.method_26204() instanceof class_2551;

        if (isWallSign) {
            // 墙上告示牌：物品朝向与告示牌朝向相同
            return signState.method_11654(class_2383.field_11177);
        } else {
            // 地上告示牌：根据旋转计算朝向
            if (signState.method_28498(class_2741.field_12532)) {
                int rotation = signState.method_11654(class_2741.field_12532);
                float rotationDegrees = -rotation * 22.5f; // 转换为度数（逆时针）

                // 正面物品朝向与告示牌相同，背面物品朝向与告示牌相反
                float itemRotation = front ? rotationDegrees : rotationDegrees + 180f;

                // 标准化角度到0度至360度范围
                itemRotation = (itemRotation % 360 + 360) % 360;

                // 将角度转换为方向
                if (itemRotation >= 45f && itemRotation < 135f) {
                    return class_2350.field_11039;
                } else if (itemRotation >= 135f && itemRotation < 225f) {
                    return class_2350.field_11043;
                } else if (itemRotation >= 225f && itemRotation < 315f) {
                    return class_2350.field_11034;
                } else {
                    return class_2350.field_11035;
                }
            }
        }

        return class_2350.field_11043;
    }

    @Unique
    private void setupStandingItemPosition(class_4587 matrixStack, class_2680 signState, boolean front, class_2350 itemFacing) {
        // 地上告示牌的位置调整
        matrixStack.method_22904(0.5, 0.5, 0.5);

        // 应用告示牌的旋转
        if (signState.method_28498(class_2741.field_12532)) {
            int rotation = signState.method_11654(class_2741.field_12532);
            float rotationDegrees = -rotation * 22.5f;
            matrixStack.method_22907(class_7833.field_40716.rotationDegrees(rotationDegrees));
        }

        // 根据正面/背面设置Z偏移
        float zOffset = front ? -STANDING_Z_OFFSET : STANDING_Z_OFFSET;

        // 物品悬挂在告示牌中心位置
        matrixStack.method_22904(0, 0.4, zOffset);

        if (!front) {
            // 背面物品需要旋转180度来面向外面
            matrixStack.method_22907(class_7833.field_40716.rotationDegrees(180f));
        }
    }

    @Unique
    private void setupWallItemPosition(class_4587 matrixStack, class_2680 signState, boolean front, class_2350 itemFacing) {
        class_2350 signFacing = signState.method_11654(class_2383.field_11177);

        // 中心位置调整
        float wallOffset = 0.44f;
        switch (signFacing) {
            case field_11043 -> matrixStack.method_22904(0.5, 0.5, 0.5 + wallOffset);
            case field_11035 -> matrixStack.method_22904(0.5, 0.5, 0.5 - wallOffset);
            case field_11039 -> matrixStack.method_22904(0.5 + wallOffset, 0.5, 0.5);
            case field_11034 -> matrixStack.method_22904(0.5 - wallOffset, 0.5, 0.5);
        }

        // 应用告示牌的旋转
        float rotationDegrees = switch (signFacing){
            case field_11043 -> 180f;
            case field_11034 -> 90f;
            case field_11035 -> 0f;
            case field_11039 -> 270f;
            default -> 360f;
        };
        matrixStack.method_22907(class_7833.field_40716.rotationDegrees(rotationDegrees));

        // 根据正面/背面设置Z偏移
        float zOffset = front ? -WALL_Z_OFFSET : WALL_Z_OFFSET;

        // 物品悬挂在告示牌中心位置
        matrixStack.method_22904(0, 0.085, zOffset);

        if (!front) {
            // 背面物品需要旋转180度来面向外面
            matrixStack.method_22907(class_7833.field_40716.rotationDegrees(180f));
        }
    }
}