package org.dfood.render;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_4587;
import net.minecraft.class_7833;

public record HangingItemTransform(Consumer<class_4587> transformFunction) {
    private static final Map<class_1792, HangingItemTransform> HANGING_ITEM_TRANSFORMS = new HashMap<>();

    /**
     * 应用物品的特殊变换
     * @param item 对应的物品堆栈
     * @param matrixStack 初始矩阵堆栈
     * @param signState 对应的告示牌方块状态
     * @param itemFacing 方块朝向
     * @apiNote 如果没有对应的变化则不进行任何操作
     */
    public static void applyTransformation(class_1799 item, class_4587 matrixStack, class_2680 signState, class_2350 itemFacing) {
        if (HANGING_ITEM_TRANSFORMS.containsKey(item.method_7909())){
            HANGING_ITEM_TRANSFORMS.get(item.method_7909()).transformFunction().accept(matrixStack);
        }
    }

    static {
        HANGING_ITEM_TRANSFORMS.put(class_1802.field_8429, new HangingItemTransform(matrixStack -> {
            matrixStack.method_46416(-0.44f,  -0.2f, 0.55f);
            matrixStack.method_22907(class_7833.field_40716.rotationDegrees(90f));
        }));
        HANGING_ITEM_TRANSFORMS.put(class_1802.field_8373, new HangingItemTransform(matrixStack -> {
            matrixStack.method_46416(-0.44f,  -0.2f, 0.55f);
            matrixStack.method_22907(class_7833.field_40716.rotationDegrees(90f));
        }));
        HANGING_ITEM_TRANSFORMS.put(class_1802.field_8209, new HangingItemTransform(matrixStack -> {
             matrixStack.method_46416(-0.44f, -0.2f, 0.65f);
             matrixStack.method_22907(class_7833.field_40716.rotationDegrees(90f));
        }));
        HANGING_ITEM_TRANSFORMS.put(class_1802.field_8509, new HangingItemTransform(matrixStack -> {
            matrixStack.method_46416(-0.44f, -0.2f, 0.65f);
            matrixStack.method_22907(class_7833.field_40716.rotationDegrees(90f));
        }));
    }
}
