/*
 * Decompiled with CFR 0.152.
 */
package org.dfood.block;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_181;
import net.minecraft.class_1842;
import net.minecraft.class_1844;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_4970;
import net.minecraft.class_8567;
import org.dfood.block.FoodBlock;
import org.dfood.block.entity.PotionBlockEntity;
import org.jetbrains.annotations.Nullable;

public class PotionBlock
extends FoodBlock
implements class_2343 {
    public PotionBlock(class_4970.class_2251 settings, int max_food) {
        super(settings, max_food);
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new PotionBlockEntity(pos, state);
    }

    public void method_9567(class_1937 world, class_2338 pos, class_2680 state, @Nullable class_1309 placer, class_1799 itemStack) {
        super.method_9567(world, pos, state, placer, itemStack);
        class_2586 blockEntity = world.method_8321(pos);
        if (blockEntity instanceof PotionBlockEntity) {
            PotionBlockEntity potionBlockEntity = (PotionBlockEntity)blockEntity;
            class_2487 stackNbt = itemStack.method_7969();
            if (stackNbt != null) {
                potionBlockEntity.readCustomDataFromItem(stackNbt);
            }
        }
    }

    @Override
    public boolean isSame(class_1799 stack, class_2586 blockEntity) {
        if (blockEntity instanceof PotionBlockEntity) {
            PotionBlockEntity potionBlockEntity = (PotionBlockEntity)blockEntity;
            if (super.isSame(stack, blockEntity)) {
                class_2487 potionStackNbt = potionBlockEntity.getPotionStack().method_7969();
                class_2487 stackNbt = stack.method_7969();
                if (stackNbt != null && potionStackNbt != null && stackNbt.method_10545("Potion") && potionStackNbt.method_10545("Potion")) {
                    return Objects.equals(potionStackNbt.method_10558("Potion"), stackNbt.method_10558("Potion"));
                }
            }
        }
        return false;
    }

    @Override
    public class_1799 createStack(int count, @Nullable class_2586 blockEntity) {
        class_1799 stack = new class_1799((class_1935)class_1802.field_8574, count);
        if (blockEntity instanceof PotionBlockEntity) {
            PotionBlockEntity potionBlockEntity = (PotionBlockEntity)blockEntity;
            return class_1844.method_8061((class_1799)stack, (class_1842)potionBlockEntity.getPotion());
        }
        return stack;
    }

    @Override
    public List<class_1799> method_9560(class_2680 state, class_8567.class_8568 builder) {
        class_2586 blockEntity = (class_2586)builder.method_51876(class_181.field_1228);
        if (blockEntity instanceof PotionBlockEntity) {
            PotionBlockEntity potionBlockEntity = (PotionBlockEntity)blockEntity;
            int count = (Integer)state.method_11654((class_2769)this.NUMBER_OF_FOOD);
            class_1799 baseStack = potionBlockEntity.getPotionStack();
            ArrayList<class_1799> drops = new ArrayList<class_1799>();
            for (int i = 0; i < count; ++i) {
                drops.add(baseStack.method_7972());
            }
            return drops;
        }
        return List.of();
    }
}

