package org.dfood.mixin.client;

import org.dfood.util.DFoodUtils;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import java.util.Objects;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3965;
import net.minecraft.class_636;
import net.minecraft.class_746;

@Mixin(class_636.class)
public class ClientPlayerInteractionManagerMixin {

    /**
     *与服务端的ServerPlayerInteractionManagerMixin同步
     */
    @Inject(method = "interactBlockInternal", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/network/ClientPlayerEntity;shouldCancelInteraction()Z"), cancellable = true)
    private void interactBlockMixin(class_746 player, class_1268 hand, class_3965 hitResult, CallbackInfoReturnable<class_1269> cir) {
        boolean bl3 = DFoodUtils.isModFoodItem(player.method_6047().method_7909());
        if (bl3) {
            class_2338 blockPos = hitResult.method_17777();
            class_2680 blockState = Objects.requireNonNull(((ClientPlayerInteractionManagerAccessor) this).getClient().field_1687).method_8320(blockPos);
            class_1269 actionResult = blockState.method_55781(((ClientPlayerInteractionManagerAccessor) this).getClient().field_1687, player, hitResult);
            if (actionResult.method_23665()) {
                cir.setReturnValue(actionResult);
            }
        }
    }
}
