package org.dfood.mixin;

import org.dfood.block.FoodBlocks;
import org.dfood.item.HaveBlock;
import org.dfood.util.StewToBlocks;
import org.dfood.util.foodToBlocks;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import java.util.function.Function;
import net.minecraft.class_10128;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_9334;

@Mixin(class_1802.class)
public abstract class foodToBlockMixin {

    /**
     * 该Mixin类通过掉换注册方法的Item实例来实现将食物物品转换为对应的方块。
     * <p>
     *     在Minecraft1.21.8版本中，物品的注册方法相比与之前的方法拥有更复杂的重载，
     *     所以本类注入了三个方法来拦截所有需要修改的内容
     * </p>
     */
    @Inject(method = "register(Ljava/lang/String;Lnet/minecraft/item/Item$Settings;)Lnet/minecraft/item/Item;",
            at = @At("HEAD"),
            cancellable = true)
    private static void modifyItem(String id, class_1792.class_1793 settings, CallbackInfoReturnable<class_1792> cir){
        if (foodToBlocks.foodMap.containsKey(id)) {
            cir.setReturnValue(
                    register(id, foodToBlocks.foodMap.get(id))
            );
        }
        else if (foodToBlocks.other.contains(id)) {
            cir.setReturnValue(
                    register(id, StewToBlocks.stewMap.get(id))
            );
        } else if (id.equals("milk_bucket")) {
            cir.setReturnValue(
                    register(id, new class_1747(FoodBlocks.MILK_BUCKET, new class_1792.class_1793().method_7896(class_1802.field_8550)
                            .method_57349(class_9334.field_53964, class_10128.field_53791).method_62834(class_1802.field_8550).method_7889(1)
                            .method_63687().method_63686(class_5321.method_29179(class_7924.field_41197, class_2960.method_60656(id)))))
            );
        }
    }

    @Inject(method = "register(Ljava/lang/String;Ljava/util/function/Function;Lnet/minecraft/item/Item$Settings;)Lnet/minecraft/item/Item;",at = @At("HEAD"),cancellable = true)
    private static void modifyBlockItem(String id, Function<class_1792.class_1793, class_1792> factory, class_1792.class_1793 settings, CallbackInfoReturnable<class_1792> cir){
        if (foodToBlocks.foodMap.containsKey(id)) {
            cir.setReturnValue(
                    register(id, foodToBlocks.foodMap.get(id))
            );
        }
    }

    @Inject(method = "register(Ljava/lang/String;)Lnet/minecraft/item/Item;",at = @At("HEAD"),cancellable = true)
    private static void modifyItem(String id, CallbackInfoReturnable<class_1792> cir){
        if (foodToBlocks.foodMap.containsKey(id)) {
            cir.setReturnValue(
                    register(id, foodToBlocks.foodMap.get(id))
            );
        }
        else if (id.equals("bowl")) {
            cir.setReturnValue(
                    register(id, new class_1747(FoodBlocks.BOWL, new class_1792.class_1793()
                            .method_63687()
                            .method_63686(class_5321.method_29179(class_7924.field_41197, class_2960.method_60656(id)))))
            );
        }
    }

    @Unique
    private static class_1792 register(String id, class_1792 item) {
        if (item instanceof class_1747 blockItem) {
            blockItem.method_7713(class_1792.field_8003, item);
        } else if (item instanceof HaveBlock haveBlock) {
            haveBlock.appendBlocks(class_1792.field_8003, item);
        }

        return class_2378.method_10226(class_7923.field_41178, id, item);
    }
}
