package org.dfood.util;

import net.minecraft.class_10128;
import net.minecraft.class_10216;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1814;
import net.minecraft.class_1844;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_3612;
import net.minecraft.class_4174;
import net.minecraft.class_4176;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import net.minecraft.class_9334;
import net.minecraft.component.type.*;
import net.minecraft.item.*;
import org.dfood.block.FoodBlock;
import org.dfood.block.FoodBlocks;
import org.dfood.item.*;
import org.dfood.mixin.foodToBlockMixin;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;

/**
 * 一个映射类，使开发者可以高度自定义新的Item实例
 * @see foodToBlockMixin
 */
public class foodToBlocks {
    public static final Map<String, class_1792> foodMap = new HashMap<>();
    /**
     * 为了防止在碗物品之前加载炖菜类物品，
     * 所以使用字符串来判断炖菜类物品
     */
    public static final Set<String> other = Set.of("rabbit_stew", "mushroom_stew", "beetroot_soup", "suspicious_stew");

    static {
        // 零食类
        put("cookie", FoodBlocks.COOKIE, class_4176.field_18655);
        put("apple", FoodBlocks.APPLE, class_4176.field_18638);
        put("melon_slice", FoodBlocks.MELON_SLICE, class_4176.field_18660);
        put("bread", FoodBlocks.BREAD, class_4176.field_18643);

        // 蔬菜类
        put("beetroot", FoodBlocks.BEETROOT, class_4176.field_18641);
        put("potato", new class_1792.class_1793().method_19265(class_4176.field_18627),
                settings -> new DoubleBlockItem(class_2246.field_10247, settings, FoodBlocks.POTATO));
        put("baked_potato", FoodBlocks.BAKED_POTATO, class_4176.field_18639);
        put("carrot", new class_1792.class_1793().method_19265(class_4176.field_18644),
                settings -> new DoubleBlockItem(class_2246.field_10609, settings, FoodBlocks.CARROT));
        put("sweet_berries", new class_1792.class_1793().method_19265(class_4176.field_18636),
                settings -> new DoubleBlockItem(class_2246.field_16999, settings, FoodBlocks.SWEET_BERRIES));
        put("glow_berries", new class_1792.class_1793().method_19265(class_4176.field_28647),
                settings -> new DoubleBlockItem(class_2246.field_28675, settings, FoodBlocks.GLOW_BERRIES));

        // 金制食物
        put("golden_apple", FoodBlocks.GOLDEN_APPLE, class_4176.field_18658);
        put("golden_carrot", FoodBlocks.GOLDEN_CARROT, class_4176.field_18659);
        put("glistering_melon_slice", FoodBlocks.GLISTERING_MELON_SLICE, new class_1792.class_1793());

        // 生熟肉类
        put("chicken", FoodBlocks.CHICKEN, new class_1792.class_1793().method_62833(class_4176.field_18645, class_10128.field_53784));
        put("cooked_chicken", FoodBlocks.COOKED_CHICKEN, class_4176.field_18649);
        put("beef", FoodBlocks.BEEF, class_4176.field_18640);
        put("cooked_beef", FoodBlocks.COOKED_BEEF, class_4176.field_18648);
        put("mutton", FoodBlocks.MUTTON, class_4176.field_18662);
        put("cooked_mutton", FoodBlocks.COOKED_MUTTON, class_4176.field_18651);
        put("porkchop", FoodBlocks.PORKCHOP, class_4176.field_18626);
        put("cooked_porkchop", FoodBlocks.COOKED_PORKCHOP, class_4176.field_18652);
        put("rabbit", FoodBlocks.RABBIT, class_4176.field_18630);
        put("cooked_rabbit", FoodBlocks.COOKED_RABBIT, class_4176.field_18653);

        // 鱼类
        put("cod", FoodBlocks.COD, class_4176.field_18647);
        put("cooked_cod", FoodBlocks.COOKED_COD, class_4176.field_18650);
        put("salmon", FoodBlocks.SALMON, class_4176.field_18633);
        put("cooked_salmon", FoodBlocks.COOKED_SALMON, class_4176.field_18654);
        put("pufferfish", FoodBlocks.PUFFERFISH, new class_1792.class_1793().method_62833(class_4176.field_18628, class_10128.field_53788).method_62832(1.0F));

        // 桶
        put("bucket", new class_1792.class_1793().method_7889(16).method_63687(),
                settings -> new ModBucketItem(class_3612.field_15906, settings, FoodBlocks.BUCKET));
        put("water_bucket", new class_1792.class_1793().method_7889(1).method_63687(),
                settings -> new ModBucketItem(class_3612.field_15910, settings, FoodBlocks.WATER_BUCKET));

        // 其他
        put("pumpkin_pie", FoodBlocks.PUMPKIN_PIE, class_4176.field_18629);
        put("chorus_fruit", FoodBlocks.CHORUS_FRUIT, new class_1792.class_1793().method_62833(class_4176.field_18646, class_10128.field_53792).method_62832(1.0F));
        put("egg", new class_1792.class_1793(), settings -> new ModEggItem(FoodBlocks.EGG, settings));
        put("totem_of_undying", FoodBlocks.TOTEM_OF_UNDYING, new class_1792.class_1793().method_7889(1).method_7894(class_1814.field_8907)
                .method_57349(class_9334.field_54274, class_10216.field_54233)
                .method_63687());

        // 药水类
        put("potion",new class_1792.class_1793().method_7889(1)
                        .method_57349(class_9334.field_49651, class_1844.field_49274)
                        .method_57349(class_9334.field_53964, class_10128.field_53780)
                        .method_63687(),
                settings -> new ModPotionItem(FoodBlocks.POTION, settings));
    }

    public static void put(String id, class_2248 block, class_1792.class_1793 settings) {
        put(id, settings.method_63687(), settings1 -> new class_1747(block, settings));
    }

    public static void put(String id, class_2248 block, class_4174 foodComponent) {
        put(id, block, new class_1792.class_1793().method_19265(foodComponent).method_63687());
    }

    /**
     * 基本的定义物品的方法
     * @param id 物品的 id
     * @param settings 物品设置
     * @param creator 物品的构造器
     */
    private static void put(String id, class_1792.class_1793 settings, Function<class_1792.class_1793, class_1792> creator){
        class_5321<class_1792> key = class_5321.method_29179(class_7924.field_41197, class_2960.method_60656(id));
        class_1792 item = creator.apply(settings.method_63686(key));

        foodMap.put(id, item);
    }
}
