package org.dfood.mixin.client;

import net.minecraft.class_1920;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_324;
import org.dfood.block.FoodBlocks;
import org.dfood.block.entity.PotionBlockEntity;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyVariable;

@Mixin(class_324.class)
public class BlockColorsMixin {
    @ModifyVariable(method = "create", at = @At("RETURN"))
    private static class_324 registerBlockColor(class_324 blockColors) {
        blockColors.method_1690(BlockColorsMixin::getPotionColor, FoodBlocks.POTION);
        blockColors.method_1690((state, world, pos, tintIndex) -> tintIndex != -1? 4159204: -1, FoodBlocks.WATER_BUCKET);
        return blockColors;
    }

    @Unique
    private static int getPotionColor(class_2680 state, @Nullable class_1920 world, @Nullable class_2338 pos, int tintIndex){
        if (world != null && tintIndex != -1) {
            class_2586 blockEntity = world.method_8321(pos);
            if (blockEntity instanceof PotionBlockEntity potionBlockEntity) {
                return potionBlockEntity.getColor();
            }
        }
        return -1;
    }
}
