package org.dfood.util;

import org.dfood.block.FoodBlock;
import org.dfood.item.DoubleBlockItem;
import org.dfood.item.HaveBlock;

import java.util.function.BiFunction;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import net.minecraft.class_4970;

public class DFoodUtils {
    /**
     * 检查物品是否是模组添加的食物方块
     * @param item 要检查的物品
     * @return 是否是模组添加的食物方块
     */
    public static boolean isModFoodItem(class_1792 item) {
        class_2680 state = getBlockStateFromItem(item);
        if (state == null) return false;

        if (state.method_26204() instanceof FoodBlock block){
            return FoodBlock.FOOD_BLOCKS.contains(block);
        }

        return false;
    }

    /**
     * 检查物品是否是模组添加的食物方块
     * @param block 要检查的方块
     * @return 是否是模组添加的食物方块
     */
    public static boolean isModFoodBlock(class_2248 block){
        if (block instanceof FoodBlock foodBlock){
            return FoodBlock.FOOD_BLOCKS.contains(foodBlock);
        }

        return false;
    }

    /**
     * 检查物品是否是模组添加的特殊方块物品
     * @param item 要检查的物品
     * @return 是否是模组添加的特殊方块物品
     */
    public static boolean isHaveBlock(class_1792 item) {
        return item instanceof HaveBlock;
    }

    /**
     * 检查方块是否强制定义了asItem方法的返回值
     * @param state 要检查的方块状态
     * @return 方块是否强制定义了asItem方法的返回值
     */
    private static boolean HaveCItem(class_2680 state) {
        return state.method_26204() instanceof FoodBlock foodBlock && foodBlock.haveCItem();
    }

    /**
     * 辅助方法
     * @param item 要转换的物品
     * @return 对应的默认方块状态
     */
    private static class_2680 getBlockStateFromItem(class_1792 item) {
        if (item instanceof DoubleBlockItem doubleBlockItem){
            return doubleBlockItem.getSecondBlock().method_9564();
        }
        if (item instanceof class_1747 blockItem) {
            return blockItem.method_7711().method_9564();
        }
        if (item instanceof HaveBlock haveBlock) {
            return haveBlock.getBlock().method_9564();
        }
        return null;
    }

    /**
     * 创建一个基本的食物方块
     * @param foodValue 食物方块的堆叠数量
     * @param settings 方块设置
     * @param blockCreator 食物方块的构造器
     * @return 一个新的食物方块
     */
    public static class_2248 createFoodBlock(int foodValue, class_4970.class_2251 settings,
                                        BiFunction<class_4970.class_2251, Integer, class_2248> blockCreator) {
        IntPropertyManager.preCache("number_of_food", foodValue);
        return blockCreator.apply(settings, foodValue);
    }
}