package org.dfood.block;

import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import net.minecraft.class_2586;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2753;
import net.minecraft.class_2758;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_7923;
import net.minecraft.class_8567;
import net.minecraft.util.*;
import org.dfood.shape.FoodShapeHandle;
import org.dfood.tag.ModTags;
import org.dfood.util.DFoodUtils;
import org.dfood.util.IntPropertyManager;
import org.jetbrains.annotations.Nullable;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/**
 * 所有食物方块的父类，定义了食物方块的基本行为
 */
public class FoodBlock extends class_2248 {
    public static final Set<FoodBlock> FOOD_BLOCKS = new HashSet<>();
    public static final class_2753 FACING = class_2741.field_12481;
    protected static final FoodShapeHandle SHAPE_HANDLE = FoodShapeHandle.getInstance();

    public final class_2758 NUMBER_OF_FOOD;
    public final int MAX_FOOD;
    /** 用于强制指定该方块{@link FoodBlock#method_8389()}方法的返回值，一般用于双方块物品的第二个方块 */
    @Nullable private EnforceAsItem cItem;
    private onUseHook onUseHook = (state, world, pos, player, hit) -> class_1269.field_5811;

    public onUseHook getOnUseHook() {
        return onUseHook;
    }

    public void setOnUseHook(onUseHook onUseHook) {
        this.onUseHook = onUseHook;
    }

    public FoodBlock(class_2251 settings, int max_food, boolean isFood) {
        super(settings);
        MAX_FOOD = max_food;
        NUMBER_OF_FOOD = IntPropertyManager.create("number_of_food", MAX_FOOD);
        if (isFood){
            FOOD_BLOCKS.add(this);
        }
        this.method_9590(this.method_9595().method_11664()
                .method_11657(FACING, class_2350.field_11043)
                .method_11657(NUMBER_OF_FOOD, 1));
    }

    public FoodBlock(class_2251 settings, int max_food){
        this(settings, max_food, true);
    }

    public FoodBlock(class_2251 settings, int max_food, @Nullable EnforceAsItem cItem) {
        this(settings, max_food);
        this.cItem = cItem;
    }

    /**
     * 检查该方块是否指定了强制的对应物品
     * @return 如果指定了强制的对应物品则返回true,否则返回false
     */
    public boolean haveCItem(){
        return this.cItem != null;
    }

    @Override
    public String method_9539() {
        return class_156.method_646("item", class_7923.field_41175.method_10221(this));
    }

    @Override
    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return SHAPE_HANDLE.getShape(state, NUMBER_OF_FOOD);
    }

    @Override
    public float method_9575(class_2680 state, class_1922 world, class_2338 pos) {
        return 1.0F;
    }

    @Override
    public @Nullable class_2680 method_9605(class_1750 ctx) {
        return this.method_9564()
                .method_11657(FACING, ctx.method_8042())
                .method_11657(NUMBER_OF_FOOD, 1);
    }

    @Override
    public class_1269 method_55766(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_3965 hit) {
        // 调用自定义钩子
        class_1269 HookResult = this.onUseHook.interact(state, world, pos, player, hit);
        if (HookResult != class_1269.field_5811) {
            return HookResult;
        }

        class_1268 hand = player.method_6058();
        class_1799 handStack = player.method_5998(hand);
        int currentCount = state.method_11654(NUMBER_OF_FOOD);
        class_2586 blockEntity = world.method_8321(pos);
        boolean isSameItem = isSame(handStack, blockEntity);
        boolean tryFetch = false;

        // 客户端只负责播放声音和返回结果
        if (world.field_9236) {
            if (isSameItem && currentCount < MAX_FOOD) {
                playSound(this.field_23162.method_10598(), world, pos, player);
            } else if (!isSameItem && currentCount > 0) {
                playSound(this.field_23162.method_10595(), world, pos, player);
            }
            return class_1269.field_5812;
        }

        // 手持相同物品 - 尝试添加
        if (isSameItem) {
            if (currentCount < MAX_FOOD) {
                if (tryAdd(state, world, pos, player, handStack, blockEntity)) {
                    playSound(this.field_23162.method_10598(), world, pos, player);

                    // 消耗物品（非创造模式）
                    if (!player.method_7337()) {
                        handStack.method_7934(1);
                        player.method_6122(hand, handStack);
                    }
                    return class_1269.field_5812;
                }
            }
            tryFetch = true; // 已达最大数量，尝试取出
        }

        // 其他物品/空手 - 尝试取出
        if (currentCount > 0 || tryFetch) {
            if (tryRemove(state, world, pos, player, blockEntity)) {
                playSound(this.field_23162.method_10595(), world, pos, player);
                return class_1269.field_5812;
            }
        }

        return class_1269.field_5811;
    }

    /**
     * 尝试增加堆叠数量
     * @param state 当前的方块状态
     * @param world 当前世界
     * @param pos 方块的位置
     * @param player 执行操作的玩家
     * @param handStack 尝试添加的物品堆栈
     * @param blockEntity 对应的方块实体
     * @return 操作是否成功
     */
    protected boolean tryAdd(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1799 handStack, class_2586 blockEntity) {
        int currentCount = state.method_11654(NUMBER_OF_FOOD);
        class_2680 newState = state.method_11657(NUMBER_OF_FOOD, currentCount + 1);
        return world.method_8652(pos, newState, class_2248.field_31036);
    }

    /**
     * 尝试减少方块的堆叠数量
     * @param world 当前世界
     * @param pos 方块的位置
     * @param player 执行操作的玩家
     * @param blockEntity 对应的方块实体
     * @return 操作是否成功
     */
    protected boolean tryRemove(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_2586 blockEntity) {
        int currentCount = state.method_11654(NUMBER_OF_FOOD);
        int newCount = currentCount - 1;

        if (newCount > 0) {
            class_2680 newState = state.method_11657(NUMBER_OF_FOOD, newCount);
            world.method_8652(pos, newState, class_2248.field_31036);
        } else {
            world.method_22352(pos, false);
        }

        // 给予玩家物品（非创造模式）
        if (!player.method_7337()) {
            class_1799 foodItem = createStack(1, blockEntity);
            if (!player.method_7270(foodItem)) {
                player.method_7328(foodItem, false);
            }
        }

        return true;
    }

    /**
     * 检查手持物品是否与方块匹配
     * @param stack 手持物品堆栈
     * @param blockEntity 对应的方块实体
     * @return 匹配放回true,否则返回false
     */
    public boolean isSame(class_1799 stack, class_2586 blockEntity) {
        return stack.method_7909() == this.method_8389();
    }

    /**
     * 根据数量创建对应的物品堆栈
     * @param count 数量
     * @param blockEntity 对应的方块实体
     * @return 创建成功的物品堆栈
     */
    public class_1799 createStack(int count, @Nullable class_2586 blockEntity) {
        if (count <= 0 || count > MAX_FOOD) {
            throw new IllegalArgumentException("Count must be between 1 and " + MAX_FOOD);
        }
        return new class_1799(this.method_8389(), count);
    }

    public void playSound(class_3414 event, class_1937 world, class_2338 pos, class_1657 player) {
        world.method_8396(player, pos, this.field_23162.method_10598(), class_3419.field_15245, 1, world.method_8409().method_43057() * 0.1F + 0.9F);
    }

    @Override
    public class_2680 method_9559(
            class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 world, class_2338 pos, class_2338 neighborPos
    ) {
        return !state.method_26184(world, pos)
                ? class_2246.field_10124.method_9564()
                : super.method_9559(state, direction, neighborState, world, pos, neighborPos);
    }

    @Override
    public boolean method_9558(class_2680 state, class_4538 world, class_2338 pos) {
        class_2338 downPos = pos.method_10074();
        class_2680 checkState = world.method_8320(downPos);
        return !checkState.method_26164(ModTags.FOOD_PLACE) && !(DFoodUtils.isModFoodBlock(checkState.method_26204()));
    }

    /**
     *硬编码掉落物
     */
    @Override
    public List<class_1799> method_9560(class_2680 state, class_8567.class_8568 builder) {
        int foodCount = state.method_11654(NUMBER_OF_FOOD);

        // 当数量为0时，不返回任何物品
        if (foodCount <= 0) {
            return Collections.emptyList();
        }

        // 创建包含正确数量的物品堆栈
        return Collections.singletonList(new class_1799(this.method_8389(), foodCount));
    }

    @Override
    public class_1792 method_8389() {
        if (this.cItem != null){
            return cItem.getItem();
        }
        return super.method_8389();
    }

    @Override
    public class_2680 method_9598(class_2680 state, class_2470 rotation) {
        return state.method_11657(FACING, rotation.method_10503(state.method_11654(FACING)));
    }

    @Override
    public class_2680 method_9569(class_2680 state, class_2415 mirror) {
        return state.method_26186(mirror.method_10345(state.method_11654(FACING)));
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(FACING);
        builder.method_11667(IntPropertyManager.take());
    }

    @FunctionalInterface
    public interface onUseHook{
        class_1269 interact(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_3965 hit);
    }

    public interface EnforceAsItem {
        class_1792 getItem();
    }
}