package org.dfood.block;

import org.dfood.block.entity.SuspiciousStewBlockEntity;
import org.jetbrains.annotations.Nullable;

import java.util.List;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_181;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_8567;
import net.minecraft.class_9298;
import net.minecraft.class_9334;

public class SuspiciousStewBlock extends FoodBlock implements class_2343 {

    public SuspiciousStewBlock(class_2251 settings, int max_food) {
        super(settings, max_food);
    }

    @Override
    public @Nullable class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new SuspiciousStewBlockEntity(pos, state);
    }

    @Override
    public void method_9567(class_1937 world, class_2338 pos, class_2680 state, @Nullable class_1309 placer, class_1799 itemStack) {
        super.method_9567(world, pos, state, placer, itemStack);
        if (!world.field_9236) {
            class_2586 blockEntity = world.method_8321(pos);
            if (blockEntity instanceof SuspiciousStewBlockEntity suspiciousStewBlockEntity) {
                class_9298 stewEffect = itemStack.method_57824(class_9334.field_49652);
                if (stewEffect != null) {
                    suspiciousStewBlockEntity.readCustomDataFromItem(stewEffect);
                }
            }
        }
    }

    @Override
    public boolean isSame(class_1799 stack, class_2586 blockEntity) {
        if (blockEntity instanceof SuspiciousStewBlockEntity suspiciousStewBlockEntity && super.isSame(stack, blockEntity)) {
            class_9298 blockEntityEffects = suspiciousStewBlockEntity.createStewEffectsComponent();
            class_9298 stackEffects = stack.method_57824(class_9334.field_49652);

            // 如果都没有效果，认为是相同的
            if (blockEntityEffects == class_9298.field_49362 && stackEffects == null) {
                return true;
            }

            // 如果只有一个有效果，认为不相同
            if (blockEntityEffects == class_9298.field_49362 || stackEffects == null) {
                return false;
            }

            // 比较效果列表是否相同
            return blockEntityEffects.equals(stackEffects);
        }
        return false;
    }

    @Override
    public class_1799 createStack(int count, @Nullable class_2586 blockEntity) {
        class_1799 stack = new class_1799(class_1802.field_8766, count);

        if (blockEntity instanceof SuspiciousStewBlockEntity suspiciousStewBlockEntity) {
            // 将方块实体中的效果写入物品组件
            class_9298 component = suspiciousStewBlockEntity.createStewEffectsComponent();
            if (component != class_9298.field_49362) {
                stack.method_57379(class_9334.field_49652, component);
            }
        }

        return stack;
    }

    @Override
    public List<class_1799> method_9560(class_2680 state, class_8567.class_8568 builder) {
        class_2586 blockEntity = builder.method_51876(class_181.field_1228);

        if (blockEntity instanceof SuspiciousStewBlockEntity suspiciousStewBlockEntity) {
            int count = state.method_11654(NUMBER_OF_FOOD);
            class_1799 baseStack = suspiciousStewBlockEntity.getStewStack();
            List<class_1799> drops = new java.util.ArrayList<>();

            for (int i = 0; i < count; i++) {
                drops.add(baseStack.method_7972());
            }

            return drops;
        }

        // 没有方块实体时，返回空列表
        return List.of();
    }
}